/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.editor.cplusplus.BracketCompletion;
import org.netbeans.modules.cnd.editor.cplusplus.CppTypingCompletion;
import org.netbeans.modules.cnd.editor.indent.HotCharIndent;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;
import org.openide.util.Exceptions;

public class CppTTIFactory
implements TypedTextInterceptor.Factory {
    public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
        return new TypedTextInterceptorImpl();
    }

    private static class TypedTextInterceptorImpl
    implements TypedTextInterceptor {
        private CppTypingCompletion.ExtraText rawStringText = null;
        private int caretPosition;

        public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
            this.rawStringText = null;
            this.caretPosition = -1;
            return false;
        }

        public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
            BaseDocument doc = (BaseDocument)context.getDocument();
            if (!BracketCompletion.completionSettingEnabled((Document)doc)) {
                return;
            }
            this.rawStringText = CppTypingCompletion.checkRawStringInsertion(context);
            if (this.rawStringText == null) {
                char insertedChar = context.getText().charAt(0);
                switch (insertedChar) {
                    case '(': 
                    case '<': 
                    case '[': {
                        BracketCompletion.completeOpeningBracket(context);
                        break;
                    }
                    case ')': 
                    case '>': 
                    case ']': {
                        this.caretPosition = BracketCompletion.skipClosingBracket(context);
                    }
                }
            }
        }

        public void afterInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
            final BaseDocument doc = (BaseDocument)context.getDocument();
            doc.runAtomicAsUser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (TypedTextInterceptorImpl.this.rawStringText != null) {
                        int caretPosition = TypedTextInterceptorImpl.this.rawStringText.getCaretPosition();
                        if (caretPosition != -1) {
                            String txt = TypedTextInterceptorImpl.this.rawStringText.getExtraText();
                            if (txt != null) {
                                try {
                                    int shift = caretPosition < TypedTextInterceptorImpl.this.rawStringText.getExtraTextPostion() ? 1 : 0;
                                    doc.insertString(TypedTextInterceptorImpl.this.rawStringText.getCaretPosition(), txt, null);
                                    doc.insertString(TypedTextInterceptorImpl.this.rawStringText.getExtraTextPostion() + shift, txt, null);
                                    ++caretPosition;
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            if (context.getOffset() != caretPosition) {
                                context.getComponent().setCaretPosition(caretPosition);
                            }
                        }
                    } else if (TypedTextInterceptorImpl.this.caretPosition != -1) {
                        context.getComponent().setCaretPosition(TypedTextInterceptorImpl.this.caretPosition);
                        TypedTextInterceptorImpl.this.caretPosition = -1;
                    } else {
                        String typedText;
                        int offset = context.getOffset();
                        if (HotCharIndent.INSTANCE.getKeywordBasedReformatBlock(doc, offset, typedText = context.getText())) {
                            Indent indent = Indent.get((Document)doc);
                            indent.lock();
                            try {
                                doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.TRUE);
                                indent.reindent(offset);
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            finally {
                                doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.FALSE);
                                indent.unlock();
                            }
                        } else {
                            TokenSequence ts;
                            Caret caret = context.getComponent().getCaret();
                            boolean blockCommentStart = false;
                            if (offset > 0 && typedText.charAt(0) == '*' && (ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)(offset - 1), (boolean)true, (boolean)false)) != null && ts.token().id() == CppTokenId.BLOCK_COMMENT) {
                                int offsetToken = ts.offset();
                                CharSequence text = ts.token().text();
                                blockCommentStart = true;
                                while (ts.movePrevious()) {
                                    TokenId id = ts.token().id();
                                    if (id == CppTokenId.WHITESPACE) continue;
                                    blockCommentStart = id == CppTokenId.NEW_LINE || id == CppTokenId.PREPROCESSOR_DIRECTIVE || id == CppTokenId.ESCAPED_LINE;
                                    break;
                                }
                                if (blockCommentStart) {
                                    int delta = offset - offsetToken;
                                    String[] split = text.toString().split("\n");
                                    if (split.length > 0) {
                                        String s = split[0];
                                        if (!s.trim().equals("/*")) {
                                            blockCommentStart = false;
                                        }
                                        if (delta >= s.length()) {
                                            blockCommentStart = false;
                                        }
                                    }
                                }
                            }
                            try {
                                BracketCompletion.charInserted(doc, offset, caret, typedText.charAt(0), blockCommentStart);
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
            });
        }

        public void cancelled(TypedTextInterceptor.Context context) {
        }
    }
}

