/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.ide.ergonomics.fod.BrokenProjectInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class ConfigurationPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 27938464212508L;
    final DownloadProgressMonitor progressMonitor = new DownloadProgressMonitor();
    private FeatureInfo featureInfo;
    private Callable<JComponent> callable;
    private final Boolean autoActivate;
    private JButton downloadButton;
    private JEditorPane errorLabel;
    private JLabel infoLabel;
    private JPanel progressPanel;

    public ConfigurationPanel(String displayName, Callable<JComponent> callable, FeatureInfo info, Boolean auto) {
        this(callable, auto);
        this.setInfo(info);
        this.setPanelName(displayName);
    }

    public ConfigurationPanel(Callable<JComponent> callable, Boolean auto) {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.featureInfo = null;
        this.callable = callable;
        this.autoActivate = auto;
        this.setError(" ");
    }

    public void setInfo(FeatureInfo info) {
        this.featureInfo = info;
        boolean activateNow = this.autoActivate != null ? Boolean.TRUE.equals(this.autoActivate) : Boolean.getBoolean("noActivateButton");
        if (activateNow) {
            this.infoLabel.setVisible(false);
            this.downloadButton.setVisible(false);
            this.downloadButtonActionPerformed(null);
        }
    }

    public void setPanelName(String displayName) {
        FeatureManager.logUI("ERGO_QUESTION", this.featureInfo.clusterName, displayName);
        String lblMsg = null;
        String btnMsg = null;
        if (this.featureInfo != null && this.featureInfo.isPresent()) {
            lblMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_EnableInfo", (Object)displayName);
            btnMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_Enable");
        } else {
            lblMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_DownloadInfo", (Object)displayName);
            btnMsg = NbBundle.getMessage(ConfigurationPanel.class, (String)"LBL_Download");
        }
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)lblMsg);
        Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)btnMsg);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        FeatureManager.logUI("ERGO_CLOSE", new Object[0]);
    }

    void setError(String msg) {
        assert (SwingUtilities.isEventDispatchThread());
        this.errorLabel.setText(msg);
    }

    private void initComponents() {
        this.errorLabel = BrokenProjectInfo.getErrorPane("dummy");
        this.infoLabel = new JLabel();
        this.downloadButton = new JButton();
        this.progressPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)"dummy");
        Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)"dummy");
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.downloadButtonActionPerformed(evt);
            }
        });
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 3));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressPanel, -1, 374, Short.MAX_VALUE).addComponent(this.infoLabel).addComponent(this.downloadButton).addComponent(this.errorLabel, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.errorLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadButton).addGap(18, 18, 18).addComponent(this.progressPanel, -1, 131, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void run() {
        ModulesInstaller.installModules(this.progressMonitor, this.featureInfo);
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        FeatureManager.logUI("ERGO_DOWNLOAD", new Object[0]);
        this.downloadButton.setEnabled(false);
        RequestProcessor.Task task = FeatureManager.getInstance().create(this);
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                if (!ConfigurationPanel.this.progressMonitor.error) {
                    SwingUtilities.invokeLater(new Runnable(){
                        private String msg;

                        @Override
                        public void run() {
                            ConfigurationPanel.this.removeAll();
                            ConfigurationPanel.this.setLayout(new BorderLayout());
                            try {
                                ConfigurationPanel.this.add((Component)ConfigurationPanel.this.callable.call(), "Center");
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            ConfigurationPanel.this.invalidate();
                            ConfigurationPanel.this.revalidate();
                            ConfigurationPanel.this.repaint();
                            this.msg = ConfigurationPanel.this.featureInfo != null && ConfigurationPanel.this.featureInfo.isPresent() ? NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_EnableFailed") : NbBundle.getMessage(ConfigurationPanel.class, (String)"MSG_DownloadFailed");
                            ConfigurationPanel.this.setError(this.msg);
                            ConfigurationPanel.this.downloadButton.setEnabled(true);
                            ConfigurationPanel.this.progressPanel.removeAll();
                            ConfigurationPanel.this.progressPanel.revalidate();
                            ConfigurationPanel.this.progressPanel.repaint();
                        }
                    });
                }
            }
        });
        task.schedule(0);
    }

    private final class DownloadProgressMonitor
    implements ProgressMonitor {
        private boolean error = false;

        private DownloadProgressMonitor() {
        }

        @Override
        public void onDownload(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onValidate(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onInstall(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        @Override
        public void onEnable(ProgressHandle progressHandle) {
            this.updateProgress(progressHandle);
        }

        private void updateProgress(ProgressHandle progressHandle) {
            final JLabel tmpMainLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
            final JComponent tmpProgressPanel = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationPanel.this.progressPanel.removeAll();
                    ConfigurationPanel.this.progressPanel.add(tmpMainLabel);
                    ConfigurationPanel.this.progressPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                    ConfigurationPanel.this.progressPanel.add(tmpProgressPanel);
                    ConfigurationPanel.this.progressPanel.revalidate();
                    ConfigurationPanel.this.progressPanel.repaint();
                }
            });
        }

        @Override
        public void onError(final String message) {
            this.error = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationPanel.this.setError("<html>" + message + "</html>");
                    ConfigurationPanel.this.progressPanel.removeAll();
                    ConfigurationPanel.this.progressPanel.add(ConfigurationPanel.this.errorLabel);
                }
            });
        }
    }
}

