/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.osgi;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.openide.util.Enumerations;
import org.openide.util.NbCollections;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class OSGiClassLoader
extends ClassLoader {
    private final BundleContext context;
    private final Set<? extends Bundle> loadedBundles;
    private final Bundle bundle;

    public OSGiClassLoader(BundleContext context, Set<? extends Bundle> loadedBundles) {
        super(ClassLoader.getSystemClassLoader().getParent());
        this.context = context;
        this.loadedBundles = loadedBundles;
        this.bundle = null;
    }

    public OSGiClassLoader(Bundle bundle) {
        super(ClassLoader.getSystemClassLoader().getParent());
        this.context = null;
        this.loadedBundles = null;
        this.bundle = bundle;
    }

    private Iterable<Bundle> bundles() {
        if (this.context != null) {
            Object[] bundles;
            try {
                bundles = this.context.getBundles();
            }
            catch (IllegalStateException x) {
                return Collections.emptySet();
            }
            return NbCollections.iterable((Enumeration)Enumerations.concat((Enumeration)Enumerations.filter((Enumeration)Enumerations.array((Object[])bundles), (Enumerations.Processor)new Enumerations.Processor<Bundle, Bundle>(){

                public Bundle process(Bundle b, Collection<Bundle> _) {
                    if (b.getBundleId() == 0L) {
                        return null;
                    }
                    if (b.getState() == 2) {
                        return null;
                    }
                    if (!OSGiClassLoader.this.loadedBundles.contains(b)) {
                        return null;
                    }
                    return b;
                }
            }), (Enumeration)Enumerations.singleton((Object)this.context.getBundle(0L))));
        }
        return Collections.singleton(this.bundle);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (Bundle b : this.bundles()) {
            try {
                return b.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.findClass(name);
    }

    @Override
    protected URL findResource(String name) {
        for (Bundle b : this.bundles()) {
            URL resource = b.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<Enumeration> resourcess = new ArrayList<Enumeration>();
        for (Bundle b : this.bundles()) {
            Enumeration resources;
            Enumeration resourcesRaw = b.getResources(name);
            if (resourcesRaw == null || (resources = NbCollections.checkedEnumerationByFilter((Enumeration)resourcesRaw, URL.class, (boolean)true)) == null) continue;
            resourcess.add(resources);
        }
        return Enumerations.concat(Collections.enumeration(resourcess));
    }

    public String toString() {
        if (this.context != null) {
            return "OSGiClassLoader[all bundles]";
        }
        return "OSGiClassLoader[" + this.bundle.getSymbolicName() + "]";
    }
}

