/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.driver.ToolChain;
import org.clang.driver.impl.DriverSuffix;
import org.clang.driver.impl.ToolChainStatics$FindDriverSuffix$$;
import org.clang.driver.options;
import org.clang.driver.tools.impl.ArmStatics;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public final class ToolChainStatics {
    public static Arg GetRTTIArgument(ArgList Args) {
        return Args.getLastArg(new OptSpecifier(options.ID.OPT_mkernel.getValue()), new OptSpecifier(options.ID.OPT_fapple_kext.getValue()), new OptSpecifier(options.ID.OPT_fno_rtti.getValue()), new OptSpecifier(options.ID.OPT_frtti.getValue()));
    }

    public static ToolChain.RTTIMode CalculateRTTIMode(ArgList Args, Triple Triple2, Arg CachedRTTIArg) {
        if (CachedRTTIArg != null) {
            if (CachedRTTIArg.getOption().matches(new OptSpecifier(options.ID.OPT_frtti.getValue()))) {
                return ToolChain.RTTIMode.RM_EnabledExplicitly;
            }
            return ToolChain.RTTIMode.RM_DisabledExplicitly;
        }
        if (!Triple2.isPS4CPU()) {
            return ToolChain.RTTIMode.RM_EnabledImplicitly;
        }
        Arg Exceptions = Args.getLastArgNoClaim(new OptSpecifier(options.ID.OPT_fcxx_exceptions.getValue()), new OptSpecifier(options.ID.OPT_fno_cxx_exceptions.getValue()), new OptSpecifier(options.ID.OPT_fexceptions.getValue()), new OptSpecifier(options.ID.OPT_fno_exceptions.getValue()));
        if (Exceptions != null && (Exceptions.getOption().matches(new OptSpecifier(options.ID.OPT_fexceptions.getValue())) || Exceptions.getOption().matches(new OptSpecifier(options.ID.OPT_fcxx_exceptions.getValue())))) {
            return ToolChain.RTTIMode.RM_EnabledImplicitly;
        }
        return ToolChain.RTTIMode.RM_DisabledImplicitly;
    }

    public static DriverSuffix FindDriverSuffix(StringRef ProgName) {
        Object[] DriverSuffixes = ToolChainStatics$FindDriverSuffix$$.DriverSuffixes;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)llvm.array_lengthof((Object[])DriverSuffixes))) {
            if (ProgName.endswith(((DriverSuffix)DriverSuffixes[i]).Suffix)) {
                return DriverSuffixes[i];
            }
            ++i;
        }
        return null;
    }

    public static std.string normalizeProgramName(StringRef Argv0) {
        std.string ProgName = path.stem((StringRef)Argv0).$basic_string();
        return ProgName;
    }

    public static DriverSuffix parseDriverSuffix(StringRef ProgName) {
        DriverSuffix DS = ToolChainStatics.FindDriverSuffix(new StringRef(ProgName));
        if (DS == null) {
            ProgName.$assignMove(ProgName.rtrim("0123456789."));
            DS = ToolChainStatics.FindDriverSuffix(new StringRef(ProgName));
        }
        if (DS == null) {
            ProgName.$assignMove(ProgName.slice(0, ProgName.rfind((byte)45)));
            DS = ToolChainStatics.FindDriverSuffix(new StringRef(ProgName));
        }
        return DS;
    }

    public static StringRef getArchNameForCompilerRTLib(ToolChain TC, ArgList Args) {
        Triple _Triple = TC.getTriple();
        boolean IsWindows = _Triple.isOSWindows();
        if (_Triple.isWindowsMSVCEnvironment() && TC.getArch() == Triple.ArchType.x86) {
            return new StringRef("i386");
        }
        if (TC.getArch() == Triple.ArchType.arm || TC.getArch() == Triple.ArchType.armeb) {
            return new StringRef(ArmStatics.getARMFloatABI(TC, Args) == ArmStatics.FloatABI.Hard && !IsWindows ? NativePointer.$((String)"armhf") : NativePointer.$((String)"arm"));
        }
        return TC.getArchName();
    }

    public static boolean ParseCXXStdlibType(StringRef Name, type.ref<ToolChain.CXXStdlibType> Type2) {
        if (llvm.$eq_StringRef((StringRef)Name, (String)"libc++")) {
            Type2.$set((Object)ToolChain.CXXStdlibType.CST_Libcxx);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"libstdc++")) {
            Type2.$set((Object)ToolChain.CXXStdlibType.CST_Libstdcxx);
        } else {
            return false;
        }
        return true;
    }
}

