/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.JFXProjectConfigurations;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.ui.JFXApplicationPanel;
import org.netbeans.modules.javafx2.project.ui.JFXPackagingPanel;
import org.netbeans.modules.javafx2.project.ui.JSEDeploymentPanel;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class JFXProjectProperties {
    private static final Logger LOG = Logger.getLogger(JFXProjectProperties.class.getName());
    private static final Color INVALID_CELL_CONTENT_COLOR = Color.RED;
    public static final String JAVAFX_ENABLED = "javafx.enabled";
    public static final String JAVAFX_PRELOADER = "javafx.preloader";
    public static final String JAVAFX_SWING = "javafx.swing";
    public static final String JAVAFX_DISABLE_AUTOUPDATE = "javafx.disable.autoupdate";
    public static final String JAVAFX_DISABLE_AUTOUPDATE_NOTIFICATION = "javafx.disable.autoupdate.notification";
    public static final String JAVAFX_DISABLE_CONCURRENT_RUNS = "javafx.disable.concurrent.runs";
    public static final String JAVAFX_ENABLE_CONCURRENT_EXTERNAL_RUNS = "javafx.enable.concurrent.external.runs";
    public static final String JAVAFX_ENDORSED_ANT_CLASSPATH = "endorsed.javafx.ant.classpath";
    public static final String PLATFORM_ACTIVE = "platform.active";
    public static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String FXML_EXTENSION = "fxml";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_ADDITIONALPARAM = "javadoc.additionalparam";
    public static final String BUILD_SCRIPT = "buildfile";
    public static final String DIST_JAR = "dist.jar";
    public static final String JAVAFX_BINARY_ENCODE_CSS = "javafx.binarycss";
    public static final String JAVAFX_DEPLOY_INCLUDEDT = "javafx.deploy.includeDT";
    public static final String JAVAFX_DEPLOY_EMBEDJNLP = "javafx.deploy.embedJNLP";
    public static final String JAVAFX_REBASE_LIBS = "javafx.rebase.libs";
    public static final String MAIN_CLASS = "javafx.main.class";
    public static final String RUN_JVM_ARGS = "run.jvmargs";
    public static final String FALLBACK_CLASS = "javafx.fallback.class";
    public static final String SIGNED_JAR = "dist.signed.jar";
    public static final String PRELOADER_ENABLED = "javafx.preloader.enabled";
    public static final String PRELOADER_TYPE = "javafx.preloader.type";
    public static final String PRELOADER_PROJECT = "javafx.preloader.project.path";
    public static final String PRELOADER_CLASS = "javafx.preloader.class";
    public static final String PRELOADER_JAR_FILENAME = "javafx.preloader.jar.filename";
    public static final String PRELOADER_JAR_PATH = "javafx.preloader.jar.path";
    public static final String RUN_WORK_DIR = "work.dir";
    public static final String RUN_APP_WIDTH = "javafx.run.width";
    public static final String RUN_APP_HEIGHT = "javafx.run.height";
    public static final String RUN_IN_HTMLTEMPLATE = "javafx.run.htmltemplate";
    public static final String RUN_IN_HTMLTEMPLATE_PROCESSED = "javafx.run.htmltemplate.processed";
    public static final String RUN_IN_BROWSER = "javafx.run.inbrowser";
    public static final String RUN_IN_BROWSER_PATH = "javafx.run.inbrowser.path";
    public static final String RUN_IN_BROWSER_ARGUMENTS = "javafx.run.inbrowser.arguments";
    public static final String RUN_IN_BROWSER_UNDEFINED = "undefined";
    public static final String RUN_AS = "javafx.run.as";
    public static final String DEFAULT_APP_WIDTH = "800";
    public static final String DEFAULT_APP_HEIGHT = "600";
    public static final String UPDATE_MODE_BACKGROUND = "javafx.deploy.backgroundupdate";
    public static final String ALLOW_OFFLINE = "javafx.deploy.allowoffline";
    public static final String INSTALL_PERMANENTLY = "javafx.deploy.installpermanently";
    public static final String ADD_DESKTOP_SHORTCUT = "javafx.deploy.adddesktopshortcut";
    public static final String ADD_STARTMENU_SHORTCUT = "javafx.deploy.addstartmenushortcut";
    public static final String ICON_FILE = "javafx.deploy.icon";
    public static final String NATIVE_ICON_FILE = "javafx.deploy.icon.native";
    public static final String SPLASH_IMAGE_FILE = "javafx.deploy.splash";
    public static final String PERMISSIONS_ELEVATED = "javafx.deploy.permissionselevated";
    public static final String DISABLE_PROXY = "javafx.deploy.disable.proxy";
    public static final String REQUEST_RT = "javafx.deploy.request.runtime";
    public static final String JAVAFX_SIGNING_ENABLED = "javafx.signing.enabled";
    public static final String JAVAFX_SIGNING_TYPE = "javafx.signing.type";
    public static final String JAVAFX_SIGNING_KEYSTORE = "javafx.signing.keystore";
    public static final String JAVAFX_SIGNING_KEYSTORE_PASSWORD = "javafx.signing.keystore.password";
    public static final String JAVAFX_SIGNING_KEY = "javafx.signing.keyalias";
    public static final String JAVAFX_SIGNING_KEY_PASSWORD = "javafx.signing.keyalias.password";
    public static final String JAVAFX_SIGNING_BLOB = "javafx.signing.blob";
    public static final String NATIVE_BUNDLING_ENABLED = "native.bundling.enabled";
    public static final String NATIVE_BUNDLING_TYPE = "native.bundling.type";
    public static final String COPYLIBS_EXCLUDES = "copylibs.excludes";
    public static final String RUN_CP = "run.classpath";
    public static final String BUILD_CLASSES = "build.classes.dir";
    public static final String JAVASE_KEEP_JFXRT_ON_CLASSPATH = "keep.javafx.runtime.on.classpath";
    public static final String DOWNLOAD_MODE_LAZY_JARS = "download.mode.lazy.jars";
    private static final String DOWNLOAD_MODE_LAZY_JAR = "download.mode.lazy.jar.";
    private static final String DOWNLOAD_MODE_LAZY_FORMAT = "download.mode.lazy.jar.%s";
    public static final String JAVASCRIPT_CALLBACK_PREFIX = "javafx.jscallback.";
    public static final String IMPLEMENTATION_VERSION = "javafx.application.implementation.version";
    public static final String IMPLEMENTATION_VERSION_DEFAULT = "1.0";
    public static final String PROJECT_CONFIGS_DIR = "nbproject/configs";
    public static final String PROJECT_PRIVATE_CONFIGS_DIR = "nbproject/private/configs";
    public static final String PROPERTIES_FILE_EXT = "properties";
    public static final String CONFIG_PROPERTIES_FILE = "nbproject/private/config.properties";
    public static final String DEFAULT_CONFIG = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.default.label");
    public static final String DEFAULT_CONFIG_STANDALONE = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.standalone.label");
    public static final String DEFAULT_CONFIG_WEBSTART = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.webstart.label");
    public static final String DEFAULT_CONFIG_BROWSER = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.browser.label");
    public static final String MANIFEST_CUSTOM_CODEBASE = "manifest.custom.codebase";
    public static final String MANIFEST_CUSTOM_PERMISSIONS = "manifest.custom.permissions";
    public static final String PLATFORM_RUNTIME = "platform.runtime";
    private static final String JFX_EXTENSION_CPREF = "${javafx.classpath.extension}";
    private StoreGroup fxPropGroup = new StoreGroup();
    JToggleButton.ToggleButtonModel binaryEncodeCSS;
    private JFXPackagingPanel packagingPanel = null;
    private JFXApplicationPanel applicationPanel = null;
    private JSEDeploymentPanel seDeploymentPanel = null;
    private JFXConfigs CONFIGS = null;
    private Map<String, String> browserPaths = null;
    PreloaderClassComboBoxModel preloaderClassModel;
    JToggleButton.ToggleButtonModel runStandalone;
    JToggleButton.ToggleButtonModel runAsWebStart;
    JToggleButton.ToggleButtonModel runInBrowser;
    JToggleButton.ToggleButtonModel allowOfflineModel;
    JToggleButton.ToggleButtonModel backgroundUpdateCheck;
    JToggleButton.ToggleButtonModel installPermanently;
    JToggleButton.ToggleButtonModel addDesktopShortcut;
    JToggleButton.ToggleButtonModel addStartMenuShortcut;
    JToggleButton.ToggleButtonModel disableProxy;
    String wsIconPath;
    String splashImagePath;
    String nativeIconPath;
    boolean signingEnabled;
    boolean signingBlob;
    SigningType signingType;
    String signingKeyStore;
    String signingKeyAlias;
    boolean permissionsElevated;
    char[] signingKeyStorePassword;
    char[] signingKeyPassword;
    boolean nativeBundlingEnabled;
    boolean keepJFXRTonCP;
    List<? extends File> runtimeCP;
    List<? extends File> lazyJars;
    boolean lazyJarsChanged;
    Map<String, String> jsCallbacks;
    boolean jsCallbacksChanged;
    String requestedRT;
    String implVersion;
    private J2SEPropertyEvaluator j2sePropEval;
    private PropertyEvaluator evaluator;
    private Project project;
    private static Map<String, JFXProjectProperties> propInstance = new HashMap<String, JFXProjectProperties>();
    private Set<String> instanceMarkers = new TreeSet<String>();
    private static Map<String, Set<PreloaderArtifact>> prelArtifacts = new HashMap<String, Set<PreloaderArtifact>>();

    public JToggleButton.ToggleButtonModel getBinaryEncodeCSSModel() {
        return this.binaryEncodeCSS;
    }

    public JFXPackagingPanel getPackagingPanel() {
        if (this.packagingPanel == null) {
            this.packagingPanel = new JFXPackagingPanel(this);
        }
        return this.packagingPanel;
    }

    public JFXApplicationPanel getApplicationPanel() {
        if (this.applicationPanel == null) {
            this.applicationPanel = new JFXApplicationPanel(this);
        }
        return this.applicationPanel;
    }

    public JSEDeploymentPanel getSEDeploymentPanel() {
        if (this.seDeploymentPanel == null) {
            this.seDeploymentPanel = new JSEDeploymentPanel(this);
        }
        return this.seDeploymentPanel;
    }

    public JFXConfigs getConfigs() {
        return this.CONFIGS;
    }

    public Map<String, String> getBrowserPaths() {
        return this.browserPaths;
    }

    public void resetBrowserPaths() {
        this.browserPaths = new HashMap<String, String>();
    }

    public void setBrowserPaths(Map<String, String> browserPaths) {
        this.browserPaths = browserPaths;
    }

    public PreloaderClassComboBoxModel getPreloaderClassModel() {
        return this.preloaderClassModel;
    }

    public JToggleButton.ToggleButtonModel getAllowOfflineModel() {
        return this.allowOfflineModel;
    }

    public JToggleButton.ToggleButtonModel getBackgroundUpdateCheckModel() {
        return this.backgroundUpdateCheck;
    }

    public JToggleButton.ToggleButtonModel getInstallPermanentlyModel() {
        return this.installPermanently;
    }

    public JToggleButton.ToggleButtonModel getAddDesktopShortcutModel() {
        return this.addDesktopShortcut;
    }

    public JToggleButton.ToggleButtonModel getAddStartMenuShortcutModel() {
        return this.addStartMenuShortcut;
    }

    public JToggleButton.ToggleButtonModel getDisableProxyModel() {
        return this.disableProxy;
    }

    public String getWSIconPath() {
        return this.wsIconPath;
    }

    public void setWSIconPath(String path) {
        this.wsIconPath = path;
    }

    public String getSplashImagePath() {
        return this.splashImagePath;
    }

    public void setSplashImagePath(String path) {
        this.splashImagePath = path;
    }

    public String getNativeIconPath() {
        return this.nativeIconPath;
    }

    public void setNativeIconPath(String path) {
        this.nativeIconPath = path;
    }

    public boolean getSigningEnabled() {
        return this.signingEnabled;
    }

    public void setSigningEnabled(boolean enabled) {
        this.signingEnabled = enabled;
    }

    public boolean getBLOBSigningEnabled() {
        return this.signingBlob;
    }

    public void setBLOBSigningEnabled(boolean enabled) {
        this.signingBlob = enabled;
    }

    public boolean getPermissionsElevated() {
        return this.permissionsElevated;
    }

    public void setPermissionsElevated(boolean enabled) {
        this.permissionsElevated = enabled;
    }

    public SigningType getSigningType() {
        return this.signingType;
    }

    public void setSigningType(SigningType type) {
        this.signingType = type;
    }

    public String getSigningKeyStore() {
        return this.signingKeyStore;
    }

    public String getSigningKeyAlias() {
        return this.signingKeyAlias;
    }

    public char[] getSigningKeyStorePassword() {
        return this.signingKeyStorePassword;
    }

    public char[] getSigningKeyPassword() {
        return this.signingKeyPassword;
    }

    public void setSigningKeyAlias(String signingKeyAlias) {
        this.signingKeyAlias = signingKeyAlias;
    }

    public void setSigningKeyPassword(char[] signingKeyPassword) {
        this.signingKeyPassword = signingKeyPassword;
    }

    public void setSigningKeyStore(String signingKeyStore) {
        this.signingKeyStore = signingKeyStore;
    }

    public void setSigningKeyStorePassword(char[] signingKeyStorePassword) {
        this.signingKeyStorePassword = signingKeyStorePassword;
    }

    public boolean getNativeBundlingEnabled() {
        return this.nativeBundlingEnabled;
    }

    public void setNativeBundlingEnabled(boolean enabled) {
        this.nativeBundlingEnabled = enabled;
    }

    public boolean getKeepJFXRTonCP() {
        return this.keepJFXRTonCP;
    }

    public void setKeepJFXRTonCP(boolean enabled) {
        this.keepJFXRTonCP = enabled;
    }

    public List<? extends File> getRuntimeCP() {
        return this.runtimeCP;
    }

    public List<? extends File> getLazyJars() {
        return this.lazyJars;
    }

    public void setLazyJars(List<? extends File> newLazyJars) {
        this.lazyJars = newLazyJars;
    }

    public boolean getLazyJarsChanged() {
        return this.lazyJarsChanged;
    }

    public void setLazyJarsChanged(boolean changed) {
        this.lazyJarsChanged = changed;
    }

    public Map<String, String> getJSCallbacks() {
        return this.jsCallbacks;
    }

    public void setJSCallbacks(Map<String, String> newCallbacks) {
        this.jsCallbacks = newCallbacks;
    }

    public boolean getJSCallbacksChanged() {
        return this.jsCallbacksChanged;
    }

    public void setJSCallbacksChanged(boolean changed) {
        this.jsCallbacksChanged = changed;
    }

    public String getRequestedRT() {
        return this.requestedRT;
    }

    public void setRequestedRT(String rt) {
        this.requestedRT = rt;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public void setImplementationVersion(String implVer) {
        this.implVersion = implVer;
    }

    public Project getProject() {
        return this.project;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void markInstance(@NonNull String marker) {
        this.instanceMarkers.add(marker);
    }

    public boolean isInstanceMarked(@NonNull String marker) {
        return this.instanceMarkers.contains(marker);
    }

    public static JFXProjectProperties getInstance(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop == null) {
            prop = new JFXProjectProperties(context);
            propInstance.put(projDir, prop);
        }
        return prop;
    }

    @Deprecated
    public static JFXProjectProperties getInstancePerSession(Lookup context, String category) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop != null) {
            if (prop.isInstanceMarked(category)) {
                prop = null;
            } else {
                prop.markInstance(category);
            }
        }
        if (prop == null) {
            prop = new JFXProjectProperties(context);
            propInstance.put(projDir, prop);
            prop.markInstance(category);
        }
        return prop;
    }

    public static JFXProjectProperties getInstanceIfExists(Project proj) {
        assert (proj != null);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop != null) {
            return prop;
        }
        return null;
    }

    public static JFXProjectProperties getInstanceIfExists(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        return JFXProjectProperties.getInstanceIfExists(proj);
    }

    public static void cleanup(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        propInstance.remove(projDir);
    }

    private static Set<PreloaderArtifact> getPreloaderArtifacts(@NonNull Project proj) {
        String projDir = proj.getProjectDirectory().getPath();
        Set<PreloaderArtifact> prels = prelArtifacts.get(projDir);
        if (prels == null) {
            prels = new HashSet<PreloaderArtifact>();
            prelArtifacts.put(projDir, prels);
        }
        return prels;
    }

    public String getFXRunTimeJar() {
        assert (this.evaluator != null);
        String active = this.evaluator.getProperty(PLATFORM_ACTIVE);
        JavaPlatform platform = JavaFXPlatformUtils.findJavaPlatform((String)active);
        if (platform != null) {
            return JavaFXPlatformUtils.getJavaFXRuntimeJar((JavaPlatform)platform);
        }
        return null;
    }

    private JFXProjectProperties(Lookup context) {
        this.project = (Project)context.lookup(Project.class);
        if (this.project != null) {
            this.j2sePropEval = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class);
            this.evaluator = this.j2sePropEval.evaluator();
            this.binaryEncodeCSS = this.fxPropGroup.createToggleButtonModel(this.evaluator, JAVAFX_BINARY_ENCODE_CSS);
            this.allowOfflineModel = this.fxPropGroup.createToggleButtonModel(this.evaluator, ALLOW_OFFLINE);
            this.backgroundUpdateCheck = this.fxPropGroup.createToggleButtonModel(this.evaluator, UPDATE_MODE_BACKGROUND);
            this.installPermanently = this.fxPropGroup.createToggleButtonModel(this.evaluator, INSTALL_PERMANENTLY);
            this.addDesktopShortcut = this.fxPropGroup.createToggleButtonModel(this.evaluator, ADD_DESKTOP_SHORTCUT);
            this.addStartMenuShortcut = this.fxPropGroup.createToggleButtonModel(this.evaluator, ADD_STARTMENU_SHORTCUT);
            this.disableProxy = this.fxPropGroup.createToggleButtonModel(this.evaluator, DISABLE_PROXY);
            this.CONFIGS = new JFXConfigs();
            this.CONFIGS.read();
            this.initPreloaderArtifacts(this.project, this.CONFIGS);
            this.CONFIGS.setActive(this.evaluator.getProperty("config"));
            this.preloaderClassModel = new PreloaderClassComboBoxModel();
            this.initVersion(this.evaluator);
            this.initIcons(this.evaluator);
            this.initSigning(this.evaluator);
            this.initNativeBundling(this.evaluator);
            this.initResources(this.evaluator, this.project, this.CONFIGS);
            this.initJSCallbacks(this.evaluator);
            this.initRest(this.evaluator);
        }
    }

    public static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public static boolean isNonEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    public static boolean isEqualIgnoreCase(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    public static boolean isEqualText(String s1, String s2) {
        return (s1 == null || s1.isEmpty()) && (s2 == null || s2.isEmpty()) || s1 != null && s2 != null && s1.equals(s2);
    }

    private FileObject getSrcRoot(@NonNull Project project) {
        FileObject srcRoot = null;
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (JFXProjectProperties.isTest(sg.getRootFolder(), project)) continue;
            srcRoot = sg.getRootFolder();
            break;
        }
        return srcRoot;
    }

    private void initPreloaderArtifacts(@NonNull Project project, @NonNull JFXConfigs configs) {
        Set<PreloaderArtifact> prels = JFXProjectProperties.getPreloaderArtifacts(project);
        prels.clear();
        try {
            prels.addAll(this.getPreloaderArtifactsFromConfigs(configs));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean hasPreloaderInAnyConfig() {
        return this.hasPreloaderInAnyConfig(this.CONFIGS);
    }

    private boolean hasPreloaderInAnyConfig(@NonNull JFXConfigs configs) {
        if (configs != null) {
            for (String config : configs.getConfigNames()) {
                if (!JFXProjectProperties.isTrue(configs.getProperty(config, PRELOADER_ENABLED))) continue;
                return true;
            }
        }
        return false;
    }

    private PreloaderArtifact getPreloaderArtifactFromConfig(@NonNull JFXConfigs configs, @NonNull String config, boolean transparent) throws IOException {
        if (configs.hasConfig(config)) {
            String prelProjDir;
            PreloaderArtifact preloader = null;
            if (!JFXProjectProperties.isTrue(transparent ? configs.getPropertyTransparent(config, PRELOADER_ENABLED) : configs.getProperty(config, PRELOADER_ENABLED))) {
                return null;
            }
            String prelTypeString = transparent ? configs.getPropertyTransparent(config, PRELOADER_TYPE) : configs.getProperty(config, PRELOADER_TYPE);
            String string = prelProjDir = transparent ? configs.getPropertyTransparent(config, PRELOADER_PROJECT) : configs.getProperty(config, PRELOADER_PROJECT);
            if (prelProjDir != null && JFXProjectProperties.isEqualIgnoreCase(prelTypeString, PreloaderSourceType.PROJECT.getString())) {
                FileObject srcRoot;
                FileObject thisProjDir = this.project.getProjectDirectory();
                FileObject fo = JFXProjectUtils.getFileObject(thisProjDir, prelProjDir);
                File prelProjDirF = fo == null ? null : FileUtil.toFile((FileObject)fo);
                if (JFXProjectProperties.isTrue(transparent ? configs.getPropertyTransparent(config, PRELOADER_ENABLED) : configs.getProperty(config, PRELOADER_ENABLED)) && prelProjDirF != null && prelProjDirF.exists() && (srcRoot = this.getSrcRoot(this.getProject())) != null) {
                    prelProjDirF = FileUtil.normalizeFile((File)prelProjDirF);
                    FileObject prelProjFO = FileUtil.toFileObject((File)prelProjDirF);
                    Project proj = ProjectManager.getDefault().findProject(prelProjFO);
                    AntArtifact[] artifacts = proj != null ? AntArtifactQuery.findArtifactsByType((Project)proj, (String)"jar") : new AntArtifact[]{};
                    ArrayList<URI> allURI = new ArrayList<URI>();
                    for (AntArtifact artifact : artifacts) {
                        allURI.addAll(Arrays.asList(artifact.getArtifactLocations()));
                    }
                    if (!allURI.isEmpty()) {
                        URI[] arrayURI = allURI.toArray(new URI[0]);
                        preloader = new PreloaderProjectArtifact(artifacts, arrayURI, srcRoot, "classpath/compile", prelProjDirF.getAbsolutePath());
                    }
                }
            }
            if (preloader == null) {
                String prelJar;
                String string2 = prelJar = transparent ? configs.getPropertyTransparent(config, PRELOADER_JAR_PATH) : configs.getProperty(config, PRELOADER_JAR_PATH);
                if (prelJar != null && JFXProjectProperties.isEqualIgnoreCase(prelTypeString, PreloaderSourceType.JAR.getString())) {
                    FileObject srcRoot;
                    File prelJarF;
                    FileObject thisProjDir = this.project.getProjectDirectory();
                    FileObject fo = JFXProjectUtils.getFileObject(thisProjDir, prelJar);
                    File file = prelJarF = fo == null ? null : FileUtil.toFile((FileObject)fo);
                    if (prelJarF != null && prelJarF.exists() && (srcRoot = this.getSrcRoot(this.getProject())) != null) {
                        URL[] urls = new URL[]{FileUtil.urlForArchiveOrDir((File)prelJarF)};
                        FileObject[] fos = new FileObject[]{FileUtil.toFileObject((File)prelJarF)};
                        preloader = new PreloaderJarArtifact(urls, fos, srcRoot, "classpath/compile", urls[0].toString());
                    }
                }
            }
            return preloader;
        }
        return null;
    }

    private Set<PreloaderArtifact> getPreloaderArtifactsFromConfigs(@NonNull JFXConfigs configs) throws IOException {
        HashSet<PreloaderArtifact> preloaderArtifacts = new HashSet<PreloaderArtifact>();
        for (String config : configs.getConfigNames()) {
            PreloaderArtifact preloader = this.getPreloaderArtifactFromConfig(configs, config, false);
            if (preloader == null) continue;
            preloaderArtifacts.add(preloader);
        }
        return preloaderArtifacts;
    }

    public void updatePreloaderDependencies() {
        try {
            this.updatePreloaderDependencies(this.CONFIGS);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updatePreloaderDependencies(@NonNull JFXConfigs configs) throws IOException {
        Set<PreloaderArtifact> preloaderArtifacts = JFXProjectProperties.getPreloaderArtifacts(this.getProject());
        for (PreloaderArtifact preloaderArtifact : preloaderArtifacts) {
            preloaderArtifact.setValid(false);
        }
        final PreloaderArtifact preloaderActive = this.getPreloaderArtifactFromConfig(configs, configs.getActive(), true);
        for (String string : configs.getConfigNames()) {
            PreloaderArtifact preloader = this.getPreloaderArtifactFromConfig(configs, string, false);
            if (preloader == null) continue;
            boolean updated = false;
            for (PreloaderArtifact a : preloaderArtifacts) {
                if (!a.equals(preloader)) continue;
                a.setValid(true);
                updated = true;
            }
            if (updated) continue;
            preloader.setValid(true);
            preloaderArtifacts.add(preloader);
        }
        HashSet<PreloaderArtifact> hashSet = new HashSet<PreloaderArtifact>();
        for (PreloaderArtifact artifact : preloaderArtifacts) {
            if (preloaderActive != null && preloaderActive.equals(artifact)) continue;
            hashSet.add(artifact);
        }
        if (preloaderActive != null || !hashSet.isEmpty()) {
            final Set set = Collections.unmodifiableSet(hashSet);
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    if (preloaderActive != null) {
                        try {
                            preloaderActive.addDependency();
                        }
                        catch (IOException e) {
                            LOG.log(Level.SEVERE, "Preloader dependency addition failed.");
                        }
                    }
                    try {
                        for (PreloaderArtifact artifact : set) {
                            artifact.removeDependency();
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "Preloader dependency removal failed.");
                    }
                }
            });
        }
        hashSet.clear();
        for (PreloaderArtifact artifact : preloaderArtifacts) {
            if (artifact.isValid()) continue;
            hashSet.add(artifact);
        }
        for (PreloaderArtifact artifact : hashSet) {
            preloaderArtifacts.remove(artifact);
        }
    }

    private static boolean isTest(@NonNull FileObject root, @NonNull Project project) {
        assert (root != null);
        assert (project != null);
        ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] srcRoots;
            for (FileObject srcRoot : srcRoots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots()) {
                if (!project.equals(FileOwnerQuery.getOwner((FileObject)srcRoot))) continue;
                return true;
            }
        }
        return false;
    }

    private void storeRest(@NonNull EditableProperties editableProps, @NonNull EditableProperties privProps) {
        if (!editableProps.containsKey((Object)MANIFEST_CUSTOM_CODEBASE) && !privProps.containsKey((Object)MANIFEST_CUSTOM_CODEBASE)) {
            editableProps.setProperty(MANIFEST_CUSTOM_CODEBASE, "*");
            editableProps.setComment(MANIFEST_CUSTOM_CODEBASE, new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_manifest_custom_codebase")}, false);
        }
        if (!editableProps.containsKey((Object)MANIFEST_CUSTOM_PERMISSIONS) && !privProps.containsKey((Object)MANIFEST_CUSTOM_PERMISSIONS)) {
            editableProps.setProperty(MANIFEST_CUSTOM_PERMISSIONS, "");
            editableProps.setComment(MANIFEST_CUSTOM_PERMISSIONS, new String[]{"# " + NbBundle.getMessage(JFXProjectUtils.class, (String)"COMMENT_manifest_custom_permissions")}, false);
        }
        this.setOrRemove(editableProps, IMPLEMENTATION_VERSION, this.implVersion);
        editableProps.setProperty(JAVAFX_SIGNING_ENABLED, this.signingEnabled ? "true" : "false");
        editableProps.setProperty(JAVAFX_SIGNING_BLOB, this.signingBlob ? "true" : "false");
        editableProps.setProperty(JAVAFX_SIGNING_TYPE, this.signingType.getString());
        this.setOrRemove(editableProps, JAVAFX_SIGNING_KEY, this.signingKeyAlias);
        this.setOrRemove(editableProps, JAVAFX_SIGNING_KEYSTORE, this.signingKeyStore);
        editableProps.setProperty(PERMISSIONS_ELEVATED, this.permissionsElevated ? "true" : "false");
        this.setOrRemove(privProps, JAVAFX_SIGNING_KEYSTORE_PASSWORD, this.signingKeyStorePassword);
        this.setOrRemove(privProps, JAVAFX_SIGNING_KEY_PASSWORD, this.signingKeyPassword);
        editableProps.setProperty(NATIVE_BUNDLING_ENABLED, this.nativeBundlingEnabled ? "true" : "false");
        this.setOrRemove(editableProps, ICON_FILE, this.wsIconPath);
        this.setOrRemove(editableProps, SPLASH_IMAGE_FILE, this.splashImagePath);
        this.setOrRemove(editableProps, NATIVE_ICON_FILE, this.nativeIconPath);
        this.setOrRemove(editableProps, REQUEST_RT, this.requestedRT);
        this.storeResources(editableProps);
        this.storeJSCallbacks(editableProps);
    }

    private void setOrRemove(EditableProperties props, String name, char[] value) {
        this.setOrRemove(props, name, value != null ? new String(value) : null);
    }

    private void setOrRemove(@NonNull EditableProperties props, @NonNull String name, String value) {
        if (value != null) {
            props.setProperty(name, value);
        } else {
            props.remove((Object)name);
        }
    }

    public void store() throws IOException {
        String fxEnabled = this.evaluator.getProperty(JAVAFX_ENABLED);
        if (JFXProjectProperties.isTrue(fxEnabled)) {
            this.storeFX();
        } else {
            this.storeSE();
        }
    }

    private void storeFX() throws IOException {
        this.updatePreloaderDependencies(this.CONFIGS);
        this.CONFIGS.storeActive();
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final EditableProperties pep = new EditableProperties(true);
        final FileObject privPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    InputStream pis = privPropsFO.getInputStream();
                    try (InputStream is = projPropsFO.getInputStream();){
                        ep.load(is);
                    }
                    try {
                        pep.load(pis);
                    }
                    finally {
                        if (pis != null) {
                            pis.close();
                        }
                    }
                    JFXProjectProperties.this.fxPropGroup.store(ep);
                    JFXProjectProperties.this.storeRest(ep, pep);
                    JFXProjectProperties.this.CONFIGS.store(ep, pep);
                    JFXProjectProperties.this.updatePreloaderComment(ep);
                    JFXProjectProperties.logProps(ep);
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = projPropsFO.lock();
                        os = projPropsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    try {
                        lock = privPropsFO.lock();
                        os = privPropsFO.getOutputStream(lock);
                        pep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    private void storeSE() throws IOException {
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/project.properties");
        try {
            final InputStream is = projPropsFO.getInputStream();
            ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    try {
                        ep.load(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
        this.setOrRemove(ep, JAVASE_KEEP_JFXRT_ON_CLASSPATH, this.keepJFXRTonCP ? "true" : null);
        String copyLibsExcludes = ep.getProperty(COPYLIBS_EXCLUDES);
        if (this.keepJFXRTonCP) {
            if (copyLibsExcludes == null || copyLibsExcludes.isEmpty()) {
                copyLibsExcludes = JFX_EXTENSION_CPREF;
            } else if (copyLibsExcludes.indexOf(JFX_EXTENSION_CPREF) < 0) {
                copyLibsExcludes = copyLibsExcludes + ':' + JFX_EXTENSION_CPREF;
            }
            this.setOrRemove(ep, COPYLIBS_EXCLUDES, copyLibsExcludes);
        } else {
            if (copyLibsExcludes != null && (copyLibsExcludes = JFXProjectUtils.removeFromPath(copyLibsExcludes, JFX_EXTENSION_CPREF)).isEmpty()) {
                copyLibsExcludes = null;
            }
            this.setOrRemove(ep, COPYLIBS_EXCLUDES, copyLibsExcludes);
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = projPropsFO.lock();
                        os = projPropsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    private void updatePreloaderComment(EditableProperties ep) {
        if (JFXProjectProperties.isTrue(ep.get((Object)PRELOADER_ENABLED))) {
            ep.setComment(PRELOADER_ENABLED, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_use_preloader")}, false);
        } else {
            ep.setComment(PRELOADER_ENABLED, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_dontuse_preloader")}, false);
        }
    }

    private void initVersion(PropertyEvaluator eval) {
        this.implVersion = eval.getProperty(IMPLEMENTATION_VERSION);
        if (this.implVersion == null) {
            this.implVersion = IMPLEMENTATION_VERSION_DEFAULT;
        }
    }

    private void initIcons(PropertyEvaluator eval) {
        this.wsIconPath = eval.getProperty(ICON_FILE);
        this.splashImagePath = eval.getProperty(SPLASH_IMAGE_FILE);
        this.nativeIconPath = eval.getProperty(NATIVE_ICON_FILE);
    }

    private void initSigning(PropertyEvaluator eval) {
        String enabled = eval.getProperty(JAVAFX_SIGNING_ENABLED);
        String blob = eval.getProperty(JAVAFX_SIGNING_BLOB);
        String signedProp = eval.getProperty(JAVAFX_SIGNING_TYPE);
        this.signingEnabled = JFXProjectProperties.isTrue(enabled);
        this.signingBlob = JFXProjectProperties.isTrue(blob);
        this.signingType = signedProp == null ? SigningType.NOSIGN : (signedProp.equalsIgnoreCase(SigningType.SELF.getString()) ? SigningType.SELF : (signedProp.equalsIgnoreCase(SigningType.KEY.getString()) ? SigningType.KEY : SigningType.NOSIGN));
        this.signingKeyStore = eval.getProperty(JAVAFX_SIGNING_KEYSTORE);
        this.signingKeyAlias = eval.getProperty(JAVAFX_SIGNING_KEY);
        if (eval.getProperty(JAVAFX_SIGNING_KEYSTORE_PASSWORD) != null) {
            this.signingKeyStorePassword = eval.getProperty(JAVAFX_SIGNING_KEYSTORE_PASSWORD).toCharArray();
        }
        if (eval.getProperty(JAVAFX_SIGNING_KEY_PASSWORD) != null) {
            this.signingKeyPassword = eval.getProperty(JAVAFX_SIGNING_KEY_PASSWORD).toCharArray();
        }
        this.permissionsElevated = JFXProjectProperties.isTrue(eval.getProperty(PERMISSIONS_ELEVATED));
    }

    private void initNativeBundling(PropertyEvaluator eval) {
        String fxEnabled = this.evaluator.getProperty(JAVAFX_ENABLED);
        if (JFXProjectProperties.isTrue(fxEnabled)) {
            String enabled = eval.getProperty(NATIVE_BUNDLING_ENABLED);
            this.nativeBundlingEnabled = JFXProjectProperties.isTrue(enabled);
        }
    }

    private void initRest(PropertyEvaluator eval) {
        this.requestedRT = eval.getProperty(REQUEST_RT);
        this.keepJFXRTonCP = JFXProjectProperties.isTrue(eval.getProperty(JAVASE_KEEP_JFXRT_ON_CLASSPATH));
    }

    private boolean isParentOf(File parent, File child) {
        if (parent == null || child == null) {
            return false;
        }
        if (!parent.exists() || !child.exists()) {
            return false;
        }
        FileObject parentFO = FileUtil.toFileObject((File)parent);
        FileObject childFO = FileUtil.toFileObject((File)child);
        return FileUtil.isParentOf((FileObject)parentFO, (FileObject)childFO);
    }

    private void initResources(PropertyEvaluator eval, Project prj, JFXConfigs configs) {
        String[] paths;
        String lz = eval.getProperty(DOWNLOAD_MODE_LAZY_JARS);
        String rcp = eval.getProperty(RUN_CP);
        String bc = eval.getProperty(BUILD_CLASSES);
        String plat = eval.getProperty(PLATFORM_ACTIVE);
        JavaPlatform platform = JavaFXPlatformUtils.findJavaPlatform((String)plat);
        File prjDir = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        File bcDir = bc == null ? null : PropertyUtils.resolveFile((File)prjDir, (String)bc);
        ArrayList<? extends File> lazyFileList = new ArrayList<File>();
        if (lz != null) {
            for (String p : paths = PropertyUtils.tokenizePath((String)lz)) {
                lazyFileList.add(PropertyUtils.resolveFile((File)prjDir, (String)p));
            }
        }
        paths = rcp != null ? PropertyUtils.tokenizePath((String)rcp) : new String[]{};
        String mainJar = eval.getProperty(DIST_JAR);
        File mainFile = mainJar != null ? PropertyUtils.resolveFile((File)prjDir, (String)mainJar) : null;
        ArrayList<FileObject> preloaders = new ArrayList<FileObject>();
        try {
            for (PreloaderArtifact pa : this.getPreloaderArtifactsFromConfigs(configs)) {
                preloaders.addAll(Arrays.asList(pa.getFileObjects()));
            }
        }
        catch (IOException p) {
            // empty catch block
        }
        Collection platfF = platform != null ? platform.getInstallFolders() : null;
        ArrayList<? extends File> resFileList = new ArrayList<File>(paths.length);
        for (String p : paths) {
            File f;
            if (p.startsWith("${") && p.endsWith("}") || !(f = PropertyUtils.resolveFile((File)prjDir, (String)p)).exists() || mainFile != null && f.equals(mainFile)) continue;
            if (platfF != null) {
                boolean cont = false;
                for (FileObject fo : platfF) {
                    if (!this.isParentOf(FileUtil.toFile((FileObject)fo), f)) continue;
                    cont = true;
                }
                if (cont) continue;
            }
            boolean isPrel = false;
            for (FileObject prelfo : preloaders) {
                File prelf = FileUtil.toFile((FileObject)prelfo);
                if (prelf == null || !prelf.equals(f)) continue;
                isPrel = true;
            }
            if (isPrel || bc != null && bcDir.equals(f)) continue;
            resFileList.add(f);
            if (!JFXProjectProperties.isTrue(eval.getProperty(String.format(DOWNLOAD_MODE_LAZY_FORMAT, f.getName())))) continue;
            lazyFileList.add(f);
        }
        this.lazyJars = lazyFileList;
        this.runtimeCP = resFileList;
        this.lazyJarsChanged = false;
    }

    private void storeResources(EditableProperties props) {
        if (this.lazyJarsChanged) {
            props.remove((Object)DOWNLOAD_MODE_LAZY_JARS);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                if (!((String)((Map.Entry)it.next()).getKey()).startsWith(DOWNLOAD_MODE_LAZY_JAR)) continue;
                it.remove();
            }
            for (File file : this.lazyJars) {
                props.setProperty(String.format(DOWNLOAD_MODE_LAZY_FORMAT, file.getName()), "true");
            }
        }
    }

    private void initJSCallbacks(PropertyEvaluator eval) {
        String platformName = eval.getProperty(PLATFORM_ACTIVE);
        Map<String, List<String>> callbacks = JFXProjectUtils.getJSCallbacks(platformName);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : callbacks.entrySet()) {
            String v = eval.getProperty(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey());
            if (v == null || v.isEmpty()) continue;
            result.put(entry.getKey(), v);
        }
        this.jsCallbacks = result;
        this.jsCallbacksChanged = false;
    }

    private void storeJSCallbacks(EditableProperties props) {
        if (this.jsCallbacksChanged && this.jsCallbacks != null) {
            for (Map.Entry<String, String> entry : this.jsCallbacks.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                    props.setProperty(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey(), entry.getValue());
                    continue;
                }
                props.remove((Object)(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey()));
            }
        }
    }

    static void logProps(EditableProperties ep) {
        LOG.log(Level.INFO, "javafx.preloader.enabled = " + (ep.get((Object)PRELOADER_ENABLED) == null ? "null" : ep.get((Object)PRELOADER_ENABLED)));
        LOG.log(Level.INFO, "javafx.preloader.type = " + (ep.get((Object)PRELOADER_TYPE) == null ? "null" : ep.get((Object)PRELOADER_TYPE)));
        LOG.log(Level.INFO, "javafx.preloader.project.path = " + (ep.get((Object)PRELOADER_PROJECT) == null ? "null" : ep.get((Object)PRELOADER_PROJECT)));
        LOG.log(Level.INFO, "javafx.preloader.class = " + (ep.get((Object)PRELOADER_CLASS) == null ? "null" : ep.get((Object)PRELOADER_CLASS)));
        LOG.log(Level.INFO, "javafx.preloader.jar.filename = " + (ep.get((Object)PRELOADER_JAR_FILENAME) == null ? "null" : ep.get((Object)PRELOADER_JAR_FILENAME)));
        LOG.log(Level.INFO, "javafx.preloader.jar.path = " + (ep.get((Object)PRELOADER_JAR_PATH) == null ? "null" : ep.get((Object)PRELOADER_JAR_PATH)));
    }

    public class JFXConfigs
    extends JFXProjectConfigurations {
        private String PRELOADER_GROUP_NAME;
        private List<String> PRELOADER_PROPERTIES;
        private String BROWSER_GROUP_NAME;
        private List<String> BROWSER_PROPERTIES;

        public final List<String> getPreloaderProperties() {
            return Collections.unmodifiableList(this.PRELOADER_PROPERTIES);
        }

        public final List<String> getBrowserProperties() {
            return Collections.unmodifiableList(this.BROWSER_PROPERTIES);
        }

        JFXConfigs() {
            super(JFXProjectProperties.this.project.getProjectDirectory());
            this.PRELOADER_GROUP_NAME = "preloader";
            this.PRELOADER_PROPERTIES = Arrays.asList(JFXProjectProperties.PRELOADER_ENABLED, JFXProjectProperties.PRELOADER_TYPE, JFXProjectProperties.PRELOADER_PROJECT, JFXProjectProperties.PRELOADER_JAR_PATH, JFXProjectProperties.PRELOADER_JAR_FILENAME, JFXProjectProperties.PRELOADER_CLASS);
            this.BROWSER_GROUP_NAME = "browser";
            this.BROWSER_PROPERTIES = Arrays.asList(JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH, JFXProjectProperties.RUN_IN_BROWSER_ARGUMENTS);
            this.registerProjectProperties(new String[]{"main.class", JFXProjectProperties.MAIN_CLASS, JFXProjectProperties.RUN_JVM_ARGS, JFXProjectProperties.PRELOADER_ENABLED, JFXProjectProperties.PRELOADER_TYPE, JFXProjectProperties.PRELOADER_PROJECT, JFXProjectProperties.PRELOADER_JAR_PATH, JFXProjectProperties.PRELOADER_JAR_FILENAME, JFXProjectProperties.PRELOADER_CLASS, JFXProjectProperties.RUN_WORK_DIR, JFXProjectProperties.RUN_APP_WIDTH, JFXProjectProperties.RUN_APP_HEIGHT, JFXProjectProperties.RUN_IN_HTMLTEMPLATE, JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH, JFXProjectProperties.RUN_AS});
            this.registerPrivateProperties(new String[]{JFXProjectProperties.RUN_WORK_DIR, JFXProjectProperties.RUN_IN_HTMLTEMPLATE, JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH, JFXProjectProperties.RUN_IN_BROWSER_ARGUMENTS, JFXProjectProperties.RUN_AS});
            this.registerStaticProperties(new String[]{JFXProjectProperties.RUN_AS});
            HashMap<String, String> substituteMissing = new HashMap<String, String>();
            substituteMissing.put(JFXProjectProperties.RUN_APP_WIDTH, JFXProjectProperties.DEFAULT_APP_WIDTH);
            substituteMissing.put(JFXProjectProperties.RUN_APP_HEIGHT, JFXProjectProperties.DEFAULT_APP_HEIGHT);
            this.registerDefaultsIfMissing(substituteMissing);
            this.registerCleanEmptyProjectProperties(new String[]{JFXProjectProperties.MAIN_CLASS, JFXProjectProperties.RUN_JVM_ARGS, JFXProjectProperties.PRELOADER_ENABLED, JFXProjectProperties.PRELOADER_TYPE, JFXProjectProperties.PRELOADER_PROJECT, JFXProjectProperties.PRELOADER_JAR_PATH, JFXProjectProperties.PRELOADER_JAR_FILENAME, JFXProjectProperties.PRELOADER_CLASS, JFXProjectProperties.RUN_APP_WIDTH, JFXProjectProperties.RUN_APP_HEIGHT});
            this.registerCleanEmptyPrivateProperties(new String[]{JFXProjectProperties.RUN_WORK_DIR, JFXProjectProperties.RUN_IN_HTMLTEMPLATE, JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH});
            this.defineGroup(this.PRELOADER_GROUP_NAME, this.getPreloaderProperties());
            this.defineGroup(this.BROWSER_GROUP_NAME, this.getBrowserProperties());
        }
    }

    class PreloaderJarArtifact
    extends PreloaderArtifact {
        private final String ID;
        private final URL[] classPathRoots;
        private final FileObject[] fileObjects;
        private final FileObject projectArtifact;
        private final String classPathType;

        PreloaderJarArtifact(@NonNull URL[] classPathRoots, @NonNull FileObject[] fileObjects, @NonNull FileObject projectArtifact, @NonNull String classPathType, String ID) {
            this.classPathRoots = classPathRoots;
            this.fileObjects = fileObjects;
            this.projectArtifact = projectArtifact;
            this.classPathType = classPathType;
            this.ID = ID;
        }

        @Override
        public boolean addDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addRoots((URL[])this.classPathRoots, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        @Override
        public boolean removeDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.removeRoots((URL[])this.classPathRoots, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof PreloaderJarArtifact)) {
                return false;
            }
            PreloaderJarArtifact concrete = (PreloaderJarArtifact)that;
            return this.ID.equals(concrete.ID);
        }

        @Override
        final FileObject[] getFileObjects() {
            return this.fileObjects;
        }
    }

    class PreloaderProjectArtifact
    extends PreloaderArtifact {
        private final String ID;
        private final AntArtifact[] artifacts;
        private final URI[] artifactElements;
        private final FileObject projectArtifact;
        private final String classPathType;

        PreloaderProjectArtifact(@NonNull AntArtifact[] artifacts, @NonNull URI[] artifactElements, @NonNull FileObject projectArtifact, @NonNull String classPathType, String ID) {
            this.artifacts = artifacts;
            this.artifactElements = artifactElements;
            this.projectArtifact = projectArtifact;
            this.classPathType = classPathType;
            this.ID = ID;
        }

        @Override
        public boolean addDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addAntArtifacts((AntArtifact[])this.artifacts, (URI[])this.artifactElements, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        @Override
        public boolean removeDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.removeAntArtifacts((AntArtifact[])this.artifacts, (URI[])this.artifactElements, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof PreloaderProjectArtifact)) {
                return false;
            }
            PreloaderProjectArtifact concrete = (PreloaderProjectArtifact)that;
            return this.ID.equals(concrete.ID);
        }

        @Override
        final FileObject[] getFileObjects() {
            ArrayList<FileObject> l = new ArrayList<FileObject>();
            for (AntArtifact a : this.artifacts) {
                l.addAll(Arrays.asList(a.getArtifactFiles()));
            }
            return l.toArray(new FileObject[l.size()]);
        }
    }

    abstract class PreloaderArtifact {
        private boolean valid;

        PreloaderArtifact() {
        }

        abstract boolean addDependency() throws IOException, UnsupportedOperationException;

        abstract boolean removeDependency() throws IOException, UnsupportedOperationException;

        abstract FileObject[] getFileObjects();

        void setValid(boolean valid) {
            this.valid = valid;
        }

        boolean isValid() {
            return this.valid;
        }
    }

    public class PreloaderClassComboBoxModel
    extends DefaultComboBoxModel {
        private volatile boolean filling = false;
        private ChangeListener changeListener = null;

        public PreloaderClassComboBoxModel() {
            this.fillNoPreloaderAvailable();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeListener = l;
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeListener = null;
        }

        public final void fillNoPreloaderAvailable() {
            this.removeAllElements();
            this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
        }

        public void fillFromProject(final Project project, final String select, final JFXConfigs configs, final String activeConfig) {
            final Map<FileObject, List<ClassPath>> classpathMap = JFXProjectUtils.getClassPathMap(project);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!PreloaderClassComboBoxModel.this.filling) {
                        PreloaderClassComboBoxModel.this.filling = true;
                        PreloaderClassComboBoxModel.this.removeAllElements();
                        if (project == null) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                            return;
                        }
                        Set<String> appClassNames = JFXProjectUtils.getAppClassNames(classpathMap, "javafx.application.Preloader");
                        if (appClassNames.isEmpty()) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                        } else {
                            PreloaderClassComboBoxModel.this.addElements(appClassNames);
                            if (select != null) {
                                PreloaderClassComboBoxModel.this.setSelectedItem(select);
                            }
                            String verify = (String)PreloaderClassComboBoxModel.this.getSelectedItem();
                            if (!JFXProjectProperties.isEqual(configs.getPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS), verify)) {
                                configs.setPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS, verify);
                            }
                        }
                        if (PreloaderClassComboBoxModel.this.changeListener != null) {
                            PreloaderClassComboBoxModel.this.changeListener.stateChanged(appClassNames.isEmpty() ? null : new ChangeEvent(this));
                        }
                        PreloaderClassComboBoxModel.this.filling = false;
                    }
                }
            });
        }

        public void fillFromJAR(final FileObject jarFile, final JFXProjectProperties fxProps, final String select, final JFXConfigs configs, final String activeConfig) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!PreloaderClassComboBoxModel.this.filling) {
                        PreloaderClassComboBoxModel.this.filling = true;
                        PreloaderClassComboBoxModel.this.removeAllElements();
                        if (jarFile == null) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                            return;
                        }
                        Set<String> appClassNames = JFXProjectUtils.getAppClassNamesInJar(jarFile, "javafx.application.Preloader", fxProps.getFXRunTimeJar());
                        appClassNames.remove("com.javafx.main.Main");
                        appClassNames.remove("com.javafx.main.NoJavaFXFallback");
                        if (appClassNames.isEmpty()) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                        } else {
                            PreloaderClassComboBoxModel.this.addElements(appClassNames);
                            if (select != null) {
                                PreloaderClassComboBoxModel.this.setSelectedItem(select);
                            }
                            String verify = (String)PreloaderClassComboBoxModel.this.getSelectedItem();
                            if (!JFXProjectProperties.isEqual(configs.getPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS), verify)) {
                                configs.setPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS, verify);
                            }
                        }
                        if (PreloaderClassComboBoxModel.this.changeListener != null) {
                            PreloaderClassComboBoxModel.this.changeListener.stateChanged(appClassNames.isEmpty() ? null : new ChangeEvent(this));
                        }
                        PreloaderClassComboBoxModel.this.filling = false;
                    }
                }
            });
        }

        private void addElements(Set<String> elems) {
            for (String elem : elems) {
                this.addElement(elem);
            }
        }
    }

    public static class PropertyCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            if (!table.getModel().isCellEditable(row, column)) {
                cell.setForeground(INVALID_CELL_CONTENT_COLOR);
            } else {
                cell.setForeground(UIManager.getColor("textText"));
            }
            return cell;
        }
    }

    public static class PropertyCellEditor
    extends DefaultCellEditor
    implements CellEditorListener {
        private DocumentListener listener = null;
        private Document document = null;

        public PropertyCellEditor() {
            super(new JTextField());
        }

        public void registerCellEditorListener() {
            this.addCellEditorListener(this);
        }

        public void unregisterCellEditorListener() {
            this.removeCellEditorListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.document != null) {
                this.document.removeDocumentListener(this.listener);
            }
            JTextField editor = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.document = editor.getDocument();
            this.listener = new CellEditorDocumentListener(table.getModel(), row, column);
            this.document.addDocumentListener(this.listener);
            return editor;
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            this.removeDocumentListenerReference();
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            this.removeDocumentListenerReference();
        }

        private void removeDocumentListenerReference() {
            if (this.document != null) {
                this.document.removeDocumentListener(this.listener);
                this.document = null;
            }
            this.listener = null;
        }

        private class CellEditorDocumentListener
        implements DocumentListener {
            private TableModel model;
            private int row;
            private int column;

            private CellEditorDocumentListener(TableModel model, int row, int column) {
                this.model = model;
                this.row = row;
                this.column = column;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            private void update(DocumentEvent e) {
                Document d = e.getDocument();
                try {
                    this.model.setValueAt(d.getText(0, d.getLength()), this.row, this.column);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    public static class PropertiesTableModel
    extends AbstractTableModel {
        private List<Map<String, String>> properties;
        private List<Map<String, String>> defaultProperties;
        private String[] propSuffixes;
        private String[] columnNames;

        public PropertiesTableModel(List<Map<String, String>> props, List<Map<String, String>> defaultProps, String[] sfxs, String[] clmns) {
            if (sfxs.length < clmns.length) {
                throw new IllegalArgumentException();
            }
            this.properties = props;
            this.defaultProperties = defaultProps;
            this.propSuffixes = sfxs;
            this.columnNames = clmns;
        }

        public boolean isValid() {
            assert (this.properties != null);
            for (Map<String, String> map : this.properties) {
                String left = map.get(this.propSuffixes[0]);
                if (left != null && !left.trim().isEmpty()) continue;
                for (int c = 1; c < this.columnNames.length; ++c) {
                    String right = map.get(this.propSuffixes[c]);
                    if (right == null || right.isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean hasDefaultProperties() {
            return this.defaultProperties != null;
        }

        public boolean isRowEmpty(int index) {
            if (!this.properties.isEmpty() && index < this.properties.size()) {
                Map<String, String> last = this.properties.get(index);
                for (int c = 0; c < this.columnNames.length; ++c) {
                    String value = last.get(this.propSuffixes[c]);
                    if (value == null || value.isEmpty()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean isLastRowEmpty() {
            return this.isRowEmpty(this.properties.size() - 1);
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            String left;
            return columnIndex <= 0 || (left = this.properties.get(rowIndex).get(this.propSuffixes[columnIndex - 1])) != null && !left.isEmpty();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.properties.get(rowIndex).put(this.propSuffixes[columnIndex], (String)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.properties.get(rowIndex).get(this.propSuffixes[columnIndex]);
        }

        public void reset() {
            if (this.defaultProperties != null) {
                this.properties.clear();
                this.properties.addAll(this.defaultProperties);
            } else {
                this.properties.clear();
            }
            this.fireTableDataChanged();
        }

        public boolean isResettable() {
            if (this.hasDefaultProperties()) {
                return !this.areEqual(this.properties, this.defaultProperties);
            }
            return !this.properties.isEmpty();
        }

        private boolean areEqual(List<Map<String, String>> list1, List<Map<String, String>> list2) {
            String s2;
            String s1 = this.getAsString(list1);
            return JFXProjectProperties.isEqualText(s1, s2 = this.getAsString(list2));
        }

        private String getAsString(List<Map<String, String>> list) {
            if (list != null) {
                LinkedList<String> l = new LinkedList<String>();
                for (Map<String, String> entry : list) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < this.columnNames.length; ++i) {
                        sb.append(this.propSuffixes[i]);
                        sb.append(entry.get(this.propSuffixes[i]));
                    }
                    l.add(sb.toString());
                }
                Collections.sort(l);
                return ((Object)l).toString();
            }
            return null;
        }

        public void addRow() {
            HashMap<String, String> emptyMap = new HashMap<String, String>();
            for (String suffix : this.propSuffixes) {
                emptyMap.put(suffix, "");
            }
            this.properties.add(emptyMap);
            this.fireTableDataChanged();
        }

        public void removeRow(int index) {
            this.properties.remove(index);
            this.fireTableDataChanged();
        }

        private int getEmptyRow() {
            for (int i = 0; i < this.properties.size(); ++i) {
                if (!this.isRowEmpty(i)) continue;
                return i;
            }
            return -1;
        }

        public void removeEmptyRows() {
            boolean removed = false;
            while (true) {
                int i;
                if ((i = this.getEmptyRow()) == -1) {
                    if (removed) {
                        this.fireTableDataChanged();
                    }
                    return;
                }
                this.removeRow(i);
                removed = true;
            }
        }
    }

    public static enum BundlingType {
        NONE("none", OS.ALL, "None"),
        ALL("all", OS.ALL, "All Artifacts"),
        IMAGE("image", OS.ALL, "Image Only"),
        INSTALLER("installer", OS.ALL, "All Installers"),
        DEB("deb", OS.LINUX, "DEB Package"),
        RPM("rpm", OS.LINUX, "RPM Package"),
        DMG("dmg", OS.MAC, "DMG Image"),
        EXE("exe", OS.WIN, "EXE Installer"),
        MSI("msi", OS.WIN, "MSI Installer");

        private final String propertyValue;
        private final String description;
        private final OS extent;

        private BundlingType(String propertyValue, OS os, String desc) {
            this.propertyValue = propertyValue;
            this.extent = os;
            this.description = desc;
        }

        public String getValue() {
            return this.propertyValue;
        }

        public OS getExtent() {
            return this.extent;
        }

        public String toString() {
            return this.description;
        }

        public static enum OS {
            ALL,
            WIN,
            MAC,
            LINUX,
            NONE;

        }
    }

    public static enum SigningType {
        NOSIGN("notsigned"),
        SELF("self"),
        KEY("key");

        private final String propertyValue;

        private SigningType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }

    public static enum RunAsType {
        STANDALONE("standalone", DEFAULT_CONFIG_STANDALONE),
        ASWEBSTART("webstart", DEFAULT_CONFIG_WEBSTART),
        INBROWSER("embedded", DEFAULT_CONFIG_BROWSER);

        private final String propertyValue;
        private final String defaultConfig;

        private RunAsType(String propertyValue, String defaultConfig) {
            this.propertyValue = propertyValue;
            this.defaultConfig = defaultConfig;
        }

        public String getString() {
            return this.propertyValue;
        }

        public String getDefaultConfig() {
            return this.defaultConfig;
        }
    }

    public static enum PreloaderSourceType {
        NONE("none"),
        PROJECT("project"),
        JAR("jar");

        private final String propertyValue;

        private PreloaderSourceType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }
}

