/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ScanUtils;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JFXApplicationClassChooser
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(JFXApplicationClassChooser.class);
    private static final Logger LOG = Logger.getLogger(JFXApplicationClassChooser.class.getName());
    static final String LOG_INIT = "INIT";
    static final String LOG_MAIN_CLASSES = "MAIN-CLASSES: {0} SCAN: {1}";
    private final PropertyEvaluator evaluator;
    private final Project project;
    private ChangeListener changeListener;
    private final boolean isFXinSwing;
    private JScrollPane jScrollPane1;
    private JLabel labelAppClasses;
    private JLabel labelScanning;
    private JList listAppClasses;

    public JFXApplicationClassChooser(@NonNull Project p, @NonNull PropertyEvaluator pe) {
        this.evaluator = pe;
        this.project = p;
        this.isFXinSwing = JFXProjectUtils.isFXinSwingProject(p);
        this.initComponents();
        if (!SourceUtils.isScanInProgress()) {
            this.labelScanning.setVisible(false);
        }
        this.listAppClasses.setCellRenderer(new AppClassRenderer());
        this.initClassesView();
        this.initClassesModel();
    }

    private void initComponents() {
        this.labelAppClasses = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listAppClasses = new JList();
        this.labelScanning = new JLabel();
        this.setPreferredSize(new Dimension(380, 300));
        this.setLayout(new GridBagLayout());
        this.labelAppClasses.setLabelFor(this.listAppClasses);
        Mnemonics.setLocalizedText((JLabel)this.labelAppClasses, (String)NbBundle.getMessage(JFXApplicationClassChooser.class, (String)"LBL_JFXApplicationClassChooser.labelAppClasses.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 2, 10);
        this.add((Component)this.labelAppClasses, gridBagConstraints);
        this.labelAppClasses.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXApplicationClassChooser.class, (String)"AN_JFXApplicationClassChooser.labelAppClasses.text"));
        this.labelAppClasses.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXApplicationClassChooser.class, (String)"AD_JFXApplicationClassChooser.labelAppClasses.text"));
        this.jScrollPane1.setViewportView(this.listAppClasses);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.labelScanning.setFont(this.labelScanning.getFont().deriveFont(this.labelScanning.getFont().getStyle() | 2, this.labelScanning.getFont().getSize() + 1));
        this.labelScanning.setText(NbBundle.getMessage(JFXApplicationClassChooser.class, (String)"LBL_ChooseMainClass_SCANNING_MESSAGE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.add((Component)this.labelScanning, gridBagConstraints);
        this.labelScanning.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXApplicationClassChooser.class, (String)"LBL_ChooseMainClass_SCANNING_MESSAGE"));
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListener = null;
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(JFXApplicationClassChooser.class, (String)"Item_ChooseMainClass_WARMUP_MESSAGE")};
    }

    private void initClassesView() {
        this.listAppClasses.setSelectionMode(0);
        this.listAppClasses.setListData(this.getWarmupList());
        this.listAppClasses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (JFXApplicationClassChooser.this.changeListener != null) {
                    JFXApplicationClassChooser.this.changeListener.stateChanged(new ChangeEvent(evt));
                }
            }
        });
        this.listAppClasses.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && JFXApplicationClassChooser.this.getSelectedClass() != null && JFXApplicationClassChooser.this.changeListener != null) {
                    JFXApplicationClassChooser.this.changeListener.stateChanged(new ChangeEvent(e));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void initClassesModel() {
        final Map<FileObject, List<ClassPath>> classpathMap = JFXProjectUtils.getClassPathMap(this.project);
        if (classpathMap.isEmpty()) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                LOG.log(Level.FINE, JFXApplicationClassChooser.LOG_INIT);
                List cps = (List)classpathMap.values().iterator().next();
                ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)((ClassPath)cps.get(0)), (ClassPath)((ClassPath)cps.get(1)), (ClassPath)((ClassPath)cps.get(2)));
                JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
                ScanUtils.postUserActionTask((JavaSource)js, (Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        final boolean barrier = SourceUtils.isScanInProgress();
                        final Set<String> appClassNames = JFXApplicationClassChooser.this.isFXinSwing ? JFXProjectUtils.getMainClassNames(JFXApplicationClassChooser.this.project) : JFXProjectUtils.getAppClassNames(classpathMap, "javafx.application.Application");
                        LOG.log(Level.FINE, JFXApplicationClassChooser.LOG_MAIN_CLASSES, new Object[]{appClassNames, barrier});
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!barrier) {
                                    JFXApplicationClassChooser.this.labelScanning.setVisible(false);
                                }
                                JFXApplicationClassChooser.this.listAppClasses.setListData(appClassNames.toArray());
                                String appClassName = JFXApplicationClassChooser.this.evaluator.getProperty(JFXApplicationClassChooser.this.isFXinSwing ? "main.class" : "javafx.main.class");
                                if (appClassName != null && appClassNames.contains(appClassName)) {
                                    JFXApplicationClassChooser.this.listAppClasses.setSelectedValue(appClassName, true);
                                }
                            }
                        });
                        if (barrier) {
                            ScanUtils.signalIncompleteData((CompilationInfo)parameter, null);
                        }
                    }
                });
            }
        });
    }

    public String getSelectedClass() {
        Object sel = this.listAppClasses.getSelectedValue();
        if (sel == null) {
            return null;
        }
        if (sel instanceof String) {
            return (String)sel;
        }
        return null;
    }

    private static final class AppClassRenderer
    extends DefaultListCellRenderer {
        private AppClassRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName = value instanceof String ? (String)value : value.toString();
            return super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
        }
    }
}

