/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.repository.disk.DiskLayerImpl;
import org.netbeans.modules.cnd.repository.impl.spi.Layer;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.impl.spi.ReadLayerCapability;
import org.netbeans.modules.cnd.repository.impl.spi.UnitDescriptorsList;
import org.netbeans.modules.cnd.repository.impl.spi.WriteLayerCapability;
import org.openide.filesystems.FileSystem;

final class DiskLayerImplDelegate
implements Layer {
    private static final Map<DiskLayerImpl, AtomicInteger> refCounter = new HashMap<DiskLayerImpl, AtomicInteger>();
    private static final Set<DiskLayerImpl> writableLayers = new HashSet<DiskLayerImpl>();
    private final LayerDescriptor layerDescriptor;
    private final DiskLayerImpl impl;

    public DiskLayerImplDelegate(DiskLayerImpl impl, LayerDescriptor layerDescriptor) {
        this.impl = impl;
        this.layerDescriptor = layerDescriptor;
        AtomicInteger counter = refCounter.get(impl);
        if (counter == null) {
            counter = new AtomicInteger();
            refCounter.put(impl, counter);
        }
        counter.incrementAndGet();
        if (layerDescriptor.isWritable()) {
            writableLayers.add(impl);
        }
    }

    public Collection<LayerKey> removedTableKeySet() {
        return this.impl.removedTableKeySet();
    }

    public boolean startup(int persistMechanismVersion, boolean recreate) {
        return this.impl.startup(persistMechanismVersion, recreate, this.layerDescriptor.isWritable());
    }

    public ReadLayerCapability getReadCapability() {
        return this.impl.getReadCapability();
    }

    public WriteLayerCapability getWriteCapability() {
        return this.layerDescriptor.isWritable() ? this.impl.getWriteCapability() : null;
    }

    public LayerDescriptor getLayerDescriptor() {
        return this.layerDescriptor;
    }

    public void shutdown() {
        AtomicInteger counter = refCounter.get(this.impl);
        if (counter.decrementAndGet() == 0) {
            if (writableLayers.remove(this.impl)) {
                this.impl.storeIndex();
            }
            this.impl.shutdown();
        }
    }

    public void openUnit(int unitIdInLayer) {
        this.impl.openUnit(unitIdInLayer);
    }

    public void closeUnit(int unitIdInLayer, boolean cleanRepository, Set<Integer> requiredUnits) {
        this.impl.closeUnit(unitIdInLayer, cleanRepository, requiredUnits, writableLayers.contains(this.impl));
    }

    public UnitDescriptorsList getUnitsTable() {
        return this.impl.getUnitsTable();
    }

    public List<FileSystem> getFileSystemsTable() {
        return this.impl.getFileSystemsTable();
    }

    public int findMatchedFileSystemIndexInLayer(FileSystem clientFileSystem) {
        return this.impl.findMatchedFileSystemIndexInLayer(clientFileSystem);
    }
}

