/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.disk.BufferedRWAccess;
import org.netbeans.modules.cnd.repository.disk.FileRWAccess;
import org.netbeans.modules.cnd.repository.disk.RepositoryImplUtil;
import org.netbeans.modules.cnd.repository.disk.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.disk.index.CompactFileIndex;
import org.netbeans.modules.cnd.repository.disk.index.FileIndex;
import org.netbeans.modules.cnd.repository.disk.index.FileIndexFactory;
import org.netbeans.modules.cnd.repository.disk.index.SimpleFileIndex;
import org.netbeans.modules.cnd.repository.impl.spi.LayerConvertersProvider;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.storage.data.RepositoryDataInputStream;
import org.netbeans.modules.cnd.repository.storage.data.RepositoryDataOutputStream;
import org.netbeans.modules.cnd.repository.testbench.FileStatistics;
import org.netbeans.modules.cnd.repository.testbench.RangeStatistics;
import org.netbeans.modules.cnd.repository.testbench.Stats;

final class IndexedStorageFile {
    private static final boolean TRACE = false;
    private static final Logger LOG = Logger.getLogger("repository.support.filecreate.logger");
    private final boolean writable;
    private final File dataFile;
    private final File indexFile;
    private final FileStatistics fileStatistics;
    private final FileRWAccess fileRWAccess;
    private final AtomicLong fileRWAccessSize;
    private long usedSize;
    private final FileIndex index;
    private final LayeringSupport layeringSupport;
    private final LayerDescriptor layerDescriptor;

    public IndexedStorageFile(LayeringSupport layeringSupport, LayerDescriptor layerDescriptor, File basePath, String name, boolean writable) throws IOException {
        if (writable && basePath.exists() && !basePath.canWrite()) {
            writable = false;
            RepositoryImplUtil.warnNotWritable(basePath);
        }
        this.layeringSupport = layeringSupport;
        this.layerDescriptor = layerDescriptor;
        this.writable = writable;
        this.dataFile = new File(basePath, name + "-data");
        this.indexFile = new File(basePath, name + "-index");
        this.fileStatistics = new FileStatistics();
        boolean filesExists = this.dataFile.exists() && this.indexFile.exists();
        this.fileRWAccess = this.createFileRWAccess(this.dataFile, writable);
        FileIndex loadedIndex = null;
        if (filesExists) {
            loadedIndex = this.loadIndex(this.indexFile);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Load index size={0} from {1}", new Object[]{loadedIndex.size(), this.indexFile});
            }
        }
        if (loadedIndex == null) {
            loadedIndex = Stats.useCompactIndex ? new CompactFileIndex() : new SimpleFileIndex();
        }
        this.index = loadedIndex;
        this.usedSize = this.getIndexSize();
        if (writable && this.usedSize == 0L) {
            this.fileRWAccess.truncate(0L);
        }
        if (writable && this.indexFile.exists() && !this.indexFile.delete()) {
            System.err.println("Cannot delete repository index file " + this.indexFile.getAbsolutePath());
        }
        this.fileRWAccessSize = new AtomicLong(this.fileRWAccess.size());
    }

    boolean hasKey(LayerKey key) {
        return this.index.get(key) != null;
    }

    ByteBuffer read(LayerKey key) throws IOException {
        ByteBuffer buffer = null;
        ChunkInfo chunkInfo = this.index.get(key);
        if (chunkInfo != null) {
            try {
                buffer = this.fileRWAccess.readData(chunkInfo.getOffset(), chunkInfo.getSize());
            }
            catch (BufferOverflowException e) {
                RepositoryExceptions.throwException((Object)this, (Throwable)e);
                throw e;
            }
            catch (BufferUnderflowException e) {
                RepositoryExceptions.throwException((Object)this, (Throwable)e);
                throw e;
            }
            if (Stats.fileStatisticsLevel > 0) {
                this.fileStatistics.incrementReadCount(key);
            }
        }
        return buffer;
    }

    void write(LayerKey key, ByteBuffer data) throws IOException {
        ChunkInfo oldInfo = this.index.get(key);
        int oldSize = oldInfo == null ? 0 : oldInfo.getSize();
        int newSize = data.limit();
        long offset = this.fileRWAccess.appendData(data);
        this.fileRWAccessSize.addAndGet(newSize);
        this.usedSize += (long)(newSize - oldSize);
        this.index.put(key, offset, newSize);
        assert (this.index.get(key).getOffset() == offset && this.index.get(key).getSize() == newSize) : "Cannot write Key " + key;
        assert (this.fileRWAccess.size() == this.fileRWAccessSize.get()) : "Cannot write data for key " + key;
        if (Stats.fileStatisticsLevel > 0) {
            this.fileStatistics.incrementWriteCount(key, oldSize, newSize);
        }
    }

    void remove(LayerKey key) throws IOException {
        int oldSize;
        if (Stats.fileStatisticsLevel > 0) {
            this.fileStatistics.removeNotify(key);
        }
        if ((oldSize = this.index.remove(key)) != 0) {
            if (this.index.size() == 0) {
                this.fileRWAccess.truncate(0L);
                this.fileRWAccessSize.set(0L);
                this.usedSize = 0L;
            } else {
                this.usedSize -= (long)oldSize;
            }
        }
    }

    int getObjectsCount() {
        return this.index.size();
    }

    long getSize() throws IOException {
        return this.fileRWAccessSize.get();
    }

    void close() throws IOException {
        if (Stats.dumoFileOnExit) {
            this.dump(System.out);
        } else if (Stats.fileStatisticsLevel > 0) {
            this.dumpSummary(System.out);
        }
        this.fileRWAccess.close();
        if (this.writable) {
            this.storeIndex();
        }
    }

    int getFragmentationPercentage() throws IOException {
        long fileSize = this.getSize();
        float delta = fileSize - this.usedSize;
        float percentage = delta * 100.0f / (float)fileSize;
        return Math.round(percentage);
    }

    void dump(PrintStream ps) throws IOException {
        for (LayerKey key : this.index.keySet()) {
            ChunkInfo chunk = this.index.get(key);
            this.print(ps, null, chunk, true);
        }
        ChunkInfo[] infos = this.sortedChunkInfos();
        for (int i = 0; i < infos.length; ++i) {
            this.print(ps, null, infos[i], true);
        }
        this.dumpSummary(ps, infos);
    }

    private long getIndexSize() {
        long calcUsedSize = 0L;
        for (LayerKey key : this.index.keySet()) {
            ChunkInfo info = this.index.get(key);
            calcUsedSize += (long)info.getSize();
        }
        return calcUsedSize;
    }

    void dumpSummary(PrintStream ps) throws IOException {
        this.dumpSummary(ps, null);
    }

    private void dumpSummary(PrintStream ps, ChunkInfo[] sortedInfos) throws IOException {
        RangeStatistics write = new RangeStatistics("Writes:", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        RangeStatistics read = new RangeStatistics("Reads: ", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        RangeStatistics size = new RangeStatistics("Sizes: ", Stats.fileStatisticsLevel, Stats.fileStatisticsRanges);
        for (LayerKey key : this.index.keySet()) {
            ChunkInfo info = this.index.get(key);
            this.usedSize += (long)info.getSize();
            read.consume(this.fileStatistics.getReadCount(key));
            write.consume(this.fileStatistics.getWriteCount(key));
            size.consume(info.getSize());
        }
        if (sortedInfos == null) {
            sortedInfos = this.sortedChunkInfos();
        }
        long firstExtent = sortedInfos.length > 0 ? sortedInfos[0].getOffset() : 0L;
    }

    private void print(PrintStream ps, LayerKey key, ChunkInfo chunk, boolean lf) {
    }

    private ChunkInfo[] sortedChunkInfos() {
        Object[] infos = new ChunkInfo[this.index.size()];
        int pos = 0;
        for (LayerKey key : this.index.keySet()) {
            infos[pos++] = this.index.get(key);
        }
        Arrays.sort(infos);
        return infos;
    }

    String getTraceString() throws IOException {
        Formatter formatter = new Formatter();
        formatter.format("%s index size %d  file size %d  fragmentation %d%%", this.dataFile.getName(), this.index.size(), this.getSize(), this.getFragmentationPercentage());
        return formatter.toString();
    }

    Iterator<LayerKey> getKeySetIterator() {
        return new IndexIterator();
    }

    ChunkInfo getChunkInfo(LayerKey key) {
        return this.index.get(key);
    }

    String getDataFileName() {
        return this.dataFile.getName();
    }

    long getDataFileUsedSize() {
        return this.usedSize;
    }

    void moveDataFromOtherFile(IndexedStorageFile other, long l, int size, LayerKey key) throws IOException {
        FileRWAccess fileRW = other.fileRWAccess;
        ChunkInfo exist = this.index.get(key);
        if (exist == null) {
            long newOffset = this.fileRWAccess.move(fileRW, l, size);
            this.fileRWAccessSize.addAndGet(size);
            this.index.put(key, newOffset, size);
            assert (this.index.get(key).getOffset() == newOffset && this.index.get(key).getSize() == size) : "Cannot write Key " + key;
            assert (this.fileRWAccess.size() == this.fileRWAccessSize.get()) : "Cannot write data for key " + key;
            this.usedSize += (long)size;
        }
    }

    FileRWAccess getDataFile() {
        return this.fileRWAccess;
    }

    private FileRWAccess createFileRWAccess(File file, boolean writable) throws IOException {
        return new BufferedRWAccess(file, writable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileIndex loadIndex(File indexFile) {
        FileIndex idx = null;
        FilterInputStream din = null;
        try {
            din = new RepositoryDataInputStream(RepositoryImplUtil.getBufferedDataInputStream(indexFile), LayerConvertersProvider.getInstance((LayeringSupport)this.layeringSupport, (LayerDescriptor)this.layerDescriptor));
            idx = FileIndexFactory.getDefaultFactory().readIndex((RepositoryDataInput)din);
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)("IndexedStorageFile for file " + indexFile), (Throwable)ex);
        }
        finally {
            if (din != null) {
                try {
                    din.close();
                }
                catch (IOException iOException) {}
            }
        }
        return idx;
    }

    private void storeIndex() throws IOException {
        FilterOutputStream dos = null;
        try {
            dos = new RepositoryDataOutputStream(RepositoryImplUtil.getBufferedDataOutputStream(this.indexFile), LayerConvertersProvider.getInstance((LayeringSupport)this.layeringSupport, (LayerDescriptor)this.layerDescriptor));
            FileIndexFactory.getDefaultFactory().writeIndex(this.index, (RepositoryDataOutput)dos);
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.dataFile + " usedSize=" + this.usedSize + " size=" + this.dataFile.length();
    }

    private class IndexIterator
    implements Iterator<LayerKey> {
        private final Iterator<LayerKey> indexIterator;
        private LayerKey currentKey;

        IndexIterator() {
            this.indexIterator = IndexedStorageFile.this.index.getKeySetIterator();
        }

        @Override
        public boolean hasNext() {
            return this.indexIterator.hasNext();
        }

        @Override
        public LayerKey next() {
            this.currentKey = this.indexIterator.next();
            return this.currentKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

