/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api;

public final class ProblemDescription {
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL = 3;
    public static final int INTERNAL_ERROR = 4;
    private String key;
    private String text;
    private int from;
    private int to;
    private int type;

    public static ProblemDescription create(String key, String text, int type, int from, int to) {
        return new ProblemDescription(key, text, type, from, to);
    }

    private ProblemDescription(String key, String text, int type, int from, int to) {
        assert (from >= 0);
        assert (to >= 0);
        assert (from <= to);
        this.key = key;
        this.text = text;
        this.type = type;
        this.from = from;
        this.to = to;
    }

    public String getKey() {
        return this.key;
    }

    public int getType() {
        return this.type;
    }

    public int getFrom() {
        return this.from;
    }

    public String getText() {
        return this.text;
    }

    public int getTo() {
        return this.to;
    }

    public String toString() {
        return this.dump(null);
    }

    public String dump(String code) {
        String ttype = "";
        switch (this.getType()) {
            case 0: {
                ttype = "Information";
                break;
            }
            case 1: {
                ttype = "Warning";
                break;
            }
            case 2: {
                ttype = "Error";
                break;
            }
            case 3: {
                ttype = "Fatal Error";
                break;
            }
            case 4: {
                ttype = "Internal Error";
            }
        }
        String nodetext = code == null ? "" : code.substring(this.getFrom(), this.getTo());
        return ttype + ":" + this.getKey() + " [" + this.getFrom() + " - " + this.getTo() + "]: '" + nodetext + (this.getText() != null ? "'; msg=" + this.getText() : "");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProblemDescription other = (ProblemDescription)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.from != other.from) {
            return false;
        }
        if (this.to != other.to) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.key != null ? this.key.hashCode() : 0);
        hash = 23 * hash + this.from;
        hash = 23 * hash + this.to;
        hash = 23 * hash + this.type;
        return hash;
    }
}

