/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.ElementType;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.ScopeVerifier;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.TargetVerifier;
import org.netbeans.modules.web.beans.impl.model.RuntimeAnnotationChecker;

class ScopeChecker
extends RuntimeAnnotationChecker {
    static String SCOPE = "javax.inject.Scope";
    static String NORMAL_SCOPE = "javax.enterprise.context.NormalScope";

    ScopeChecker() {
    }

    static ScopeChecker get() {
        return new ScopeChecker();
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(ScopeChecker.class.getName());
    }

    @Override
    protected String getAnnotation() {
        return SCOPE;
    }

    @Override
    protected TargetVerifier getTargetVerifier() {
        return ScopeVerifier.getInstance();
    }

    @Override
    public boolean hasReqiredTarget(AnnotationMirror target, Set<ElementType> set) {
        boolean hasRequiredTarget = super.hasReqiredTarget(target, set);
        if (!hasRequiredTarget) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as Scope but has wrong target values." + " Correct target values are {METHOD, FIELD, TYPE}");
        }
        return hasRequiredTarget;
    }
}

