/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.validation.ProjectFoldersValidator;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SourcesPanel
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = -6576834165786545L;
    private final ProjectCustomizer.Category category;
    private final ClientSideProjectProperties uiProperties;
    private final ClientSideProject project;
    private JComboBox encodingComboBox;
    private JLabel encodingLabel;
    private JLabel projectFolderLabel;
    private JTextField projectFolderTextField;
    private JButton siteRootFolderBrowseButton;
    private JLabel siteRootFolderInfoLabel;
    private JButton siteRootFolderRemoveButton;
    private JTextField siteRootFolderTextField;
    private JLabel siteRootLabel;
    private JButton sourceFolderBrowseButton;
    private JLabel sourceFolderInfoLabel;
    private JLabel sourceFolderLabel;
    private JButton sourceFolderRemoveButton;
    private JTextField sourceFolderTextField;
    private JButton testFolderBrowseButton;
    private JLabel testFolderInfoLabel;
    private JLabel testFolderLabel;
    private JButton testFolderRemoveButton;
    private JTextField testFolderTextField;
    private JButton testSeleniumFolderBrowseButton;
    private JLabel testSeleniumFolderInfoLabel;
    private JLabel testSeleniumFolderLabel;
    private JButton testSeleniumFolderRemoveButton;
    private JTextField testSeleniumFolderTextField;

    public SourcesPanel(ProjectCustomizer.Category category, ClientSideProjectProperties uiProperties) {
        assert (category != null);
        assert (uiProperties != null);
        this.category = category;
        this.uiProperties = uiProperties;
        this.project = uiProperties.getProject();
        this.initComponents();
        this.init();
        this.initListeners();
        this.validateData();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.clientproject.ui.customizer.SourcesPanel");
    }

    private void init() {
        this.projectFolderTextField.setText(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
        this.setSiteRootFolder(this.beautifyPath(this.uiProperties.getSiteRootFolder().get()), false);
        this.setSourceFolder(this.beautifyPath(this.uiProperties.getSourceFolder().get()), false);
        this.setTestFolder(this.beautifyPath(this.uiProperties.getTestFolder().get()), false);
        this.setTestSeleniumFolder(this.beautifyPath(this.uiProperties.getTestSeleniumFolder().get()), false);
        this.encodingComboBox.setModel(ProjectCustomizer.encodingModel((String)this.uiProperties.getEncoding()));
        this.encodingComboBox.setRenderer(ProjectCustomizer.encodingRenderer());
    }

    private void initListeners() {
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.siteRootFolderTextField.getDocument().addDocumentListener(documentListener);
        this.sourceFolderTextField.getDocument().addDocumentListener(documentListener);
        this.testFolderTextField.getDocument().addDocumentListener(documentListener);
        this.testSeleniumFolderTextField.getDocument().addDocumentListener(documentListener);
        this.encodingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcesPanel.this.validateAndStore();
            }
        });
    }

    void validateAndStore() {
        this.validateData();
        this.storeData();
    }

    private void validateData() {
        ValidationResult result = new ProjectFoldersValidator().validate(this.getSourceFolder(), this.getSiteRootFolder(), this.getTestFolder(), this.getTestSeleniumFolder()).getResult();
        if (result.hasErrors()) {
            this.category.setErrorMessage(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            this.category.setValid(false);
            return;
        }
        if (result.hasWarnings()) {
            this.category.setErrorMessage(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(" ");
        this.category.setValid(true);
    }

    private void storeData() {
        File siteRootFolder = this.getSiteRootFolder();
        this.uiProperties.setSiteRootFolder(siteRootFolder != null ? siteRootFolder.getAbsolutePath() : null);
        File sourceFolder = this.getSourceFolder();
        this.uiProperties.setSourceFolder(sourceFolder != null ? sourceFolder.getAbsolutePath() : null);
        File testFolder = this.getTestFolder();
        this.uiProperties.setTestFolder(testFolder != null ? testFolder.getAbsolutePath() : null);
        File testSeleniumFolder = this.getTestSeleniumFolder();
        this.uiProperties.setTestSeleniumFolder(testSeleniumFolder != null ? testSeleniumFolder.getAbsolutePath() : null);
        this.uiProperties.setEncoding(this.getEncoding().name());
    }

    private void setSiteRootFolder(String siteRoot) {
        this.setSiteRootFolder(siteRoot, true);
    }

    private void setSiteRootFolder(String siteRoot, boolean validate) {
        this.setFolder(siteRoot, this.siteRootFolderTextField, this.siteRootFolderRemoveButton, validate);
        this.siteRootFolderInfoLabel.setText(siteRoot != null ? Bundle.SourcesPanel_siteRoot_info_empty() : Bundle.SourcesPanel_siteRoot_info_none());
    }

    private void setSourceFolder(String sources) {
        this.setSourceFolder(sources, true);
    }

    private void setSourceFolder(String sources, boolean validate) {
        this.setFolder(sources, this.sourceFolderTextField, this.sourceFolderRemoveButton, validate);
        this.sourceFolderInfoLabel.setText(sources != null ? Bundle.SourcesPanel_sources_info_empty() : Bundle.SourcesPanel_sources_info_none());
    }

    private void setTestFolder(String tests) {
        this.setTestFolder(tests, true);
    }

    private void setTestFolder(String tests, boolean validate) {
        this.setFolder(tests, this.testFolderTextField, this.testFolderRemoveButton, validate);
        this.testFolderInfoLabel.setText(Bundle.SourcesPanel_tests_info());
    }

    private void setTestSeleniumFolder(String tests) {
        this.setTestSeleniumFolder(tests, true);
    }

    private void setTestSeleniumFolder(String tests, boolean validate) {
        this.setFolder(tests, this.testSeleniumFolderTextField, this.testSeleniumFolderRemoveButton, validate);
        this.testSeleniumFolderInfoLabel.setText(Bundle.SourcesPanel_tests_selenium_info());
    }

    private void setFolder(String folder, JTextField textField, JButton removeButton, boolean validate) {
        textField.setText(folder);
        textField.setEnabled(folder != null);
        removeButton.setEnabled(folder != null);
        if (validate) {
            this.validateAndStore();
        }
    }

    @CheckForNull
    private File getSiteRootFolder() {
        return this.getFolder(this.siteRootFolderTextField);
    }

    @CheckForNull
    private File getSourceFolder() {
        return this.getFolder(this.sourceFolderTextField);
    }

    @CheckForNull
    private File getFolder(JTextField textField) {
        if (!textField.isEnabled()) {
            return null;
        }
        File resolved = this.resolveFile(textField.getText(), true);
        if (resolved != null) {
            return resolved;
        }
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    private File getTestFolder() {
        return this.resolveFile(this.testFolderTextField.getText(), false);
    }

    private File getTestSeleniumFolder() {
        return this.resolveFile(this.testSeleniumFolderTextField.getText(), false);
    }

    private Charset getEncoding() {
        return (Charset)this.encodingComboBox.getSelectedItem();
    }

    private File resolveFile(String path, boolean emptyIsProject) {
        if (path == null) {
            return null;
        }
        if (!emptyIsProject && path.isEmpty()) {
            return null;
        }
        return FileUtil.normalizeFile((File)this.project.getProjectHelper().resolveFile(path));
    }

    private String browseFolder(String title, File currentPath) {
        File folder;
        File workDir = currentPath;
        if (workDir == null || !workDir.exists()) {
            workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        if ((folder = new FileChooserBuilder(SourcesPanel.class).setTitle(title).setDirectoriesOnly(true).setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true).setFileHiding(true).showOpenDialog()) == null) {
            return null;
        }
        String filePath = this.project.is.relativizeFile(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), folder);
        if (filePath == null) {
            filePath = folder.getAbsolutePath();
        }
        return this.beautifyPath(filePath);
    }

    private String beautifyPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(".")) {
            return "";
        }
        if (path.startsWith("../../")) {
            File resolved = this.resolveFile(path, false);
            assert (resolved != null) : path;
            return resolved.getAbsolutePath();
        }
        return path;
    }

    private void initComponents() {
        this.projectFolderLabel = new JLabel();
        this.projectFolderTextField = new JTextField();
        this.siteRootLabel = new JLabel();
        this.siteRootFolderTextField = new JTextField();
        this.siteRootFolderBrowseButton = new JButton();
        this.siteRootFolderRemoveButton = new JButton();
        this.siteRootFolderInfoLabel = new JLabel();
        this.sourceFolderLabel = new JLabel();
        this.sourceFolderTextField = new JTextField();
        this.sourceFolderBrowseButton = new JButton();
        this.sourceFolderRemoveButton = new JButton();
        this.sourceFolderInfoLabel = new JLabel();
        this.testFolderLabel = new JLabel();
        this.testFolderTextField = new JTextField();
        this.testFolderBrowseButton = new JButton();
        this.testFolderInfoLabel = new JLabel();
        this.testFolderRemoveButton = new JButton();
        this.encodingLabel = new JLabel();
        this.encodingComboBox = new JComboBox();
        this.testSeleniumFolderLabel = new JLabel();
        this.testSeleniumFolderTextField = new JTextField();
        this.testSeleniumFolderBrowseButton = new JButton();
        this.testSeleniumFolderRemoveButton = new JButton();
        this.testSeleniumFolderInfoLabel = new JLabel();
        this.projectFolderLabel.setLabelFor(this.projectFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.projectFolderLabel.text"));
        this.projectFolderTextField.setEditable(false);
        this.siteRootLabel.setLabelFor(this.siteRootFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.siteRootLabel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.siteRootLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.siteRootFolderBrowseButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.siteRootFolderBrowseButton.text"));
        this.siteRootFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.siteRootFolderBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.siteRootFolderRemoveButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.siteRootFolderRemoveButton.text"));
        this.siteRootFolderRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.siteRootFolderRemoveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.siteRootFolderInfoLabel, (String)"HINT");
        this.sourceFolderLabel.setLabelFor(this.sourceFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.sourceFolderLabel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.sourceFolderLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sourceFolderBrowseButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.sourceFolderBrowseButton.text"));
        this.sourceFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.sourceFolderBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.sourceFolderRemoveButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.sourceFolderRemoveButton.text"));
        this.sourceFolderRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.sourceFolderRemoveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.sourceFolderInfoLabel, (String)"HINT");
        this.testFolderLabel.setLabelFor(this.testFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.testFolderLabel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.testFolderLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testFolderBrowseButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.testFolderBrowseButton.text"));
        this.testFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.testFolderBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.testFolderInfoLabel, (String)"HINT");
        Mnemonics.setLocalizedText((AbstractButton)this.testFolderRemoveButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.testFolderRemoveButton.text"));
        this.testFolderRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.testFolderRemoveButtonActionPerformed(evt);
            }
        });
        this.encodingLabel.setLabelFor(this.encodingComboBox);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.encodingLabel.text"));
        this.testSeleniumFolderLabel.setLabelFor(this.testFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.testSeleniumFolderLabel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.testSeleniumFolderLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testSeleniumFolderBrowseButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.testSeleniumFolderBrowseButton.text"));
        this.testSeleniumFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.testSeleniumFolderBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.testSeleniumFolderRemoveButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.testSeleniumFolderRemoveButton.text"));
        this.testSeleniumFolderRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.testSeleniumFolderRemoveButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.testSeleniumFolderInfoLabel, (String)"HINT");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteRootLabel).addComponent(this.projectFolderLabel).addComponent(this.testFolderLabel).addComponent(this.encodingLabel).addComponent(this.sourceFolderLabel).addComponent(this.testSeleniumFolderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectFolderTextField).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.encodingComboBox, 0, -1, Short.MAX_VALUE).addGap(95, 95, 95)).addGroup(layout.createSequentialGroup().addComponent(this.sourceFolderTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceFolderBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceFolderRemoveButton)).addGroup(layout.createSequentialGroup().addComponent(this.siteRootFolderTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.siteRootFolderBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.siteRootFolderRemoveButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceFolderInfoLabel).addComponent(this.siteRootFolderInfoLabel).addComponent(this.testFolderInfoLabel).addComponent(this.testSeleniumFolderInfoLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.testFolderTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testFolderBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testFolderRemoveButton)).addGroup(layout.createSequentialGroup().addComponent(this.testSeleniumFolderTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testSeleniumFolderBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testSeleniumFolderRemoveButton)))));
        layout.linkSize(0, this.siteRootFolderBrowseButton, this.testFolderBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectFolderLabel).addComponent(this.projectFolderTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.siteRootLabel).addComponent(this.siteRootFolderTextField, -2, -1, -2).addComponent(this.siteRootFolderBrowseButton).addComponent(this.siteRootFolderRemoveButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.siteRootFolderInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceFolderLabel).addComponent(this.sourceFolderTextField, -2, -1, -2).addComponent(this.sourceFolderBrowseButton).addComponent(this.sourceFolderRemoveButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceFolderInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testFolderLabel).addComponent(this.testFolderTextField, -2, -1, -2).addComponent(this.testFolderBrowseButton).addComponent(this.testFolderRemoveButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testFolderInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testSeleniumFolderLabel).addComponent(this.testSeleniumFolderTextField, -2, -1, -2).addComponent(this.testSeleniumFolderBrowseButton).addComponent(this.testSeleniumFolderRemoveButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testSeleniumFolderInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingLabel).addComponent(this.encodingComboBox, -2, -1, -2))));
    }

    private void siteRootFolderBrowseButtonActionPerformed(ActionEvent evt) {
        String filePath = this.browseFolder(Bundle.SourcesPanel_browse_siteRootFolder(), this.getSiteRootFolder());
        if (filePath != null) {
            this.setSiteRootFolder(filePath);
        }
    }

    private void testFolderBrowseButtonActionPerformed(ActionEvent evt) {
        String filePath = this.browseFolder(Bundle.SourcesPanel_browse_testFolder(), this.getTestFolder());
        if (filePath != null) {
            this.setTestFolder(filePath);
        }
    }

    private void siteRootFolderRemoveButtonActionPerformed(ActionEvent evt) {
        this.setSiteRootFolder(null);
    }

    private void sourceFolderRemoveButtonActionPerformed(ActionEvent evt) {
        this.setSourceFolder(null);
    }

    private void testFolderRemoveButtonActionPerformed(ActionEvent evt) {
        this.setTestFolder(null);
    }

    private void sourceFolderBrowseButtonActionPerformed(ActionEvent evt) {
        String filePath = this.browseFolder(Bundle.SourcesPanel_browse_sourceFolder(), this.getSourceFolder());
        if (filePath != null) {
            this.setSourceFolder(filePath);
        }
    }

    private void testSeleniumFolderBrowseButtonActionPerformed(ActionEvent evt) {
        String filePath = this.browseFolder(Bundle.SourcesPanel_browse_testSeleniumFolder(), this.getTestSeleniumFolder());
        if (filePath != null) {
            this.setTestSeleniumFolder(filePath);
        }
    }

    private void testSeleniumFolderRemoveButtonActionPerformed(ActionEvent evt) {
        this.setTestSeleniumFolder(null);
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            SourcesPanel.this.validateAndStore();
        }
    }
}

