/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.diff;

import javax.swing.JComponent;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.diff.DiffTopComponent;
import org.netbeans.modules.git.remote.ui.diff.MultiDiffPanelController;
import org.netbeans.modules.git.remote.ui.repository.Revision;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DiffAction
extends GitAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/remote/resources/icons/diff.png";

    public DiffAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = this.getCurrentContext(nodes);
        this.diff(context);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    public void diff(VCSContext context) {
        this.diff(context, Revision.HEAD, Revision.LOCAL);
    }

    public void diff(VCSContext context, Revision left, Revision right) {
        String contextName = VCSFileProxySupport.getContextDisplayName((VCSContext)context);
        MultiDiffPanelController controller = new MultiDiffPanelController(context, left, right);
        DiffTopComponent tc = new DiffTopComponent(controller);
        controller.setActions((JComponent)((Object)tc));
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)contextName));
        tc.open();
        tc.requestActive();
    }

    public void diff(VCSFileProxy file, Revision rev1, Revision rev2, int requestedRightLine) {
        MultiDiffPanelController controller = new MultiDiffPanelController(file, rev1, rev2, requestedRightLine);
        DiffTopComponent tc = new DiffTopComponent(controller);
        controller.setActions((JComponent)((Object)tc));
        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)file.getName()));
        tc.open();
        tc.requestActive();
    }
}

