/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.history;

import java.awt.BorderLayout;
import java.util.List;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.ui.history.DiffResultsView;
import org.netbeans.modules.git.remote.ui.history.RepositoryRevision;
import org.netbeans.modules.git.remote.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.git.remote.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(persistenceType=2, preferredID="GitRemote.SearchHistoryTopComponent")
public class SearchHistoryTopComponent
extends TopComponent {
    private SearchHistoryPanel shp;
    private SearchCriteriaPanel scp;
    private final VCSFileProxy[] files;
    private final VCSFileProxy repository;
    private final RepositoryInfo info;

    public SearchHistoryTopComponent(VCSFileProxy repository, RepositoryInfo info, VCSFileProxy[] files) {
        this.repository = repository;
        this.info = info;
        this.files = files;
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
        this.initComponents();
    }

    SearchHistoryTopComponent(VCSFileProxy repository, RepositoryInfo info, VCSFileProxy file, DiffResultsViewFactory fac) {
        this(repository, info, new VCSFileProxy[]{file});
        this.shp.setDiffResultsViewFactory(fac);
    }

    public void search(boolean showCriteria) {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(showCriteria);
    }

    void setSearchCommitFrom(String commitId) {
        if (commitId != null) {
            this.scp.tfFrom.setText(commitId);
        }
    }

    void setSearchCommitTo(String commitId) {
        if (commitId != null) {
            this.scp.tfTo.setText(commitId);
        }
    }

    void setBranch(String branch) {
        if (branch != null) {
            this.shp.setBranch(branch);
            if (GitModuleConfig.getDefault().isSearchOnlyCurrentBranchEnabled()) {
                this.scp.setBranch(branch);
            }
        }
    }

    void activateDiffView(boolean selectFirstRevision) {
        this.shp.activateDiffView(selectFirstRevision);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel();
        this.shp = new SearchHistoryPanel(this.repository, this.info, this.files, this.scp);
        this.add(this.shp);
    }

    protected void componentClosed() {
        this.shp.release();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    static class DiffResultsViewFactory {
        DiffResultsViewFactory() {
        }

        DiffResultsView createDiffResultsView(SearchHistoryPanel panel, List<RepositoryRevision> results) {
            return new DiffResultsView(panel, results);
        }
    }
}

