/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.control;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.control.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class RemoveUnnecessary {
    private static final Set<Tree.Kind> LOOP_KINDS = EnumSet.of(Tree.Kind.DO_WHILE_LOOP, Tree.Kind.ENHANCED_FOR_LOOP, Tree.Kind.FOR_LOOP, Tree.Kind.WHILE_LOOP);

    public static ErrorDescription unnecessaryReturn(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryReturnContinue(ctx, null, "UnnecessaryReturnStatement", true);
    }

    public static ErrorDescription unnecessaryContinue(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryReturnContinue(ctx, ctx.getInfo().getTreeUtilities().getBreakContinueTarget(ctx.getPath()), "UnnecessaryContinueStatement", false);
    }

    private static ErrorDescription unnecessaryReturnContinue(HintContext ctx, StatementTree targetLoop, String key, boolean isReturn) {
        TreePath tp = ctx.getPath();
        block8: while (tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
            List<? extends StatementTree> statements;
            Tree current = tp.getLeaf();
            tp = tp.getParentPath();
            switch (tp.getLeaf().getKind()) {
                case METHOD: {
                    if (targetLoop != null) {
                        return null;
                    }
                    MethodTree mt = (MethodTree)tp.getLeaf();
                    if (mt.getReturnType() == null) {
                        if (mt.getName().contentEquals("<init>")) break block8;
                        return null;
                    }
                    TypeMirror tm = ctx.getInfo().getTrees().getTypeMirror(new TreePath(tp, mt.getReturnType()));
                    if (tm != null && tm.getKind() == TypeKind.VOID) break block8;
                    return null;
                }
                case LAMBDA_EXPRESSION: {
                    TypeMirror returnType;
                    if (targetLoop != null) {
                        return null;
                    }
                    TypeMirror functionalType = ctx.getInfo().getTrees().getTypeMirror(tp);
                    if (functionalType == null || functionalType.getKind() != TypeKind.DECLARED) {
                        return null;
                    }
                    ExecutableType descriptorType = ctx.getInfo().getTypeUtilities().getDescriptorType((DeclaredType)functionalType);
                    TypeMirror typeMirror = returnType = descriptorType != null ? descriptorType.getReturnType() : null;
                    if (returnType != null && returnType.getKind() == TypeKind.VOID) break block8;
                    return null;
                }
                case BLOCK: {
                    statements = ((BlockTree)tp.getLeaf()).getStatements();
                    break;
                }
                case CASE: {
                    if (tp.getParentPath().getLeaf().getKind() == Tree.Kind.SWITCH) {
                        List<? extends CaseTree> cases = ((SwitchTree)tp.getParentPath().getLeaf()).getCases();
                        ArrayList<? extends StatementTree> locStatements = new ArrayList<StatementTree>();
                        for (int i = cases.indexOf(tp.getLeaf()); i < cases.size(); ++i) {
                            locStatements.addAll(cases.get(i).getStatements());
                        }
                        statements = locStatements;
                        break;
                    }
                    statements = ((CaseTree)tp.getLeaf()).getStatements();
                    break;
                }
                case DO_WHILE_LOOP: 
                case ENHANCED_FOR_LOOP: 
                case FOR_LOOP: 
                case WHILE_LOOP: {
                    if (tp.getLeaf() == targetLoop) break block8;
                    return null;
                }
                case TRY: {
                    if (((TryTree)tp.getLeaf()).getFinallyBlock() == current) {
                        return null;
                    }
                }
                default: {
                    continue block8;
                }
            }
            assert (!statements.isEmpty());
            int i = statements.indexOf(current);
            if (i == -1) {
                return null;
            }
            while (i + 1 < statements.size()) {
                StatementTree next = statements.get(i + 1);
                if (next.getKind() == Tree.Kind.EMPTY_STATEMENT) {
                    ++i;
                    continue;
                }
                if (next.getKind() == Tree.Kind.BLOCK) {
                    statements = ((BlockTree)next).getStatements();
                    i = -1;
                    continue;
                }
                if (next.getKind() == Tree.Kind.BREAK) {
                    StatementTree target = ctx.getInfo().getTreeUtilities().getBreakContinueTarget(new TreePath(tp, next));
                    if (target == null) {
                        return null;
                    }
                    tp = TreePath.getPath(ctx.getInfo().getCompilationUnit(), (Tree)target);
                    continue block8;
                }
                return null;
            }
        }
        Fix toExpression = null;
        if (isReturn) {
            ExpressionToStatement scanner = new ExpressionToStatement(null, ctx.getInfo());
            scanner.scan(ctx.getPath(), null);
            if (!scanner.remove) {
                toExpression = new MakeExpressionStatement(ctx.getInfo(), ctx.getPath()).toEditorFix();
            }
        }
        String displayName = NbBundle.getMessage(RemoveUnnecessary.class, (String)("ERR_" + key));
        String fixDisplayName = NbBundle.getMessage(RemoveUnnecessary.class, (String)("FIX_" + key));
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)displayName, (Fix[])new Fix[]{JavaFixUtilities.removeFromParent((HintContext)ctx, (String)fixDisplayName, (TreePath)ctx.getPath()), toExpression});
    }

    public static ErrorDescription unnecessaryContinueLabel(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryLabel(ctx, false);
    }

    public static ErrorDescription unnecessaryBreakLabel(HintContext ctx) {
        return RemoveUnnecessary.unnecessaryLabel(ctx, true);
    }

    private static ErrorDescription unnecessaryLabel(HintContext ctx, boolean brk) {
        TreePath loop;
        for (loop = ctx.getPath(); !(loop == null || LOOP_KINDS.contains((Object)loop.getLeaf().getKind()) || brk && loop.getLeaf().getKind() == Tree.Kind.SWITCH); loop = loop.getParentPath()) {
        }
        if (loop == null) {
            return null;
        }
        if (ctx.getInfo().getTreeUtilities().getBreakContinueTarget(ctx.getPath()) != loop.getParentPath().getLeaf()) {
            return null;
        }
        Fix fix = JavaFixUtilities.rewriteFix((HintContext)ctx, (String)(brk ? Bundle.FIX_UnnecessaryBreakStatementLabel() : Bundle.FIX_UnnecessaryContinueStatementLabel()), (TreePath)ctx.getPath(), (String)(brk ? "break;" : "continue;"));
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)(brk ? Bundle.ERR_UnnecessaryBreakStatementLabel() : Bundle.ERR_UnnecessaryContinueStatementLabel()), (Fix[])new Fix[]{fix});
    }

    static class ExpressionToStatement
    extends TreePathScanner {
        private boolean remove = true;
        private List<StatementTree> statements = new ArrayList<StatementTree>();
        private final TreeMaker mk;
        private final CompilationInfo cinfo;

        public ExpressionToStatement(TreeMaker mk, CompilationInfo cinfo) {
            this.mk = mk;
            this.cinfo = cinfo;
        }

        private Object addExpressionStatement(ExpressionTree node, Object p) {
            if (this.mk != null) {
                this.statements.add(this.mk.ExpressionStatement(node));
            }
            this.remove = false;
            return null;
        }

        @Override
        public Object visitLiteral(LiteralTree node, Object p) {
            return null;
        }

        @Override
        public Object visitIdentifier(IdentifierTree node, Object p) {
            return null;
        }

        @Override
        public Object visitMemberReference(MemberReferenceTree node, Object p) {
            return null;
        }

        @Override
        public Object visitMemberSelect(MemberSelectTree node, Object p) {
            return null;
        }

        @Override
        public Object visitInstanceOf(InstanceOfTree node, Object p) {
            return null;
        }

        @Override
        public Object visitLambdaExpression(LambdaExpressionTree node, Object p) {
            return null;
        }

        @Override
        public Object visitNewArray(NewArrayTree node, Object p) {
            return null;
        }

        @Override
        public Object visitTypeCast(TypeCastTree node, Object p) {
            return this.scan(node.getExpression(), p);
        }

        public Object transformLogAndOr(BinaryTree node, Object p) {
            List<StatementTree> saveStats = this.statements;
            boolean saveRemove = this.remove;
            this.remove = true;
            this.statements = new ArrayList<StatementTree>();
            this.scan(node.getRightOperand(), p);
            if (this.remove) {
                this.statements = saveStats;
                this.scan(node.getLeftOperand(), p);
                if (this.remove) {
                    this.remove &= saveRemove;
                    return null;
                }
                this.remove &= saveRemove;
            } else {
                List<StatementTree> elseStats = this.statements;
                this.statements = saveStats;
                this.remove = false;
                if (this.mk != null) {
                    ExpressionTree condition = node.getKind() == Tree.Kind.CONDITIONAL_AND ? node.getLeftOperand() : Utilities.negate(this.mk, node.getLeftOperand(), node);
                    this.statements.add(this.mk.If(condition, elseStats.size() == 1 ? elseStats.get(0) : this.mk.Block(elseStats, false), null));
                }
            }
            return null;
        }

        @Override
        public Object visitBinary(BinaryTree node, Object p) {
            switch (node.getKind()) {
                case CONDITIONAL_AND: 
                case CONDITIONAL_OR: {
                    return this.transformLogAndOr(node, p);
                }
            }
            this.scan(node.getLeftOperand(), p);
            this.scan(node.getRightOperand(), p);
            return null;
        }

        @Override
        public Object visitUnary(UnaryTree node, Object p) {
            this.scan(node.getExpression(), p);
            return null;
        }

        @Override
        public Object visitAssignment(AssignmentTree node, Object p) {
            return this.addExpressionStatement(node, p);
        }

        @Override
        public Object visitCompoundAssignment(CompoundAssignmentTree node, Object p) {
            return this.addExpressionStatement(node, p);
        }

        @Override
        public Object visitNewClass(NewClassTree node, Object p) {
            return this.addExpressionStatement(node, p);
        }

        @Override
        public Object visitMethodInvocation(MethodInvocationTree node, Object p) {
            return this.addExpressionStatement(node, p);
        }

        @Override
        public Object visitConditionalExpression(ConditionalExpressionTree node, Object p) {
            List<StatementTree> saveStat = this.statements;
            boolean saveRemove = this.remove;
            this.statements = new ArrayList<StatementTree>();
            this.scan(node.getTrueExpression(), p);
            List<StatementTree> trueStat = this.statements;
            this.statements = new ArrayList<StatementTree>();
            this.scan(node.getFalseExpression(), p);
            List<StatementTree> falseStat = this.statements;
            this.statements = saveStat;
            boolean bl = this.remove = saveRemove && this.remove;
            if (trueStat.isEmpty()) {
                if (falseStat.isEmpty()) {
                    return null;
                }
                this.statements.add(this.mk.If((ExpressionTree)this.mk.Unary(Tree.Kind.LOGICAL_COMPLEMENT, node.getCondition()), falseStat.size() == 1 ? falseStat.get(0) : this.mk.Block(falseStat, false), null));
            } else {
                this.statements.add(this.mk.If(node.getCondition(), trueStat.size() == 1 ? trueStat.get(0) : this.mk.Block(trueStat, false), falseStat.isEmpty() ? null : (falseStat.size() == 1 ? falseStat.get(0) : this.mk.Block(falseStat, false))));
            }
            return null;
        }
    }

    private static class MakeExpressionStatement
    extends JavaFix {
        public MakeExpressionStatement(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_MakeExpressionStatement();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            TreePath retPath = ctx.getPath();
            if (retPath.getLeaf().getKind() != Tree.Kind.RETURN) {
                return;
            }
            ReturnTree rtt = (ReturnTree)retPath.getLeaf();
            if (rtt.getExpression() == null) {
                return;
            }
            WorkingCopy wc = ctx.getWorkingCopy();
            ExpressionToStatement st = new ExpressionToStatement(wc.getTreeMaker(), (CompilationInfo)wc);
            st.scan(new TreePath(retPath, rtt.getExpression()), null);
            if (st.remove || st.statements.isEmpty()) {
                return;
            }
            Utilities.replaceStatement(wc, retPath, st.statements);
        }
    }
}

