/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.providers.spi.PositionRefresherHelper;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;

public class ErrorPositionRefresherHelper
extends PositionRefresherHelper<DocumentVersionImpl> {
    public ErrorPositionRefresherHelper() {
        super(ErrorHintsProvider.class.getName());
    }

    protected boolean isUpToDate(Context context, Document doc, DocumentVersionImpl oldVersion) {
        List errors = oldVersion.errorsContent;
        for (ErrorDescription ed : errors) {
            if (ed.getRange().getBegin().getOffset() > context.getPosition() || context.getPosition() > ed.getRange().getEnd().getOffset() || ed.getFixes().isComputed()) continue;
            return false;
        }
        return true;
    }

    public List<ErrorDescription> getErrorDescriptionsAt(CompilationInfo info, Context context, Document doc) throws Exception {
        List<ErrorDescription> errors;
        DocumentVersionImpl upToDateDocumentVersion = (DocumentVersionImpl)this.getUpToDateDocumentVersion(context, doc);
        List<ErrorDescription> list = errors = upToDateDocumentVersion != null ? upToDateDocumentVersion.errorsContent : null;
        if (errors == null) {
            errors = new ErrorHintsProvider().computeErrors(info, doc, context.getPosition(), "text/x-java");
        }
        if (errors == null) {
            return null;
        }
        for (ErrorDescription ed : errors) {
            if (ed.getRange().getBegin().getOffset() > context.getPosition() || context.getPosition() > ed.getRange().getEnd().getOffset() || ed.getFixes().isComputed()) continue;
            ((CreatorBasedLazyFixList)ed.getFixes()).compute(info, context.getCancel());
        }
        return errors;
    }

    static void setVersion(Document doc, List<ErrorDescription> errors) {
        for (PositionRefresherHelper h : MimeLookup.getLookup((String)"text/x-java").lookupAll(PositionRefresherHelper.class)) {
            if (!(h instanceof ErrorPositionRefresherHelper)) continue;
            ((ErrorPositionRefresherHelper)h).setVersion(doc, new DocumentVersionImpl(doc, errors));
        }
    }

    static final class DocumentVersionImpl
    extends PositionRefresherHelper.DocumentVersion {
        private final List<ErrorDescription> errorsContent;

        public DocumentVersionImpl(Document doc, List<ErrorDescription> errorsContent) {
            super(doc);
            this.errorsContent = errorsContent;
        }
    }
}

