/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.Converter;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.OptionParser;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.cap.CapgenWrapper;
import com.sun.javacard.jcasm.cap.SIOProxyClassesGen;
import com.sun.javacard.packager.Main;
import com.sun.javacard.tools.util.JCToolsLogger;
import com.sun.javacard.util.FileUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class ConverterHarness {
    private ConversionProfile conversion_profile;
    private boolean delateJCA = false;
    private Converter _converter = null;
    private boolean capGenError = false;
    private JCToolsLogger toolsLogger;
    private String msgFileName;

    ConverterHarness(String string) {
        this.toolsLogger = JCToolsLogger.getLogger("com.sun.javacard.converter", string);
        this.msgFileName = string;
    }

    public static void main(String[] stringArray) {
        ConverterHarness converterHarness = new ConverterHarness("com.sun.javacard.converter.MessagesBundle");
        converterHarness.convert(stringArray, null);
    }

    public static void startConversion(String[] stringArray, Hashtable<String, File> hashtable) {
        ConverterHarness converterHarness = new ConverterHarness("com/sun/javacard/converter/MessagesBundle");
        converterHarness.convert(stringArray, hashtable);
    }

    private void convert(String[] stringArray, Hashtable<String, File> hashtable) {
        try {
            boolean bl;
            File file;
            Object[] objectArray;
            this.conversion_profile = new ConversionProfile();
            OptionParser optionParser = new OptionParser(stringArray, this.conversion_profile);
            optionParser.parse();
            this.toolsLogger.info(ToolsVersion.getToolName(1) + ToolsVersion.getVersion(1), new Object[0]);
            this.toolsLogger.info(ToolsVersion.getCopyrightBanner(), new Object[0]);
            this.generateJCA(hashtable);
            try {
                this.generateCAP();
            }
            catch (Exception exception) {
                this.capGenError = true;
            }
            this.cleanup();
            if (this.conversion_profile.sign) {
                objectArray = Names.getCAPFileName(this.conversion_profile.package_profile.package_name);
                file = new File(this.conversion_profile.getFullOutputPath(), (String)objectArray);
                String[] stringArray2 = new String[]{"sign", "-K", this.conversion_profile.keystore, "-A", this.conversion_profile.alias, "-P", this.conversion_profile.passkey, "-S", this.conversion_profile.storepass, file.toString()};
                bl = Main.invokePackager(stringArray2);
                if (!bl) {
                    System.exit(1);
                }
            }
            objectArray = new Object[]{String.valueOf(Notifier.getErrorCount() + Globals.errors), String.valueOf(Notifier.getWarningCount() + Globals.warnings)};
            this.toolsLogger = JCToolsLogger.getLogger("com.sun.javacard.converter", this.msgFileName);
            this.toolsLogger.info("out.1", objectArray);
            if (this.capGenError) {
                System.exit(1);
            }
            file = new File(this.conversion_profile.output_dir);
            boolean bl2 = false;
            bl = this.conversion_profile.class_root.equals(this.conversion_profile.output_dir);
            if (this.conversion_profile.keepDir != null) {
                File file2 = new File(this.conversion_profile.keepDir);
                file2.mkdirs();
                if (file.equals(file2)) {
                    bl2 = true;
                } else {
                    this.copyJavaFiles(file, file2);
                }
            }
            this.cleanupTempFiles();
        }
        catch (Throwable throwable) {
            this.toolsLogger.severe("error.1", new Object[0]);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    private void copyJavaFiles(File file, File file2) throws Exception {
        try {
            file = file.getCanonicalFile().getAbsoluteFile();
            file2 = file2.getCanonicalFile().getAbsoluteFile();
            String string = file.getAbsolutePath();
            String string2 = null;
            for (String string3 : SIOProxyClassesGen.sourceFilesToDelete) {
                File file3 = new File(string3);
                file3 = file3.getCanonicalFile().getAbsoluteFile();
                string2 = file3.getAbsolutePath();
                if ((string2 = string2.substring(string.length())).startsWith(File.separator)) {
                    string2 = string2.substring(1);
                }
                FileUtils.copyFile(file3, new File(file2, string2));
            }
        }
        catch (Exception exception) {
            throw new Exception("Unable to keep java files. Error: " + exception.getMessage());
        }
    }

    private void deleteTempFiles(Vector<String> vector) {
        for (String string : vector) {
            File file = new File(string);
            if (!file.exists()) continue;
            file.delete();
            File file2 = file.getParentFile();
            while (file2 != null && file2.listFiles().length == 0) {
                File file3 = file2.getParentFile();
                file2.delete();
                file2 = file3;
            }
        }
    }

    private void cleanupTempFiles() {
        this.deleteTempFiles(SIOProxyClassesGen.classFilesToDelete);
        File file = new File(this.conversion_profile.output_dir);
        File file2 = null;
        if (this.conversion_profile.keepDir != null) {
            file2 = new File(this.conversion_profile.keepDir);
        }
        if (!file.equals(file2)) {
            this.deleteTempFiles(SIOProxyClassesGen.sourceFilesToDelete);
        }
    }

    private void generateJCA(Hashtable<String, File> hashtable) {
        try {
            Converter converter = new Converter(this.conversion_profile, hashtable);
            converter.convert();
            this._converter = converter;
        }
        catch (ConverterException converterException) {
            Notifier.newLine();
            Object[] objectArray = new Object[]{String.valueOf(Notifier.getErrorCount()), String.valueOf(Notifier.getWarningCount())};
            this.toolsLogger.info("out.1", objectArray);
            System.exit(1);
        }
        catch (ConverterInternalError converterInternalError) {
            this.toolsLogger.severe("error.1", new Object[0]);
            converterInternalError.printStackTrace();
            System.exit(1);
        }
        catch (Exception exception) {
            this.toolsLogger.severe("error.1", new Object[0]);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void generateCAP() throws Exception {
        if ((this.conversion_profile.output & 1) != 0) {
            CapgenWrapper.generateCAPFile(this.conversion_profile, this._converter);
        }
    }

    private void cleanup() {
        Object object;
        if (this.capGenError) {
            object = new File(this.conversion_profile.getFullOutputPath(), Names.getExportFileName(this.conversion_profile.package_profile.package_name));
            ((File)object).delete();
            this.conversion_profile.deleteJCA = true;
        }
        if (this.conversion_profile.deleteJCA) {
            object = Names.getJcaFileName(this.conversion_profile.package_profile.package_name);
            File file = new File(this.conversion_profile.getFullOutputPath(), (String)object);
            file.delete();
            if (this.conversion_profile.debug) {
                String string = new String("debug.cap");
                File file2 = new File(this.conversion_profile.getFullOutputPath(), string);
                file2.delete();
            }
        }
    }

    private void keepOnly(File file, String ... stringArray) {
        Vector<File> vector = FileUtils.listAllFilesInFolder(file, null);
        String string = null;
        boolean bl = false;
        for (File file2 : vector) {
            string = file2.getName().toLowerCase();
            bl = false;
            for (String string2 : stringArray) {
                if (!string.endsWith(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            file2.delete();
        }
    }

    private void findAndRemoveProxyFolder(File file, boolean bl) {
        Vector<File> vector = FileUtils.listAllFoldersInFolder(file);
        for (File file2 : vector) {
            if (!"proxy".equals(file2.getName())) continue;
            if (bl) {
                Vector<File> vector2 = FileUtils.listAllFilesInFolder(file2, null);
                for (File file3 : vector2) {
                    if (file3.getName().endsWith(".java")) continue;
                    file3.delete();
                }
                continue;
            }
            FileUtils.deleteDir(file2);
        }
    }
}

