/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.OptionNames;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.Signer;
import com.sun.javacard.util.Diagnostics;
import java.io.File;
import java.util.Vector;
import org.apache.commons.cli.Option;

public class SignCommand
extends SubCommand {
    Signer signer = new Signer();

    public SignCommand() {
        super("sign");
    }

    @Override
    public void setup() {
        this.addOption(new CommandOption("A", "alias"));
        this.addOption(new CommandOption("K", "keystore"));
        this.addOption(new CommandOption("S", "storepass"));
        this.addOption(new CommandOption("P", "passkey"));
    }

    @Override
    public int execute() throws Exception {
        Packager packager = Packager.getPackager();
        this.toolsLogger.info("sign.info.1", new Object[0]);
        block6: for (Option option : this.optionsArray) {
            switch (OptionNames.valueOf(option.getLongOpt().toUpperCase())) {
                case KEYSTORE: {
                    this.signer.setKeystore(option.getValue());
                    continue block6;
                }
                case ALIAS: {
                    this.signer.setAlias(option.getValue());
                    continue block6;
                }
                case STOREPASS: {
                    this.signer.setStorepass(option.getValue());
                    continue block6;
                }
                case PASSKEY: {
                    this.signer.setPasskey(option.getValue());
                    continue block6;
                }
                default: {
                    String string = option.getOpt();
                    String string2 = option.getLongOpt();
                    String string3 = "";
                    if (string != null) {
                        string3 = string3 + string;
                    }
                    if (string != null && string2 != null) {
                        string3 = string3 + " (or) ";
                    }
                    if (string2 != null) {
                        string3 = string3 + string2;
                    }
                    throw new Exception("Unknown option " + string3);
                }
            }
        }
        if (this.argumentsArray == null || this.argumentsArray.length != 1) {
            this.toolsLogger.severe(ErrorKey.ModuleOrLibFileOrFolderNotSpecified.getMessage(new Object[0]), new Object[0]);
            throw new Exception(ErrorKey.ModuleOrLibFileOrFolderNotSpecified.getMessage(new Object[0]));
        }
        if (this.validateCommandLine(this.signer) != 0) {
            return 1;
        }
        packager.setOut(new File(this.argumentsArray[0]));
        this.toolsLogger.info("sign.info.2", new Object[0]);
        this.signer.setRequired(true);
        this.signer.initialize();
        if (this.signer.isOk(false)) {
            this.signer.process();
        }
        this.toolsLogger.info("sign.info.3", new Object[0]);
        Diagnostics diagnostics = new Diagnostics();
        this.signer.gatherDiagnostics(diagnostics);
        int n = this.signer.isOk(true) ? 1 : 0;
        String string = n != 0 ? ErrorKey.SUCCESS.getMessage(new Object[0]) : ErrorKey.FAILED.getMessage(new Object[0]);
        diagnostics.printDiagnostics(string, "Packager/sign", ErrorKey.Error2.getMessage(new Object[0]), ErrorKey.Warning2.getMessage(new Object[0]), ErrorKey.Error1.getMessage(new Object[0]), ErrorKey.Warning1.getMessage(new Object[0]));
        return n != 0 ? 0 : 1;
    }

    private int validateCommandLine(Signer signer) {
        Vector<String> vector = new Vector<String>();
        if (signer.getKeystore() == null) {
            vector.add(ErrorKey.MissingKeystore.getMessage(new Object[0]));
        }
        if (signer.getAlias() == null) {
            vector.add(ErrorKey.MissingAlias.getMessage(new Object[0]));
        }
        if (signer.getPasskey() == null) {
            vector.add(ErrorKey.MissingPassword.getMessage(new Object[0]));
        }
        if (signer.getStorepass() == null) {
            vector.add(ErrorKey.MissingStorepass.getMessage(new Object[0]));
        }
        if (!vector.isEmpty()) {
            for (String string : vector) {
                this.toolsLogger.severe("[ " + ErrorKey.Error1.getMessage(new Object[0]) + "] " + string.trim(), new Object[0]);
            }
            return 1;
        }
        return 0;
    }
}

