/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.cl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.cl.FormattingFlags;
import org.llvm.cl.LocationClass;
import org.llvm.cl.NumOccurrencesFlag;
import org.llvm.cl.Option;
import org.llvm.cl.OptionCategory;
import org.llvm.cl.OptionValue;
import org.llvm.cl.ValuesClass;
import org.llvm.cl.basic_parser;
import org.llvm.cl.generic_parser_base;
import org.llvm.cl.impl.CommandLineStatics;
import org.llvm.cl.initializer;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.StringSaver;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.path;

public class ClGlobals {
    public static final TokenizerCallback TokenizeGNUCommandLineCallback = new TokenizerCallback(){

        @Override
        public void $call(StringRef Source, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv, boolean MarkEOLs) {
            ClGlobals.TokenizeGNUCommandLine(Source, Saver, NewArgv);
        }
    };
    public static final TokenizerCallback TokenizeWindowsCommandLineCallback = new TokenizerCallback(){

        @Override
        public void $call(StringRef Source, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv, boolean MarkEOLs) {
            ClGlobals.TokenizeWindowsCommandLine(Source, Saver, NewArgv);
        }
    };
    public static final OptionCategory GeneralCategory = new OptionCategory("General options");

    protected ClGlobals() {
    }

    public static void ParseCommandLineOptions(int argc, char.ptr[] argv) {
        ClGlobals.ParseCommandLineOptions(argc, (type.ptr<char.ptr>)NativePointer.create_type$ptr((Object[])argv), null);
    }

    public static void ParseCommandLineOptions(int argc, type.ptr<char.ptr> argv) {
        ClGlobals.ParseCommandLineOptions(argc, argv, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ParseCommandLineOptions(int argc, type.ptr<char.ptr> argv, char.ptr Overview) {
        SmallVector<Option> PositionalOpts = null;
        SmallVector<Option> SinkOpts = null;
        StringMap<Object> Opts = null;
        SmallVector<char.ptr> newArgv = null;
        BumpPtrAllocatorImpl SaverAlloc = null;
        SmallVector<std_pair.pairTypeUInt> PositionalVals = null;
        try {
            int ValNo;
            PositionalOpts = new SmallVector<Option>(4, (Option)null);
            SinkOpts = new SmallVector<Option>(4, (Option)null);
            Opts = new StringMap<Object>(null);
            CommandLineStatics.GetOptionInfo(PositionalOpts, SinkOpts, Opts);
            assert (!Opts.empty() || !PositionalOpts.empty()) : "No options specified!";
            newArgv = new SmallVector<char.ptr>(20, (char.ptr)null);
            for (int i = 0; i != argc; ++i) {
                newArgv.push_back((char.ptr)argv.$at(i));
            }
            SaverAlloc = new BumpPtrAllocatorImpl();
            StringSaver Saver = new StringSaver(SaverAlloc);
            ClGlobals.ExpandResponseFiles(Saver, TokenizeGNUCommandLineCallback, newArgv);
            argv = (type.ptr)Native.$tryClone((NativeCloneable)((char.ptr)newArgv.$at(0)).$addr());
            argc = newArgv.size();
            std.string ProgName = path.filename(new StringRef((char.ptr)argv.$at(0))).$basic_string();
            int Len = std.min((int)ProgName.size(), (int)79);
            std.memcpy((char.ptr)CommandLineStatics.ProgramName, (char.ptr)ProgName.data(), (int)Len);
            CommandLineStatics.ProgramName.$set(Len, NativePointer.$((char)'\u0000'));
            CommandLineStatics.ProgramOverview = Native.$tryClone((char.ptr)Overview);
            boolean ErrorParsing = false;
            int NumPositionalRequired = 0;
            boolean HasUnlimitedPositionals = false;
            Option ConsumeAfterOpt = null;
            if (!PositionalOpts.empty()) {
                if (((Option)PositionalOpts.$at(0)).getNumOccurrencesFlag() == NumOccurrencesFlag.ConsumeAfter) {
                    assert (PositionalOpts.size() > 1) : "Cannot specify cl::ConsumeAfter without a positional argument!";
                    ConsumeAfterOpt = (Option)PositionalOpts.$at(0);
                }
                boolean UnboundedFound = false;
                int e = PositionalOpts.size();
                for (int i = ConsumeAfterOpt != null ? 1 : 0; i != e; ++i) {
                    Option Opt = (Option)PositionalOpts.$at(i);
                    if (CommandLineStatics.RequiresValue(Opt)) {
                        ++NumPositionalRequired;
                    } else if (ConsumeAfterOpt != null) {
                        if (PositionalOpts.size() > 2) {
                            ErrorParsing |= Opt.error(new Twine("error - this positional option will never be matched, because it does not Require a value, and a cl::ConsumeAfter option is active!"));
                        }
                    } else if (UnboundedFound && Opt.ArgStr.$at(0) == 0) {
                        ErrorParsing |= Opt.error(new Twine("error - option can never match, because another positional argument will match an unbounded number of values, and this option does not require a value!"));
                    }
                    UnboundedFound |= CommandLineStatics.EatsUnboundedNumberOfValues(Opt);
                }
                HasUnlimitedPositionals = UnboundedFound || ConsumeAfterOpt != null;
            }
            PositionalVals = new SmallVector<std_pair.pairTypeUInt>(4, new std_pair.pairTypeUInt((Object)new StringRef(), 0));
            Option ActivePositionalArg = null;
            boolean DashDashFound = false;
            for (int i = 1; i < argc; ++i) {
                std.string NearestHandlerString = null;
                try {
                    Option Handler = null;
                    Option NearestHandler = null;
                    NearestHandlerString = new std.string();
                    StringRef Value = new StringRef();
                    StringRef ArgName = new StringRef(NativePointer.$EMPTY);
                    if (CommandLineStatics.OptionListChanged) {
                        PositionalOpts.clear();
                        SinkOpts.clear();
                        Opts.clear();
                        CommandLineStatics.GetOptionInfo(PositionalOpts, SinkOpts, Opts);
                        CommandLineStatics.OptionListChanged = false;
                    }
                    if (((char.ptr)argv.$at(i)).$at(0) != NativePointer.$((char)'-') || ((char.ptr)argv.$at(i)).$at(1) == 0 || DashDashFound) {
                        if (ActivePositionalArg != null) {
                            CommandLineStatics.ProvidePositionalOption(ActivePositionalArg, new StringRef((char.ptr)argv.$at(i)), i);
                            continue;
                        }
                        if (!PositionalOpts.empty()) {
                            PositionalVals.push_back(std.make_pair_T_uint((Object)new StringRef((char.ptr)argv.$at(i)), (int)i));
                            if (PositionalVals.size() < NumPositionalRequired || ConsumeAfterOpt == null) continue;
                            ++i;
                            while (i < argc) {
                                PositionalVals.push_back(std.make_pair_T_uint((Object)new StringRef((char.ptr)argv.$at(i)), (int)i));
                                ++i;
                            }
                            break;
                        }
                    } else {
                        if (((char.ptr)argv.$at(i)).$at(0) == NativePointer.$((char)'-') && ((char.ptr)argv.$at(i)).$at(1) == NativePointer.$((char)'-') && ((char.ptr)argv.$at(i)).$at(2) == 0 && !DashDashFound) {
                            DashDashFound = true;
                            continue;
                        }
                        if (ActivePositionalArg != null && (ActivePositionalArg.getMiscFlags() & 2) != 0) {
                            ArgName.$assign(new StringRef((char.ptr)((char.ptr)argv.$at(i)).$add(1)));
                            while (!ArgName.empty() && ArgName.$at(0) == NativePointer.$((char)'-')) {
                                ArgName.$assign$substr(1);
                            }
                            Handler = CommandLineStatics.LookupOption(ArgName, Value, Opts);
                            if (Handler == null || Handler.getFormattingFlag() != FormattingFlags.Positional) {
                                CommandLineStatics.ProvidePositionalOption(ActivePositionalArg, new StringRef((char.ptr)argv.$at(i)), i);
                                continue;
                            }
                        } else {
                            ArgName.$assign(new StringRef((char.ptr)((char.ptr)argv.$at(i)).$add(1)));
                            while (!ArgName.empty() && ArgName.$at(0) == NativePointer.$((char)'-')) {
                                ArgName.$assign$substr(1);
                            }
                            Handler = CommandLineStatics.LookupOption(ArgName, Value, Opts);
                            if (Handler == null) {
                                bool.ref ErrorParsingRef = NativePointer.create_bool$ref((boolean)ErrorParsing);
                                Handler = CommandLineStatics.HandlePrefixedOrGroupedOption(ArgName, Value, ErrorParsingRef, Opts);
                                ErrorParsing = ErrorParsingRef.$deref();
                            }
                            if (Handler == null && SinkOpts.empty()) {
                                NearestHandler = CommandLineStatics.LookupNearestOption(ArgName, Opts, NearestHandlerString);
                            }
                        }
                    }
                    if (Handler == null) {
                        if (SinkOpts.empty()) {
                            llvm.errs().$out(CommandLineStatics.ProgramName).$out(": Unknown command line argument '").$out((char.ptr)argv.$at(i)).$out("'.  Try: '").$out((char.ptr)argv.$at(0)).$out(" -help'\n");
                            if (NearestHandler != null) {
                                llvm.errs().$out(CommandLineStatics.ProgramName).$out(": Did you mean '-").$out(NearestHandlerString).$out("'?\n");
                            }
                            ErrorParsing = true;
                            continue;
                        }
                        SmallVectorImpl.iterator I = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)SinkOpts.begin());
                        SmallVectorImpl.iterator E = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)SinkOpts.end());
                        while (I.$noteq(E)) {
                            ((Option)I.$star()).addOccurrence(i, StringRef.R$EMPTY, new StringRef((char.ptr)argv.$at(i)));
                            I.$preInc();
                        }
                        continue;
                    }
                    if (Handler.getFormattingFlag() == FormattingFlags.Positional) {
                        ActivePositionalArg = Handler;
                        continue;
                    }
                    int.ref iRef = NativePointer.create_int$ref((int)i);
                    ErrorParsing |= CommandLineStatics.ProvideOption(Handler, ArgName, Value, argc, (type.ptr<char.ptr>)argv, iRef);
                    i = iRef.$deref();
                    continue;
                }
                finally {
                    if (NearestHandlerString != null) {
                        NearestHandlerString.$destroy();
                    }
                }
            }
            if (NumPositionalRequired > PositionalVals.size()) {
                llvm.errs().$out(CommandLineStatics.ProgramName).$out(": Not enough positional command line arguments specified!\n").$out("Must specify at least ").$out_uint(NumPositionalRequired).$out(" positional arguments: See: ").$out((char.ptr)argv.$at(0)).$out(" -help\n");
                ErrorParsing = true;
            } else if (!HasUnlimitedPositionals && PositionalVals.size() > PositionalOpts.size()) {
                llvm.errs().$out(CommandLineStatics.ProgramName).$out(": Too many positional arguments specified!\n").$out("Can specify at most ").$out_uint(PositionalOpts.size()).$out(" positional arguments: See: ").$out((char.ptr)argv.$at(0)).$out(" -help\n");
                ErrorParsing = true;
            } else if (ConsumeAfterOpt == null) {
                ValNo = 0;
                int NumVals = PositionalVals.size();
                int e = PositionalOpts.size();
                for (int i = 0; i != e; ++i) {
                    boolean Done;
                    if (CommandLineStatics.RequiresValue((Option)PositionalOpts.$at(i))) {
                        CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(i), (StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first, ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second);
                        ++ValNo;
                        --NumPositionalRequired;
                    }
                    boolean bl = Done = ((Option)PositionalOpts.$at(i)).getNumOccurrencesFlag() == NumOccurrencesFlag.Required;
                    block26: while (NumVals - ValNo > NumPositionalRequired && !Done) {
                        switch (((Option)PositionalOpts.$at(i)).getNumOccurrencesFlag()) {
                            case Optional: {
                                Done = true;
                            }
                            case ZeroOrMore: 
                            case OneOrMore: {
                                CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(i), (StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first, ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second);
                                ++ValNo;
                                continue block26;
                            }
                        }
                        throw new llvm_unreachable("Internal error, unexpected NumOccurrences flag in positional argument processing!");
                    }
                }
            } else {
                assert (ConsumeAfterOpt != null && NumPositionalRequired <= PositionalVals.size());
                ValNo = 0;
                int e = PositionalOpts.size();
                for (int j = 1; j != e; ++j) {
                    if (!CommandLineStatics.RequiresValue((Option)PositionalOpts.$at(j))) continue;
                    ErrorParsing |= CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(j), (StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first, ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second);
                    ++ValNo;
                }
                if (PositionalOpts.size() == 2 && ValNo == 0 && !PositionalVals.empty()) {
                    ErrorParsing |= CommandLineStatics.ProvidePositionalOption((Option)PositionalOpts.$at(1), (StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first, ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second);
                    ++ValNo;
                }
                while (ValNo != PositionalVals.size()) {
                    ErrorParsing |= CommandLineStatics.ProvidePositionalOption(ConsumeAfterOpt, (StringRef)((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).first, ((std_pair.pairTypeUInt)PositionalVals.$at((int)ValNo)).second);
                    ++ValNo;
                }
            }
            StringMapIterator I = (StringMapIterator)Native.$tryClone(Opts.begin());
            StringMapIterator E = (StringMapIterator)Native.$tryClone(Opts.end());
            while (I.$noteq(E)) {
                switch (((Option)((StringMapEntry)I.$arrow()).second).getNumOccurrencesFlag()) {
                    case OneOrMore: 
                    case Required: {
                        if (((Option)((StringMapEntry)I.$arrow()).second).getNumOccurrences() != 0) break;
                        ((Option)((StringMapEntry)I.$arrow()).second).error(new Twine("must be specified at least once!"));
                        ErrorParsing = true;
                    }
                }
                I.$preInc();
            }
            Opts.clear();
            PositionalOpts.clear();
            CommandLineStatics.MoreHelp.$arrow().clear();
            if (ErrorParsing) {
                std.exit((int)1);
            }
        }
        finally {
            if (PositionalVals != null) {
                PositionalVals.$destroy();
            }
            if (SaverAlloc != null) {
                SaverAlloc.$destroy();
            }
            if (newArgv != null) {
                newArgv.$destroy();
            }
            if (Opts != null) {
                Opts.$destroy();
            }
            if (SinkOpts != null) {
                SinkOpts.$destroy();
            }
            if (PositionalOpts != null) {
                PositionalOpts.$destroy();
            }
        }
    }

    public static void ParseEnvironmentOptions(char.ptr progName, char.ptr envVar) {
        ClGlobals.ParseEnvironmentOptions(progName, envVar, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ParseEnvironmentOptions(char.ptr progName, char.ptr envVar, char.ptr Overview) {
        BumpPtrAllocatorImpl A = null;
        try {
            assert (progName != null) : "Program name not specified";
            assert (envVar != null) : "Environment variable name missing";
            char.ptr envValue = Native.$tryClone((char.ptr)std.getenv((char.ptr)envVar));
            if (envValue == null) {
                return;
            }
            SmallVector<Object> newArgv = new SmallVector<Object>(20, null);
            A = new BumpPtrAllocatorImpl();
            StringSaver Saver = new StringSaver(A);
            newArgv.push_back(Saver.save(progName));
            ClGlobals.TokenizeGNUCommandLine(new StringRef(envValue), Saver, newArgv);
            int newArgc = newArgv.size();
            ClGlobals.ParseCommandLineOptions(newArgc, (type.ptr<char.ptr>)((char.ptr)newArgv.$at(0)).$addr(), Overview);
        }
        finally {
            if (A != null) {
                A.$destroy();
            }
        }
    }

    public static void SetVersionPrinter(NativeCallback.Void2Void func) {
        CommandLineStatics.OverrideVersionPrinter = (NativeCallback.Void2Void)Native.$tryClone((Object)func);
    }

    public static void AddExtraVersionPrinter(NativeCallback.Void2Void func) {
        if (CommandLineStatics.ExtraVersionPrinters == null) {
            CommandLineStatics.ExtraVersionPrinters = new std.vector((Object)null);
        }
        CommandLineStatics.ExtraVersionPrinters.push_back((Object)func);
    }

    public static void PrintOptionValues() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void MarkOptionsChanged() {
        CommandLineStatics.OptionListChanged = true;
    }

    public static <Ty> initializer<Ty> init(Ty Val) {
        return new initializer<Ty>(Val);
    }

    public static <Ty> LocationClass<Ty> location(type.ref<Ty> L) {
        return new LocationClass<Ty>(L);
    }

    public static LocationClass<std.string> location(std.string L) {
        NativeTrace.traceNotImplemented((String)"ClGlobals.location(std.string)");
        return new LocationClass<std.string>(NativePointer.create_type$ref((Object)L));
    }

    public static <DataType> ValuesClass<DataType> values(char.ptr Arg, DataType Val, char.ptr Desc, Object ... Other) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ParserClass, DT> void printOptionDiff(Option O, generic_parser_base P, DT V, OptionValue<DT> Default, int GlobalWidth) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <ParserClassDataType, ValDT> void printOptionDiff(Option O, basic_parser<ParserClassDataType> P, ValDT V, OptionValue<ValDT> Default, int GlobalWidth) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static <Mod, Opt> void apply(Mod M, Opt O) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void PrintVersionMessage() {
        CommandLineStatics.VersionPrinterInstance.print();
    }

    public static void PrintHelpMessage() {
        ClGlobals.PrintHelpMessage(false, false);
    }

    public static void PrintHelpMessage(boolean Hidden) {
        ClGlobals.PrintHelpMessage(Hidden, false);
    }

    public static void PrintHelpMessage(boolean Hidden, boolean Categorized) {
        if (!Hidden && !Categorized) {
            CommandLineStatics.UncategorizedNormalPrinter.$assign(true);
        } else if (!Hidden && Categorized) {
            CommandLineStatics.CategorizedNormalPrinter.$assign(true);
        } else if (Hidden && !Categorized) {
            CommandLineStatics.UncategorizedHiddenPrinter.$assign(true);
        } else {
            CommandLineStatics.CategorizedHiddenPrinter.$assign(true);
        }
    }

    public static void getRegisteredOptions(StringMap<Option> Map2) {
        SmallVector<Option> PositionalOpts = null;
        SmallVector<Option> SinkOpts = null;
        try {
            PositionalOpts = new SmallVector<Option>(4, (Option)null);
            SinkOpts = new SmallVector<Option>(4, (Option)null);
            assert (Map2.size() == 0) : "StringMap must be empty";
            CommandLineStatics.GetOptionInfo(PositionalOpts, SinkOpts, Map2);
            return;
        }
        finally {
            if (SinkOpts != null) {
                SinkOpts.$destroy();
            }
            if (PositionalOpts != null) {
                PositionalOpts.$destroy();
            }
        }
    }

    public static void TokenizeGNUCommandLine(StringRef Src, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv) {
        ClGlobals.TokenizeGNUCommandLine(Src, Saver, NewArgv, false);
    }

    public static void TokenizeGNUCommandLine(StringRef Src, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv, boolean MarkEOLs) {
        SmallString Token2 = new SmallString(128);
        int E = Src.size();
        for (int I = 0; I != E; ++I) {
            if (Token2.empty()) {
                while (I != E && CommandLineStatics.isWhitespace(Src.$at(I))) {
                    if (MarkEOLs && Src.$at(I) == 10) {
                        NewArgv.push_back(null);
                    }
                    ++I;
                }
                if (I == E) break;
            }
            if (Unsigned.$less_uint((int)(I + 1), (int)E) && Src.$at(I) == 92 && CommandLineStatics.isGNUSpecial(Src.$at(I + 1))) {
                Token2.push_back(Src.$at(++I));
                continue;
            }
            if (CommandLineStatics.isQuote(Src.$at(I))) {
                byte Quote = Src.$at(I++);
                while (I != E && Src.$at(I) != Quote) {
                    if (Src.$at(I) == 92 && I + 1 != E && CommandLineStatics.isGNUSpecial(Src.$at(I + 1))) {
                        ++I;
                    }
                    Token2.push_back(Src.$at(I));
                    ++I;
                }
                if (I != E) continue;
                break;
            }
            if (CommandLineStatics.isWhitespace(Src.$at(I))) {
                if (!Token2.empty()) {
                    NewArgv.push_back(Saver.save(Token2.c_str()));
                }
                Token2.clear();
                continue;
            }
            Token2.push_back(Src.$at(I));
        }
        if (!Token2.empty()) {
            NewArgv.push_back(Saver.save(Token2.c_str()));
        }
        if (MarkEOLs) {
            NewArgv.push_back(null);
        }
    }

    public static void TokenizeWindowsCommandLine(StringRef Src, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv) {
        ClGlobals.TokenizeWindowsCommandLine(Src, Saver, NewArgv, false);
    }

    public static void TokenizeWindowsCommandLine(StringRef Src, StringSaver Saver, SmallVectorImpl<char.ptr> NewArgv, boolean MarkEOLs) {
        SmallString Token2 = new SmallString(128);
        boolean INIT = false;
        boolean UNQUOTED = true;
        int QUOTED = 2;
        int State = 0;
        int E = Src.size();
        for (int I = 0; I != E; ++I) {
            if (State == 0) {
                if (CommandLineStatics.isWhitespace(Src.$at(I))) {
                    if (!MarkEOLs || Src.$at(I) != 10) continue;
                    NewArgv.push_back(null);
                    continue;
                }
                if (Src.$at(I) == 34) {
                    State = 2;
                    continue;
                }
                if (Src.$at(I) == 92) {
                    I = CommandLineStatics.parseBackslash(new StringRef(Src), I, Token2);
                    State = 1;
                    continue;
                }
                Token2.push_back(Src.$at(I));
                State = 1;
                continue;
            }
            if (State == 1) {
                if (CommandLineStatics.isWhitespace(Src.$at(I))) {
                    NewArgv.push_back(Saver.save(Token2.c_str()));
                    Token2.clear();
                    State = 0;
                    if (!MarkEOLs || Src.$at(I) != 10) continue;
                    NewArgv.push_back(null);
                    continue;
                }
                if (Src.$at(I) == 34) {
                    State = 2;
                    continue;
                }
                if (Src.$at(I) == 92) {
                    I = CommandLineStatics.parseBackslash(new StringRef(Src), I, Token2);
                    continue;
                }
                Token2.push_back(Src.$at(I));
                continue;
            }
            if (State != 2) continue;
            if (Src.$at(I) == 34) {
                State = 1;
                continue;
            }
            if (Src.$at(I) == 92) {
                I = CommandLineStatics.parseBackslash(new StringRef(Src), I, Token2);
                continue;
            }
            Token2.push_back(Src.$at(I));
        }
        if (!Token2.empty()) {
            NewArgv.push_back(Saver.save(Token2.c_str()));
        }
        if (MarkEOLs) {
            NewArgv.push_back(null);
        }
    }

    public static boolean ExpandResponseFiles(StringSaver Saver, TokenizerCallback Tokenizer, SmallVectorImpl<char.ptr> Argv) {
        return ClGlobals.ExpandResponseFiles(Saver, Tokenizer, Argv, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ExpandResponseFiles(StringSaver Saver, TokenizerCallback Tokenizer, SmallVectorImpl<char.ptr> Argv, boolean MarkEOLs) {
        int RspFiles = 0;
        boolean AllExpanded = true;
        int I = 0;
        while (I != Argv.size()) {
            SmallVector<char.ptr> ExpandedArgv = null;
            try {
                char.ptr Arg = Native.$tryClone((char.ptr)Argv.$at(I));
                if (Arg == null) {
                    ++I;
                    continue;
                }
                if (Arg.$at(0) != NativePointer.$((char)'@')) {
                    ++I;
                    continue;
                }
                if (RspFiles++ > 20) {
                    boolean bl = false;
                    return bl;
                }
                ExpandedArgv = new SmallVector<char.ptr>(0, (char.ptr)null);
                if (!CommandLineStatics.ExpandResponseFile((char.ptr)Arg.$add(1), Saver, Tokenizer, ExpandedArgv, MarkEOLs)) {
                    AllExpanded = false;
                    ++I;
                    continue;
                }
                Argv.erase(((SmallVectorImpl.iterator)Argv.begin()).$add(I));
                Argv.insert(((SmallVectorImpl.iterator)Argv.begin()).$add(I), (type.iterator<?, char.ptr>)ExpandedArgv.begin(), (type.iterator<?, char.ptr>)ExpandedArgv.end());
            }
            finally {
                if (ExpandedArgv == null) continue;
                ExpandedArgv.$destroy();
            }
        }
        return AllExpanded;
    }

    @FunctionalInterface
    public static interface TokenizerCallback {
        public void $call(StringRef var1, StringSaver var2, SmallVectorImpl<char.ptr> var3, boolean var4);
    }

    private static final class Unnamed_enum
    extends Enum<Unnamed_enum> {
        public static final /* enum */ Unnamed_enum INIT = new Unnamed_enum(0);
        public static final /* enum */ Unnamed_enum UNQUOTED = new Unnamed_enum(1);
        public static final /* enum */ Unnamed_enum QUOTED = new Unnamed_enum(2);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{INIT, UNQUOTED, QUOTED};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

