/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.llvm.support.OnDiskChainedHashTable;
import org.llvm.support.SpecificBumpPtrAllocator;
import org.llvm.support.endian.Writer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class OnDiskChainedHashTableGenerator<external_key_type, internal_key_type, data_type>
implements Destructors.ClassWithDestructor {
    private int NumBuckets = 64;
    private int NumEntries = 0;
    private SpecificBumpPtrAllocator<Item> BA;
    private final EmitInfoInterface<internal_key_type, data_type> InfoObj;
    private Bucket<external_key_type, internal_key_type, data_type>[] Buckets = new Bucket[this.NumBuckets];

    private void insert(Bucket[] Buckets, int Size, Item E) {
        Bucket B = Buckets[E.Hash & Size - 1];
        E.Next = B.Head;
        ++B.Length;
        B.Head = E;
    }

    private void resize(int NewSize) {
        Bucket[] NewBuckets = new Bucket[NewSize];
        for (int i = 0; i < NewBuckets.length; ++i) {
            NewBuckets[i] = new Bucket();
        }
        for (int I = 0; I < this.NumBuckets; ++I) {
            Item E = this.Buckets[I].Head;
            while (E != null) {
                Item N = E.Next;
                E.Next = null;
                this.insert(NewBuckets, NewSize, E);
                E = N;
            }
        }
        std.free(this.Buckets);
        this.NumBuckets = NewSize;
        this.Buckets = NewBuckets;
    }

    public void insert(internal_key_type Key, data_type Data) {
        this.insert(Key, Data, this.InfoObj);
    }

    public void insert(internal_key_type Key, data_type Data, OnDiskChainedHashTable.InfoInterface InfoObj) {
        ++this.NumEntries;
        if (4 * this.NumEntries >= 3 * this.NumBuckets) {
            this.resize(this.NumBuckets * 2);
        }
        this.insert(this.Buckets, this.NumBuckets, new Item(Key, Data, InfoObj));
    }

    public int Emit(raw_ostream Out) {
        return this.Emit(Out, this.InfoObj);
    }

    public int Emit(raw_ostream Out, EmitInfoInterface<internal_key_type, data_type> InfoObj) {
        Writer LE = new Writer(llvm.support.endianness.little, Out);
        for (int I = 0; I < this.NumBuckets; ++I) {
            Bucket<external_key_type, internal_key_type, data_type> B = this.Buckets[I];
            if (B.Head == null) continue;
            B.Off = Unsigned.$long2uint((long)Out.tell());
            assert (B.Off != 0) : "Cannot write a bucket at offset 0. Please add padding.";
            LE.write_uint16(B.Length);
            assert (B.Length != 0) : "Bucket has a head but zero length?";
            Item II = B.Head;
            while (II != null) {
                LE.write_uint32(II.Hash);
                long Len = InfoObj.EmitKeyDataLength(Out, II.Key, II.Data);
                InfoObj.EmitKey(Out, II.Key, std_pair.$first_int((long)Len));
                InfoObj.EmitData(Out, II.Key, II.Data, std_pair.$second_int((long)Len));
                II = II.Next;
            }
        }
        int TableOff = Unsigned.$long2uint((long)Out.tell());
        long N = llvm.OffsetToAlignment(TableOff, llvm.alignOf(Integer.TYPE));
        TableOff = (int)((long)TableOff + N);
        while (N-- != 0L) {
            LE.write_uint8(0);
        }
        LE.write_uint32(this.NumBuckets);
        LE.write_uint32(this.NumEntries);
        for (int I = 0; I < this.NumBuckets; ++I) {
            LE.write_uint32(this.Buckets[I].Off);
        }
        return TableOff;
    }

    public OnDiskChainedHashTableGenerator(EmitInfoInterface<internal_key_type, data_type> InfoObj) {
        for (int i = 0; i < this.Buckets.length; ++i) {
            this.Buckets[i] = new Bucket();
        }
        this.InfoObj = InfoObj;
    }

    public void $destroy() {
        std.free(this.Buckets);
    }

    public String toString() {
        return "NumBuckets=" + this.NumBuckets + ", NumEntries=" + this.NumEntries + ", BA=" + this.BA + ", Buckets=" + this.Buckets;
    }

    public static interface EmitInfoInterface<internal_key_type, data_type>
    extends OnDiskChainedHashTable.InfoInterface<Void, internal_key_type, data_type> {
        public long EmitKeyDataLength(raw_ostream var1, internal_key_type var2, data_type var3);

        public void EmitKey(raw_ostream var1, internal_key_type var2, int var3);

        public void EmitData(raw_ostream var1, internal_key_type var2, data_type var3, int var4);
    }

    private static final class Bucket<external_key_type, internal_key_type, data_type> {
        public int Off;
        public Item<external_key_type, internal_key_type, data_type> Head;
        public int Length;

        public String toString() {
            return "Off=" + this.Off + ", Head=" + this.Head + ", Length=" + this.Length;
        }
    }

    private static final class Item<external_key_type, internal_key_type, data_type> {
        public internal_key_type Key;
        public data_type Data;
        public Item<external_key_type, internal_key_type, data_type> Next;
        public int Hash;

        public Item(internal_key_type Key, data_type Data, OnDiskChainedHashTable.InfoInterface InfoObj) {
            this.Key = Key;
            this.Data = Data;
            this.Next = null;
            this.Hash = InfoObj.ComputeHash(Key);
        }

        public String toString() {
            return "Key=" + this.Key + ", Data=" + this.Data + ", Next=" + this.Next + ", Hash=" + this.Hash;
        }
    }
}

