/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.wizard;

import com.sun.javacard.AID;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.javacard.wizard.ClassicPackageWizardPanel;
import org.netbeans.modules.javacard.wizard.PlatformInstallerWizardPanel;
import org.netbeans.modules.javacard.wizard.ProjectDefinitionWizardPanel;
import org.netbeans.modules.javacard.wizard.ProjectXmlCreator;
import org.netbeans.modules.projecttemplates.FileCreator;
import org.netbeans.modules.projecttemplates.GeneratedProject;
import org.netbeans.modules.projecttemplates.ProjectCreator;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public class ProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor>,
ChangeListener {
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private final FileObject template;
    private final ProjectKind kind;
    private PlatformInstallerWizardPanel firstPanel;
    private ProjectDefinitionWizardPanel secondPanel;
    private ClassicPackageWizardPanel thirdPanel;
    private WizardDescriptor wiz;
    boolean onSecondPanel = true;

    public static ProjectWizardIterator create(FileObject template) {
        return new ProjectWizardIterator(template);
    }

    private ProjectWizardIterator(FileObject template) {
        this.template = template;
        this.kind = ProjectKind.kindForTemplate((FileObject)template);
    }

    public Set instantiate(ProgressHandle h) throws IOException {
        String servletMapping;
        HashSet<FileObject> results = new HashSet<FileObject>();
        String name = (String)this.wiz.getProperty("projectname");
        String pkg = (String)this.wiz.getProperty("basepackagename");
        String mainClassName = (String)this.wiz.getProperty("mainclassname");
        String appletAid = (String)this.wiz.getProperty("applet_aid");
        String webContextPath = (String)this.wiz.getProperty("webcontextpath");
        String activePlatform = (String)this.wiz.getProperty("platform.active");
        String activeDevice = (String)this.wiz.getProperty("active.device");
        String usePreprocessor = (String)this.wiz.getProperty("compile.use.preprocessor");
        String nameSpaces = ProjectWizardIterator.unbicapitalize(name);
        File file = (File)this.wiz.getProperty("projdir");
        FileObject dest = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getParentFile()));
        ProjectCreator gen = new ProjectCreator(dest);
        gen.add((FileCreator)new ProjectXmlCreator(name, ProjectKind.kindForTemplate((FileObject)this.template)));
        HashMap<String, String> templateProperties = new HashMap<String, String>();
        Map propsFromWizard = this.wiz.getProperties();
        for (Map.Entry e : propsFromWizard.entrySet()) {
            if (!(e.getValue() instanceof String)) continue;
            propsFromWizard.put(e.getKey(), e.getValue());
        }
        templateProperties.put("projectnamespaces", nameSpaces);
        templateProperties.put("package", pkg);
        String pkgSlashes = pkg.replace('.', '/');
        templateProperties.put("packagepath", pkgSlashes);
        templateProperties.put("classname", mainClassName);
        templateProperties.put("classnamelowercase", mainClassName.toLowerCase());
        templateProperties.put("projectname", name);
        templateProperties.put("classpath", "");
        templateProperties.put("applet_aid", appletAid);
        if (appletAid != null) {
            String aidAsHex = Utils.getAIDStringForScript((String)appletAid);
            templateProperties.put("appletaidhex", aidAsHex.toUpperCase());
        }
        templateProperties.put("fileseparator", File.separator);
        templateProperties.put("applettype", this.kind.getManifestApplicationType());
        templateProperties.put("kind", this.kind.name());
        templateProperties.put("activedevice", activeDevice);
        templateProperties.put("activeplatform", activePlatform);
        templateProperties.put("usepreprocessor", usePreprocessor);
        if (this.kind == ProjectKind.CLASSIC_APPLET || this.kind == ProjectKind.CLASSIC_LIBRARY) {
            String specifiedPkgAid = (String)this.wiz.getProperty("package.aid");
            AID packageAid = specifiedPkgAid != null ? AID.parse((String)specifiedPkgAid) : (pkg != null ? Utils.generatePackageAid((String)pkg) : Utils.generateRandomPackageAid());
            templateProperties.put("classicpackageaid", packageAid.toString());
        }
        if (appletAid != null) {
            templateProperties.put("appletaid", (String)this.wiz.getProperty("applet_aid"));
            AID instanceAid = AID.parse((String)appletAid).increment();
            templateProperties.put("instanceaid", instanceAid.toString());
            String aidAsHexWithLength = Utils.getAIDStringWithLengthForScript((String)instanceAid.toString());
            templateProperties.put("appletaidhexwithlength", aidAsHexWithLength.toUpperCase());
        }
        if (webContextPath != null) {
            templateProperties.put("webcontextpath", webContextPath);
        }
        if ((servletMapping = (String)this.wiz.getProperty("servletmapping")) != null) {
            templateProperties.put("servletmapping", servletMapping);
        }
        GeneratedProject proj = gen.createProject(h, name, this.template, templateProperties);
        results.add(proj.projectDir);
        results.addAll(proj.filesToOpen);
        return results;
    }

    public static String unbicapitalize(String s) {
        char[] chars = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean lastWasUpperCase = true;
        for (int i = 0; i < chars.length; ++i) {
            boolean isUpperCase;
            char c = chars[i];
            boolean bl = isUpperCase = i == 0 || Character.isUpperCase(c);
            if (isUpperCase != lastWasUpperCase && isUpperCase) {
                sb.append(' ');
            }
            sb.append(c);
            lastWasUpperCase = isUpperCase;
        }
        return sb.toString();
    }

    public Set instantiate() throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.firstPanel = new PlatformInstallerWizardPanel();
        this.firstPanel.addChangeListener(this);
        this.secondPanel = new ProjectDefinitionWizardPanel(this.kind);
        this.secondPanel.addChangeListener(this);
        this.thirdPanel = new ClassicPackageWizardPanel(this.kind);
        this.thirdPanel.addChangeListener(this);
        this.secondPanel.readSettings(wiz);
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.secondPanel.storeSettings(wiz);
        this.firstPanel.removeChangeListener(this);
        this.secondPanel.removeChangeListener(this);
        this.thirdPanel.removeChangeListener(this);
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        if (!this.firstPanel.isValid()) {
            return this.firstPanel;
        }
        if (this.onSecondPanel) {
            return this.secondPanel;
        }
        return this.thirdPanel;
    }

    public String name() {
        return this.kind.getDisplayName();
    }

    public boolean hasNext() {
        return this.kind.isClassic() ? this.onSecondPanel : false;
    }

    public boolean hasPrevious() {
        return this.kind.isClassic() ? !this.onSecondPanel : false;
    }

    public void nextPanel() {
        if (this.kind.isClassic()) {
            this.onSecondPanel = !this.onSecondPanel;
        }
    }

    public void previousPanel() {
        if (this.kind.isClassic()) {
            this.onSecondPanel = !this.onSecondPanel;
        }
    }

    public void addChangeListener(ChangeListener c) {
        this.supp.addChangeListener(c);
    }

    public void removeChangeListener(ChangeListener c) {
        this.supp.removeChangeListener(c);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.supp.fireChange();
    }
}

