/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.cnd.debugger.common2.utils.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.ListTableModel;

public class ListUI {
    public JTable table;
    public String labelText;
    public char labelMnemonic;
    public JLabel label;
    public ListTableModel model;
    public String column0Text;
    public String column1Text;
    public String accessibleDescription;
    JButton b_add = new JButton();
    public String addText;
    public char addMnemonic = Catalog.getMnemonic("MNEM_AddItem");
    public ActionListener addActionListener;
    JButton b_rem = new JButton();
    public String remText;
    public char remMnemonic = Catalog.getMnemonic("MNEM_RemoveItem");
    public ActionListener remActionListener;

    public void adjustButtons(boolean all) {
        this.b_add.setEnabled(!all);
        this.label.setEnabled(!all);
        if (!all && this.table != null) {
            int[] selRows = this.table.getSelectedRows();
            if (this.model.getRowCount() <= 0) {
                selRows = null;
            }
            if (selRows != null && selRows.length > 0) {
                this.b_rem.setEnabled(true);
            } else {
                this.b_rem.setEnabled(false);
            }
        } else {
            this.b_rem.setEnabled(false);
        }
        this.table.setEnabled(!all);
    }

    public JPanel make(boolean withButtons) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.label = new JLabel();
        this.label.setText(this.labelText);
        this.label.setDisplayedMnemonic(this.labelMnemonic);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        panel.add((Component)this.label, gbc);
        JScrollPane scrollPane = new JScrollPane();
        this.model = new ListTableModel(this.column0Text, this.column1Text);
        this.table = this.makeJTable(this.model);
        if (this.accessibleDescription != null) {
            this.table.getAccessibleContext().setAccessibleDescription(this.accessibleDescription);
        }
        Catalog.setAccessibleName(this.table, "ACSN_ItemTable");
        this.model.setTable(this.table);
        scrollPane.setViewportView(this.table);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 0, 0, 0);
        panel.add((Component)scrollPane, gbc);
        this.label.setLabelFor(this.table);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.b_add.setText(this.addText);
        this.b_add.addActionListener(this.addActionListener);
        Catalog.setAccessibleDescription(this.b_add, "ACSD_AddItem");
        this.b_add.setMnemonic(this.addMnemonic);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        if (withButtons) {
            buttonPanel.add((Component)this.b_add, gbc);
        }
        this.b_rem.setText(this.remText);
        this.b_rem.addActionListener(this.remActionListener);
        Catalog.setAccessibleDescription(this.b_rem, "ACSD_RemoveItem");
        this.b_rem.setMnemonic(this.remMnemonic);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(4, 0, 0, 0);
        if (withButtons) {
            buttonPanel.add((Component)this.b_rem, gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(4, 4, 0, 0);
        panel.add((Component)buttonPanel, gbc);
        return panel;
    }

    private JTable makeJTable(TableModel model) {
        JTable table = new JTable(model);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListUI.this.adjustButtons(false);
            }
        });
        if (this.column1Text == null) {
            table.setTableHeader(null);
        }
        return table;
    }
}

