/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfoHintProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.highlight.error.CppUpToDateStatusProvider;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.highlight.semantic.debug.InterrupterImpl;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class HighlightProvider {
    private static final boolean TRACE_TASKS = false;
    private Hook hook;
    public static final boolean TRACE_ANNOTATIONS = Boolean.getBoolean("cnd.highlight.trace.annotations");
    private static final HighlightProvider instance = new HighlightProvider();
    private final Lookup.Result<CsmErrorProvider> res;
    private final RequestProcessor RP;
    private final Map<CsmErrorProvider, MyTask> tasks;
    private final AtomicInteger processingLevel = new AtomicInteger(0);

    public synchronized void setHook(Hook hook) {
        this.hook = hook;
    }

    public static HighlightProvider getInstance() {
        return instance;
    }

    private HighlightProvider() {
        this.res = Lookup.getDefault().lookupResult(CsmErrorProvider.class);
        this.RP = new RequestProcessor("HighlightProvider", 1);
        this.tasks = new ConcurrentHashMap<CsmErrorProvider, MyTask>();
    }

    void update(CsmFile file, Document doc, DataObject dao, InterrupterImpl interrupter) {
        assert (doc != null || file == null);
        if (doc instanceof BaseDocument) {
            this.addAnnotations((BaseDocument)doc, file, dao, interrupter);
        }
    }

    void clear(Document doc) {
        assert (doc != null);
        if (doc instanceof BaseDocument) {
            for (CsmErrorProvider provider : this.res.allInstances()) {
                this.removeAnnotations(doc, provider.getName());
            }
            CppUpToDateStatusProvider.get((BaseDocument)doc).setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
        }
    }

    private static Severity getSeverity(CsmErrorInfo info) {
        switch (info.getSeverity()) {
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: {
                return Severity.WARNING;
            }
            case HINT: {
                return Severity.HINT;
            }
        }
        throw new IllegalArgumentException("Unexpected severity: " + info.getSeverity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotations(final BaseDocument doc, final CsmFile file, DataObject dao, InterrupterImpl interrupter) {
        CsmErrorProvider.EditorEvent event = CsmFileInfoQuery.getDefault().isDocumentBasedFile(file) ? CsmErrorProvider.EditorEvent.DocumentBased : CsmErrorProvider.EditorEvent.FileBased;
        ArrayList<CsmErrorProvider> list = new ArrayList<CsmErrorProvider>();
        for (CsmErrorProvider provider : this.res.allInstances()) {
            if (interrupter.cancelled()) {
                return;
            }
            if (!provider.isSupportedEvent(event)) continue;
            list.add(provider);
        }
        for (CsmErrorProvider provider : list) {
            if (this.tasks.containsKey(provider)) continue;
            this.tasks.put(provider, new MyTask(provider));
        }
        if (TRACE_ANNOTATIONS) {
            System.err.printf("\nSetting annotations for %s\n", file);
        }
        if (interrupter.cancelled()) {
            return;
        }
        AtomicInteger atomicInteger = this.processingLevel;
        synchronized (atomicInteger) {
            if (this.processingLevel.getAndIncrement() == 0) {
                CppUpToDateStatusProvider.get(doc).setUpToDate(UpToDateStatus.UP_TO_DATE_PROCESSING);
            }
        }
        final ArrayList<ResponseImpl> responces = new ArrayList<ResponseImpl>();
        RequestImpl request = new RequestImpl(file, (Document)doc, event, interrupter);
        final CountDownLatch wait = new CountDownLatch(list.size());
        for (CsmErrorProvider provider : list) {
            if (interrupter.cancelled()) {
                wait.countDown();
                continue;
            }
            ResponseImpl response = new ResponseImpl(provider, interrupter, dao, doc);
            responces.add(response);
            MyTask myTask = this.tasks.get(provider);
            myTask.post(request, response, wait);
        }
        this.RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    wait.await();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace(System.err);
                }
                AtomicInteger ex = HighlightProvider.this.processingLevel;
                synchronized (ex) {
                    if (HighlightProvider.this.processingLevel.decrementAndGet() == 0) {
                        CppUpToDateStatusProvider.get(doc).setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
                    }
                }
                Hook theHook = HighlightProvider.this.hook;
                if (theHook != null) {
                    ArrayList<ErrorDescription> descriptions = new ArrayList<ErrorDescription>();
                    for (ResponseImpl responce : responces) {
                        descriptions.addAll(responce.descriptions);
                    }
                    theHook.highlightingDone(file.getAbsolutePath().toString(), descriptions);
                }
            }
        });
    }

    private static PositionBounds createPositionBounds(DataObject dao, int start, int end) {
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((DataObject)dao);
        if (ces != null) {
            PositionRef posBeg = ces.createPositionRef(start, Position.Bias.Forward);
            PositionRef posEnd = ces.createPositionRef(end, Position.Bias.Backward);
            return new PositionBounds(posBeg, posEnd);
        }
        return null;
    }

    private void removeAnnotations(Document doc, String layer) {
        HintsController.setErrors((Document)doc, (String)layer, Collections.emptyList());
    }

    private static final class MyTask {
        private final RunnableImpl runnable;
        private final RequestProcessor.Task task;
        private final RequestProcessor RP;

        private MyTask(CsmErrorProvider provider) {
            this.RP = new RequestProcessor("Error Provider " + provider.getName(), 1);
            this.runnable = new RunnableImpl(provider);
            this.task = this.RP.create((Runnable)this.runnable);
        }

        private void post(RequestImpl request, ResponseImpl response, CountDownLatch wait) {
            this.runnable.setWork(request, response, wait);
            this.task.schedule(0);
        }
    }

    private static final class RunnableImpl
    implements Runnable {
        private final CsmErrorProvider provider;
        private RequestImpl request;
        private ResponseImpl response;
        private CountDownLatch wait;

        public RunnableImpl(CsmErrorProvider provider) {
            this.provider = provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWork(RequestImpl request, ResponseImpl response, CountDownLatch wait) {
            RunnableImpl runnableImpl = this;
            synchronized (runnableImpl) {
                if (this.wait != null) {
                    this.wait.countDown();
                }
                this.request = request;
                this.response = response;
                this.wait = wait;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CountDownLatch aWait;
            ResponseImpl aResponse;
            RequestImpl aRequest;
            RunnableImpl runnableImpl = this;
            synchronized (runnableImpl) {
                aRequest = this.request;
                aResponse = this.response;
                aWait = this.wait;
                this.request = null;
                this.response = null;
                this.wait = null;
            }
            if (aWait == null) {
                return;
            }
            try {
                if (!aRequest.isCancelled()) {
                    try {
                        this.provider.getErrors((CsmErrorProvider.Request)aRequest, (CsmErrorProvider.Response)aResponse);
                    }
                    catch (AssertionError ex) {
                        ((Throwable)((Object)ex)).printStackTrace(System.err);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            }
            finally {
                aWait.countDown();
            }
        }
    }

    private static final class ResponseImpl
    implements CsmErrorProvider.Response {
        private final List<ErrorDescription> descriptions = new ArrayList<ErrorDescription>();
        private final CsmErrorProvider provider;
        private final InterrupterImpl interrupter;
        private final DataObject dao;
        private final BaseDocument doc;

        public ResponseImpl(CsmErrorProvider provider, InterrupterImpl interrupter, DataObject dao, BaseDocument doc) {
            this.provider = provider;
            this.interrupter = interrupter;
            this.dao = dao;
            this.doc = doc;
        }

        public void addError(CsmErrorInfo info) {
            if (this.interrupter.cancelled()) {
                return;
            }
            PositionBounds pb = HighlightProvider.createPositionBounds(this.dao, info.getStartOffset(), info.getEndOffset());
            ErrorDescription desc = null;
            if (pb != null) {
                try {
                    List fixes = CsmErrorInfoHintProvider.getFixes((CsmErrorInfo)info);
                    desc = info instanceof ErrorInfoImpl ? ErrorDescriptionFactory.createErrorDescription(null, (Severity)HighlightProvider.getSeverity(info), (String)((ErrorInfoImpl)info).getCustomType(), (String)info.getMessage(), null, (List)fixes, (Document)this.doc, (Position)pb.getBegin().getPosition(), (Position)pb.getEnd().getPosition()) : ErrorDescriptionFactory.createErrorDescription((Severity)HighlightProvider.getSeverity(info), (String)info.getMessage(), (List)fixes, (Document)this.doc, (Position)pb.getBegin().getPosition(), (Position)pb.getEnd().getPosition());
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                this.descriptions.add(desc);
                if (TRACE_ANNOTATIONS) {
                    System.err.printf("\tadded to a bag %s\n", desc.toString());
                }
            } else if (TRACE_ANNOTATIONS) {
                System.err.printf("\tCan't create PositionBounds for %s\n", info);
            }
        }

        public void done() {
            if (TRACE_ANNOTATIONS) {
                System.err.printf("Showing %d errors\n", this.descriptions.size());
            }
            HintsController.setErrors((Document)this.doc, (String)this.provider.getName(), this.descriptions);
        }
    }

    static final class RequestImpl
    implements CsmErrorProvider.Request {
        private final CsmFile file;
        private final Interrupter interrupter;
        private final Document document;
        private final CsmErrorProvider.EditorEvent event;

        public RequestImpl(CsmFile file, Document doc, CsmErrorProvider.EditorEvent event, Interrupter interrupter) {
            this.file = file;
            this.interrupter = interrupter;
            this.document = doc;
            this.event = event;
        }

        public CsmFile getFile() {
            return this.file;
        }

        public boolean isCancelled() {
            return this.interrupter.cancelled();
        }

        public Document getDocument() {
            return this.document;
        }

        public CsmErrorProvider.EditorEvent getEvent() {
            return this.event;
        }
    }

    public static interface Hook {
        public void highlightingDone(String var1, List<ErrorDescription> var2);
    }
}

