/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfoHintProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.highlight.hints.SafeFix;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

class NonVirtualDestructor
extends AbstractCodeAudit {
    private NonVirtualDestructor(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences myPreferences) {
        super(id, name, description, defaultSeverity, defaultEnabled, myPreferences);
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file != null) {
            if (request.isCancelled()) {
                return;
            }
            this.visit(file.getDeclarations(), request, response);
        }
    }

    private void visit(Collection<? extends CsmOffsetableDeclaration> decls, CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : decls) {
            if (request.isCancelled()) {
                return;
            }
            if (CsmKindUtilities.isClassMember((CsmObject)csmOffsetableDeclaration)) {
                this.visit((CsmMember)csmOffsetableDeclaration, request, response);
                continue;
            }
            if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
                this.visit((CsmClass)csmOffsetableDeclaration, request, response);
                continue;
            }
            if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) continue;
            this.visit(((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), request, response);
        }
    }

    private void visit(CsmMember csmMember, CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        if (CsmKindUtilities.isDestructor((CsmObject)csmMember)) {
            CsmMethod method = (CsmMethod)csmMember;
            if (!request.getFile().equals(method.getContainingFile())) {
                return;
            }
            if (!CsmVirtualInfoQuery.getDefault().isVirtual(method) && !CsmTypeHierarchyResolver.getDefault().getSubTypes(method.getContainingClass(), true).isEmpty()) {
                String message = NbBundle.getMessage(NonVirtualDestructor.class, (String)"NonVirtualDestructor.message");
                CsmErrorInfo.Severity severity = NonVirtualDestructor.toSeverity((String)this.minimalSeverity());
                if (response instanceof AnalyzerResponse) {
                    ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, method.getContainingFile().getFileObject(), (CsmErrorInfo)new NonVritualDestructorErrorInfoImpl(request.getDocument(), method, "General", this.getID(), this.getName() + "\n" + message, severity, method.getStartOffset(), method.getParameterList().getEndOffset()));
                } else {
                    response.addError((CsmErrorInfo)new NonVritualDestructorErrorInfoImpl(request.getDocument(), method, "General", this.getID(), message, severity, method.getStartOffset(), method.getParameterList().getEndOffset()));
                }
            }
        }
    }

    private void visit(CsmClass csmClass, CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        this.visit(csmClass.getMembers(), request, response);
    }

    private static final class AddVirtualKeyvord
    extends SafeFix {
        private final BaseDocument doc;
        private final Position start;

        public AddVirtualKeyvord(BaseDocument doc, int startOffset, int endOffset) throws BadLocationException {
            this.doc = doc;
            this.start = NbDocument.createPosition((Document)doc, (int)startOffset, (Position.Bias)Position.Bias.Forward);
        }

        public String getText() {
            return NbBundle.getMessage(NonVirtualDestructor.class, (String)"NonVirtualDestructor.fix");
        }

        @Override
        public ChangeInfo performFix() throws BadLocationException, Exception {
            String text = "virtual ";
            this.doc.insertString(this.start.getOffset(), text, null);
            return null;
        }
    }

    public static final class VirtualDestructorFixProvider
    extends CsmErrorInfoHintProvider {
        protected List<Fix> doGetFixes(CsmErrorInfo info, List<Fix> alreadyFound) {
            if (info instanceof NonVritualDestructorErrorInfoImpl) {
                alreadyFound.addAll(this.createFixes((NonVritualDestructorErrorInfoImpl)info));
            }
            return alreadyFound;
        }

        private List<? extends Fix> createFixes(NonVritualDestructorErrorInfoImpl info) {
            try {
                return Collections.singletonList(new AddVirtualKeyvord(info.doc, info.getStartOffset(), info.getEndOffset()));
            }
            catch (BadLocationException ex) {
                return Collections.emptyList();
            }
        }
    }

    private static final class NonVritualDestructorErrorInfoImpl
    extends ErrorInfoImpl {
        private final BaseDocument doc;

        public NonVritualDestructorErrorInfoImpl(Document doc, CsmMethod method, String providerName, String audutName, String message, CsmErrorInfo.Severity severity, int startOffset, int endOffset) {
            super(providerName, audutName, message, severity, startOffset, endOffset);
            this.doc = (BaseDocument)doc;
        }
    }

    public static final class Factory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(NonVirtualDestructor.class, (String)"NonVirtualDestructor.name");
            String description = NbBundle.getMessage(NonVirtualDestructor.class, (String)"NonVirtualDestructor.description");
            return new NonVirtualDestructor(id, id, description, "hint", true, preferences);
        }
    }
}

