/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.taginfo;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.modules.web.common.taginfo.AttrValueType;
import org.netbeans.modules.web.common.taginfo.TagAttrMetadata;
import org.netbeans.modules.web.common.taginfo.TagMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LibraryMetadata {
    private String id;
    private Map<String, TagMetadata> tagMap = new TreeMap<String, TagMetadata>();

    public LibraryMetadata(String id, Collection<TagMetadata> tags) {
        this.id = id;
        for (TagMetadata tag : tags) {
            this.tagMap.put(tag.getName(), tag);
        }
    }

    public TagMetadata getTag(String tagName) {
        return this.tagMap.get(tagName);
    }

    public String getId() {
        return this.id;
    }

    public static LibraryMetadata readFromXML(InputStream inputStream) throws Exception {
        ArrayList<TagAttrMetadata> commonAttrs = new ArrayList<TagAttrMetadata>();
        ArrayList<TagMetadata> tags = new ArrayList<TagMetadata>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList commonAttrLst = doc.getElementsByTagName("common_attributes");
        for (int i = 0; i < commonAttrLst.getLength(); ++i) {
            Node tagNode = commonAttrLst.item(i);
            if (tagNode.getNodeType() != 1) continue;
            Element elem = (Element)tagNode;
            LibraryMetadata.readFromXML_parseTagAttributes(elem, commonAttrs);
        }
        NodeList tagLst = doc.getElementsByTagName("tag");
        String tagLibId = doc.getDocumentElement().getAttribute("id");
        for (int i = 0; i < tagLst.getLength(); ++i) {
            Node tagNode = tagLst.item(i);
            if (tagNode.getNodeType() != 1) continue;
            Element elem = (Element)tagNode;
            String tagName = elem.getAttribute("name");
            ArrayList<TagAttrMetadata> attrs = new ArrayList<TagAttrMetadata>(commonAttrs);
            LibraryMetadata.readFromXML_parseTagAttributes(elem, attrs);
            tags.add(new TagMetadata(tagName, attrs));
        }
        return new LibraryMetadata(tagLibId, tags);
    }

    private static void readFromXML_parseTagAttributes(Element tagNode, Collection<TagAttrMetadata> result) {
        NodeList attrLst = tagNode.getElementsByTagName("attr");
        for (int i = 0; i < attrLst.getLength(); ++i) {
            Node attrNode = attrLst.item(i);
            if (attrNode.getNodeType() != 1) continue;
            Element elem = (Element)attrNode;
            String attrName = elem.getAttribute("name");
            String mimeType = LibraryMetadata.parseMimeType(elem);
            Collection<AttrValueType> valueTypes = LibraryMetadata.readFromXML_parseValueTypes(elem);
            result.add(new TagAttrMetadata(attrName, valueTypes, mimeType));
        }
    }

    private static String parseMimeType(Element attrNode) {
        NodeList mimeTypeLst = attrNode.getElementsByTagName("mimetype");
        if (mimeTypeLst.getLength() > 0) {
            Node firstNode = mimeTypeLst.item(0);
            return firstNode.getTextContent();
        }
        return null;
    }

    private static Collection<AttrValueType> readFromXML_parseValueTypes(Element attrNode) {
        ArrayList<AttrValueType> result = new ArrayList<AttrValueType>();
        NodeList typeLst = attrNode.getElementsByTagName("type");
        for (int i = 0; i < typeLst.getLength(); ++i) {
            Node typeNode = typeLst.item(i);
            if (typeNode.getNodeType() != 1) continue;
            Element elem = (Element)typeNode;
            String typeName = elem.getAttribute("name");
            AttrValueType valueType = null;
            if ("boolean".equals(typeName)) {
                valueType = AttrValueType.BOOL;
            } else {
                String[] legalVals = LibraryMetadata.readFromXML_parseAttrValues(elem);
                valueType = new AttrValueType(typeName, legalVals);
            }
            result.add(valueType);
        }
        return result;
    }

    private static String[] readFromXML_parseAttrValues(Element typeNode) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList typeLst = typeNode.getElementsByTagName("val");
        for (int i = 0; i < typeLst.getLength(); ++i) {
            Element elem;
            String val;
            Node valNode = typeLst.item(i);
            if (valNode.getNodeType() != 1 || (val = (elem = (Element)valNode).getTextContent()) == null) continue;
            result.add(val);
        }
        return result.toArray(new String[result.size()]);
    }
}

