/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.runconfigs.validation;

import java.io.File;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.runconfigs.validation.Bundle;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class BaseRunConfigValidator {
    private BaseRunConfigValidator() {
    }

    public static String validateIndexFile(File rootDirectory, String indexFile) {
        return BaseRunConfigValidator.validateIndexFile(rootDirectory, indexFile, true);
    }

    public static String validateIndexFile(File rootDirectory, String indexFile, boolean normalizeFile) {
        return BaseRunConfigValidator.validateRelativeFile(rootDirectory, indexFile, Bundle.BaseRunConfigValidator_error_index_label(), normalizeFile);
    }

    static String validateRelativeFile(File rootDirectory, String relativeFile, String errSource) {
        return BaseRunConfigValidator.validateRelativeFile(rootDirectory, relativeFile, errSource, true);
    }

    static String validateRelativeFile(File rootDirectory, String relativeFile, String errSource, boolean normalizeFile) {
        assert (rootDirectory != null);
        if (!StringUtils.hasText((String)relativeFile)) {
            return Bundle.BaseRunConfigValidator_error_relativeFile_missing(errSource);
        }
        boolean error = false;
        if (relativeFile.startsWith("/") || relativeFile.startsWith("\\")) {
            error = true;
        } else if (Utilities.isWindows() && relativeFile.contains(File.separator)) {
            error = true;
        } else {
            File index = PhpProjectUtils.resolveFile(rootDirectory, relativeFile);
            if (!index.isFile()) {
                error = true;
            } else if (normalizeFile && !index.equals(FileUtil.normalizeFile((File)index))) {
                error = true;
            }
        }
        if (error) {
            return Bundle.BaseRunConfigValidator_error_relativeFile_invalid(errSource);
        }
        return null;
    }
}

