/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.dialogs;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.ui.utils.ConfSelectorPanel;
import org.netbeans.modules.cnd.makeproject.uiapi.ConfirmSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class BatchConfigurationSelectorImpl
implements ConfirmSupport.BatchConfigurationSelector,
ActionListener {
    private JButton buildButton = new JButton(BatchConfigurationSelectorImpl.getString("BuildButton"));
    private JButton rebuildButton = new JButton(BatchConfigurationSelectorImpl.getString("CleanBuildButton"));
    private JButton cleanButton = new JButton(BatchConfigurationSelectorImpl.getString("CleanButton"));
    private JButton closeButton = new JButton(BatchConfigurationSelectorImpl.getString("CloseButton"));
    private ConfSelectorPanel confSelectorPanel;
    private String command = null;
    private Dialog dialog = null;
    private final String recentSelectionKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BatchConfigurationSelectorImpl(MakeProject project, Configuration[] confs) {
        this.confSelectorPanel = new ConfSelectorPanel(BatchConfigurationSelectorImpl.getString("CheckLabel"), BatchConfigurationSelectorImpl.getString("CheckLabelMn").charAt(0), confs, new JButton[]{this.buildButton, this.rebuildButton, this.cleanButton});
        this.recentSelectionKey = project.getProjectDirectory().getPath();
        this.confSelectorPanel.restoreSelection(this.recentSelectionKey);
        String dialogTitle = MessageFormat.format(BatchConfigurationSelectorImpl.getString("BatchBuildTitle"), ProjectUtils.getInformation((Project)project).getDisplayName());
        this.buildButton.setMnemonic(BatchConfigurationSelectorImpl.getString("BuildButtonMn").charAt(0));
        this.buildButton.getAccessibleContext().setAccessibleDescription(BatchConfigurationSelectorImpl.getString("BuildButtonAD"));
        this.buildButton.addActionListener(this);
        this.rebuildButton.setMnemonic(BatchConfigurationSelectorImpl.getString("CleanBuildButtonMn").charAt(0));
        this.rebuildButton.addActionListener(this);
        this.rebuildButton.getAccessibleContext().setAccessibleDescription(BatchConfigurationSelectorImpl.getString("CleanBuildButtonAD"));
        this.cleanButton.setMnemonic(BatchConfigurationSelectorImpl.getString("CleanButtonMn").charAt(0));
        this.cleanButton.addActionListener(this);
        this.cleanButton.getAccessibleContext().setAccessibleDescription(BatchConfigurationSelectorImpl.getString("CleanButtonAD"));
        this.closeButton.getAccessibleContext().setAccessibleDescription(BatchConfigurationSelectorImpl.getString("CloseButtonAD"));
        DialogDescriptor dd = new DialogDescriptor((Object)this.confSelectorPanel, dialogTitle, true, new Object[]{this.closeButton}, (Object)this.closeButton, 0, null, null);
        this.dialog = DialogDisplayer.getDefault().createDialog(dd);
        this.dialog.getAccessibleContext().setAccessibleDescription(BatchConfigurationSelectorImpl.getString("BatchBuildDialogAD"));
        try {
            this.dialog.setVisible(true);
        }
        catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
            dd.setValue((Object)this.closeButton);
        }
        finally {
            this.dialog.setVisible(false);
        }
    }

    public Configuration[] getSelectedConfs() {
        return this.confSelectorPanel.getSelectedConfs();
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.buildButton) {
            this.command = "build";
        } else if (evt.getSource() == this.rebuildButton) {
            this.command = "rebuild";
        } else if (evt.getSource() == this.cleanButton) {
            this.command = "clean";
        } else assert (false);
        this.dialog.dispose();
        this.confSelectorPanel.storeSelection(this.recentSelectionKey);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(BatchConfigurationSelectorImpl.class, (String)s);
    }

    public static final class BatchConfigurationSelectorFactoryImpl
    implements ConfirmSupport.BatchConfigurationSelectorFactory {
        public ConfirmSupport.BatchConfigurationSelector create(MakeProject project, Configuration[] confs) {
            BatchConfigurationSelectorImpl batchConfigurationSelector = new BatchConfigurationSelectorImpl(project, confs);
            String batchCommand = batchConfigurationSelector.getCommand();
            Configuration[] confsArray = batchConfigurationSelector.getSelectedConfs();
            if (batchCommand == null || confsArray == null || confsArray.length == 0) {
                return null;
            }
            return batchConfigurationSelector;
        }
    }
}

