/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.client.config;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassData;
import org.netbeans.modules.mobility.end2end.classdata.MethodData;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.PortData;
import org.netbeans.modules.mobility.end2end.classdata.TypeData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ConfigurationWriter {
    private static final String TYPE = "type";
    private static final String NAME = "name";

    private ConfigurationWriter() {
    }

    public static synchronized void write(OutputStream os, Configuration configuration) throws Exception {
        Document doc = XMLUtil.createDocument((String)"wsclientconfig", null, null, null);
        Element root = doc.getDocumentElement();
        root.setAttribute("version", "1.0");
        String serviceType = configuration.getServiceType();
        root.setAttribute("serviceType", serviceType);
        root.appendChild(ConfigurationWriter.serializeClient(doc, configuration.getClientConfiguration()));
        if (!"jsr-172".equals(configuration.getServiceType())) {
            root.appendChild(ConfigurationWriter.serializeServer(doc, configuration.getServerConfigutation()));
        }
        root.appendChild(ConfigurationWriter.serializeServices(doc, configuration.getServices(), serviceType));
        try {
            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
        }
        catch (IOException ioEx) {
            ErrorManager.getDefault().notify((Throwable)ioEx);
        }
    }

    private static Node serializeClient(Document doc, ClientConfiguration clientConfiguration) {
        Element cc = doc.createElement("client");
        Element project = doc.createElement("project");
        Text name = doc.createTextNode(clientConfiguration.getProjectName());
        project.appendChild(name);
        cc.appendChild(project);
        Element clazz = doc.createElement("class");
        ClassDescriptor cd = clientConfiguration.getClassDescriptor();
        clazz.setAttribute(TYPE, cd.getType());
        clazz.setAttribute("location", cd.getLocation());
        cc.appendChild(clazz);
        Properties properties = clientConfiguration.getProperties();
        Set<Object> keys = properties.keySet();
        for (String string : keys) {
            String value = properties.getProperty(string);
            Element property = doc.createElement("property");
            property.setAttribute(NAME, string);
            property.setAttribute("value", value);
            cc.appendChild(property);
        }
        return cc;
    }

    private static Node serializeServer(Document doc, ServerConfiguration serverConfiguration) {
        Element cc = doc.createElement("server");
        Element project = doc.createElement("project");
        project.setAttribute("path", serverConfiguration.getProjectPath());
        Text name = doc.createTextNode(serverConfiguration.getProjectName());
        project.appendChild(name);
        cc.appendChild(project);
        Element clazz = doc.createElement("class");
        ClassDescriptor cd = serverConfiguration.getClassDescriptor();
        clazz.setAttribute(TYPE, cd.getType());
        clazz.setAttribute("location", cd.getLocation());
        clazz.setAttribute("mapping", cd.getMapping());
        cc.appendChild(clazz);
        Properties properties = serverConfiguration.getProperties();
        Set<Object> keys = properties.keySet();
        for (String string : keys) {
            String value = properties.getProperty(string);
            Element property = doc.createElement("property");
            property.setAttribute(NAME, string);
            property.setAttribute("value", value);
            cc.appendChild(property);
        }
        return cc;
    }

    private static Node serializeServices(Document doc, List<AbstractService> services, String serviceType) {
        Element ss = doc.createElement("services");
        for (int i = 0; i < services.size(); ++i) {
            AbstractService service;
            Element s = doc.createElement("service");
            if ("class".equals(serviceType)) {
                service = services.get(i);
                List<ClassData> classes = service.getData();
                for (ClassData classData : classes) {
                    Element clazz = doc.createElement("class");
                    clazz.setAttribute(TYPE, classData.getType());
                    List<OperationData> methods = classData.getOperations();
                    for (MethodData methodData : methods) {
                        Element m = doc.createElement("method");
                        m.setAttribute(NAME, methodData.getName());
                        Element returnType = doc.createElement("return");
                        returnType.setAttribute(TYPE, methodData.getReturnType());
                        m.appendChild(returnType);
                        List<TypeData> returnTypes = methodData.getParameterTypes();
                        for (TypeData td : returnTypes) {
                            Element param = doc.createElement("param");
                            param.setAttribute(NAME, td.getName());
                            param.setAttribute(TYPE, td.getType());
                            m.appendChild(param);
                        }
                        clazz.appendChild(m);
                    }
                    s.appendChild(clazz);
                }
                ss.appendChild(s);
                continue;
            }
            if ("wsdlClass".equals(serviceType)) {
                service = (WSDLService)services.get(i);
                s.setAttribute("url", ((WSDLService)service).getUrl());
                s.setAttribute("file", ((WSDLService)service).getFile());
                s.setAttribute(NAME, ((WSDLService)service).getName());
                s.setAttribute(TYPE, ((WSDLService)service).getType());
                List<ClassData> ports = service.getData();
                for (ClassData clData : ports) {
                    PortData portData = (PortData)clData;
                    Element port = doc.createElement("port");
                    port.setAttribute(TYPE, portData.getType());
                    port.setAttribute(NAME, portData.getName());
                    List<OperationData> operations = portData.getOperations();
                    for (OperationData operation : operations) {
                        Element m = doc.createElement("operation");
                        m.setAttribute("method", operation.getMethodName());
                        m.setAttribute(NAME, operation.getName());
                        Element returnType = doc.createElement("return");
                        returnType.setAttribute(TYPE, operation.getReturnType());
                        m.appendChild(returnType);
                        List<TypeData> returnTypes = operation.getParameterTypes();
                        for (TypeData td : returnTypes) {
                            Element param = doc.createElement("param");
                            param.setAttribute(NAME, td.getName());
                            param.setAttribute(TYPE, td.getType());
                            m.appendChild(param);
                        }
                        port.appendChild(m);
                    }
                    s.appendChild(port);
                }
                ss.appendChild(s);
                continue;
            }
            if (!"jsr-172".equals(serviceType)) continue;
            service = (WSDLService)services.get(i);
            s.setAttribute("url", ((WSDLService)service).getUrl());
            s.setAttribute("file", ((WSDLService)service).getFile());
            ss.appendChild(s);
        }
        return ss;
    }
}

