/*
 * Decompiled with CFR 0.152.
 */
package org.clank.java.stdimpl.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.JavaIteratorInt;
import org.clank.support.aliases.int$iterator;
import org.clank.support.aliases.int$ptr;
import org.clank.support.aliases.int$ref;

public abstract class StdVectorInt
implements Native.assignable<std.vectorInt>,
NativeCloneable<std.vectorInt>,
Native.NativeComparable<std.vectorInt>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Integer>,
Destructors.ClassWithDestructor {
    protected final int defaultValue;
    protected int[] array;
    private static final int[] EMPTY = NativePointer.new$int(0);
    protected int end;

    protected StdVectorInt(int defaultValue) {
        this.array = EMPTY;
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected StdVectorInt(int initialSize, int defaultValue) {
        this(defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected StdVectorInt(int[] array2, int length, int defaultValue) {
        this.array = array2;
        this.end = length;
        this.defaultValue = defaultValue;
    }

    protected StdVectorInt(int$iterator<?> iter, int length, int defaultValue) {
        this(iter, (int$iterator)iter.$add(length), defaultValue);
    }

    protected StdVectorInt(int$iterator<?> begin, int$iterator<?> end, int defaultValue) {
        this(defaultValue);
        this.append(begin, end);
    }

    protected StdVectorInt(std.vectorInt other) {
        this(other.defaultValue);
        this.append(other.begin(), other.end());
    }

    protected StdVectorInt(JavaDifferentiators.JD.Move _dparam, std.vectorInt other) {
        this(0);
        this.$assignMove(other);
    }

    @Override
    public std.vectorInt $assign(std.vectorInt other) {
        this.array = other.array;
        this.end = other.end;
        return (std.vectorInt)this;
    }

    public std.vectorInt $assignMove(std.vectorInt other) {
        int[] tmpArray = this.array;
        int tmpEnd = this.end;
        this.array = other.array;
        this.end = other.end;
        other.array = tmpArray;
        other.end = tmpEnd;
        return (std.vectorInt)this;
    }

    public void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public void resize(int newSize) {
        this.resize(newSize, this.defaultValue);
    }

    public void resize(int newSize, int defaultValue) {
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone(defaultValue);
            }
        }
        this.setEnd(newSize);
    }

    public void reserve(int N) {
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public void assign(int NumElts, int Elt) {
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public void assign(int$iterator<?> __first, int$iterator<?> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public void swap(StdVectorInt RHS) {
        int[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(int elem) {
        return this.find(elem, 0);
    }

    public final int find(int elem, int from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq(this.array[i], elem, isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(int elem) {
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(int elem) {
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy(this.array, index + 1, this.end - index, this.array, index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy(I.$add(1), this.end(), I);
        this.pop_back();
        return N;
    }

    public iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = std.copy(E, this.end(), S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public iterator insert(iterator I, int Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward(I, this.end().$sub(1), this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public iterator insert(iterator I, int NumToInsert, int Elt) {
        assert (NumToInsert >= 0);
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);
            std.fill_n(I, NumToInsert, Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten));
        std.fill_n(I, NumOverwritten, Elt);
        std.fill_n(OldEnd, NumToInsert - NumOverwritten, Elt);
        return I;
    }

    public iterator insert(iterator I, int$iterator<?> From, int$iterator<?> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward(I, OldEnd.$sub(NumToInsert), OldEnd);
            std.copy(From, To, I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy(I, OldEnd, this.end().$sub(NumOverwritten));
        From = Native.$tryClone(From);
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, OldEnd);
        return I;
    }

    public void append(int$iterator<?> in_start, int$iterator<?> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        int$iterator iter = (int$iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public void append(int NumInputs, int Elt) {
        assert (NumInputs >= 0);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    @Override
    public boolean $eq(std.vectorInt RHS) {
        if (this.size() != RHS.size()) {
            return false;
        }
        return std.equal(this.begin(), this.end(), RHS.begin());
    }

    @Override
    public boolean $noteq(std.vectorInt RHS) {
        return !this.$eq(RHS);
    }

    @Override
    public boolean $less(Object obj) {
        return std.lexicographical_compare(this.begin(), this.end(), ((StdVectorInt)obj).begin(), ((StdVectorInt)obj).end());
    }

    @Override
    public boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((std.vectorInt)obj);
    }

    public int$ref ref$at(int idx) {
        return NativePointer.create_int$ref(this.array, idx);
    }

    public int $at(int idx) {
        return this.array[idx];
    }

    public int $set(int idx, int value) {
        this.array[idx] = value;
        return value;
    }

    public boolean empty() {
        return this.size() == 0;
    }

    @Override
    public void $destroy() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public void push_back(int val) {
        if (this.size() >= this.capacity()) {
            this.grow(2 * this.capacity() + 1);
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public void emplace_back() {
        this.push_back(this.defaultValue);
    }

    public void emplace_back(int value) {
        this.push_back(value);
    }

    public void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public int pop_back_val() {
        int val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public std.reverse_iteratorInt rbegin() {
        return new std.reverse_iteratorInt(NativePointer.create_int$ptr(this.array, this.end));
    }

    public std.reverse_iteratorInt rend() {
        return new std.reverse_iteratorInt(NativePointer.create_int$ptr(this.array));
    }

    public int$ptr data() {
        return NativePointer.create_int$ptr(this.array);
    }

    public int front() {
        return this.array[0];
    }

    public int back() {
        return this.array[this.end - 1];
    }

    public int$ref ref$front() {
        return new int$ref(){
            private final int stored;
            private final int index = 0;
            {
                this.stored = StdVectorInt.this.array[0];
                this.index = 0;
            }

            @Override
            public int $deref() {
                return this.stored;
            }

            @Override
            public int $set(int value) {
                StdVectorInt.this.array[0] = value;
                return value;
            }

            @Override
            public int$ptr deref$ptr() {
                return (int$ptr)StdVectorInt.this.data().$add(0);
            }
        };
    }

    public int$ref ref$back() {
        return new int$ref(){
            private final int stored;
            private final int index;
            {
                this.stored = StdVectorInt.this.array[StdVectorInt.this.end - 1];
                this.index = StdVectorInt.this.end - 1;
            }

            @Override
            public int $deref() {
                return this.stored;
            }

            @Override
            public int $set(int value) {
                StdVectorInt.this.array[this.index] = value;
                return value;
            }

            @Override
            public int$ptr deref$ptr() {
                return (int$ptr)StdVectorInt.this.data().$add(this.index);
            }
        };
    }

    public int size() {
        return this.end;
    }

    public int max_size() {
        return Integer.MAX_VALUE;
    }

    public int capacity() {
        return this.array.length;
    }

    @Override
    public int $sizeof() {
        int oneElemSize = NativeType.sizeof(this.defaultValue);
        for (int elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof(elem);
            break;
        }
        return this.capacity() * oneElemSize;
    }

    public int$ptr ptr$at(int idx) {
        return NativePointer.create_int$ptr(this.array, idx);
    }

    @Override
    public std.vectorInt clone() {
        return new std.vectorInt((std.vectorInt)this);
    }

    public void set_size(int N) {
        assert (N >= 0);
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int newSize) {
        this.array = NativePointer.copyOf$int(this.array, newSize);
    }

    private void grow() {
        this.grow(this.capacity() > 0 ? this.capacity() * 2 : 1);
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    @Override
    public Iterator<Integer> iterator() {
        return new JavaIteratorInt(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\n").append(this.getClass().getSimpleName()).append("{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            int element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}").append(this.getClass().getSimpleName()).append("}\n");
        return out.toString();
    }

    public static final class iterator
    implements int$iterator<iterator>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final StdVectorInt delegate;
        private int index;

        public iterator(StdVectorInt delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator(iterator other) {
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        public iterator(JavaDifferentiators.JD.Move _dparam, iterator other) {
            this.delegate = other.delegate;
            this.index = other.index;
            this._const = other._const;
        }

        @Override
        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        @Override
        public int $arrow() {
            return this.$at(0);
        }

        @Override
        public int $star() {
            return this.$at(0);
        }

        @Override
        public int$ref star$ref() {
            return this.ref$at(0);
        }

        @Override
        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        @Override
        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        @Override
        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        @Override
        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        @Override
        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        @Override
        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        @Override
        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        @Override
        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        @Override
        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        @Override
        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        @Override
        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        @Override
        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        @Override
        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        @Override
        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        @Override
        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public int $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public int$ref ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public int$ptr toPointer() {
            return NativePointer.create_int$ptr(this.delegate.array, this.index);
        }

        public int $index() {
            return this.index;
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

