/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support;

import java.io.PrintWriter;
import org.clank.java.std;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.Casts;
import org.clank.support.CollectionUtils;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.AliasesAccessor;
import org.clank.support.aliases.char$iterator;
import org.clank.support.aliases.char$ptr;
import org.clank.support.aliases.char$ptr$array;
import org.clank.support.aliases.int$ptr;
import org.clank.support.aliases.type$ptr;
import org.clank.support.aliases.uchar$ptr;
import org.clank.support.aliases.uint$ptr;
import org.clank.support.void$ptr;

public final class Native {
    private static final int NUM_PARALLEL_THREADS = Runtime.getRuntime().availableProcessors();

    public static JavaCleaner $createJavaCleaner() {
        return JavaCleaner.create();
    }

    public static void destroy(boolean val) {
    }

    public static void destroy(byte val) {
    }

    public static void destroy(char val) {
    }

    public static void destroy(short val) {
    }

    public static void destroy(int val) {
    }

    public static void destroy(long val) {
    }

    public static void destroy(Destructors.ClassWithDestructor obj) {
        obj.$destroy();
    }

    public static void destroy(Object obj) {
        if (obj instanceof Destructors.ClassWithDestructor) {
            Native.destroy((Destructors.ClassWithDestructor)obj);
        }
    }

    public static boolean $eq_ptr(Object primary, Object second) {
        if (primary instanceof void$ptr) {
            return Native.$eq_ptr((void$ptr)primary, (void$ptr)second);
        }
        if (primary instanceof abstract_iterator) {
            return Native.$eq_iter((abstract_iterator)primary, (abstract_iterator)second);
        }
        return primary == second;
    }

    public static <T extends void$ptr> boolean $eq_ptr(T primary, T second) {
        if (primary == second) {
            return true;
        }
        if (primary == null) {
            return false;
        }
        return primary.$eq((Object)second);
    }

    public static boolean $eq_iter(abstract_iterator primary, abstract_iterator second) {
        return std.$eq___normal_iterator(primary, second);
    }

    public static boolean $eq(abstract_iterator primary, abstract_iterator second) {
        throw new AssertionError((Object)"must use $eq_iter for iterators");
    }

    public static boolean $eq(void$ptr primary, void$ptr second) {
        throw new AssertionError((Object)"must use $eq_ptr for pointers");
    }

    public static boolean $eq(Object primary, Object second) {
        assert (!(primary instanceof void$ptr) || !(second instanceof void$ptr)) : "must use $eq_ptr for pointers";
        assert (!(primary instanceof abstract_iterator) || !(second instanceof abstract_iterator)) : "must use $eq_iter for iterators";
        return Native.$eq(primary, second, false);
    }

    public static boolean $eq(Object primary, Object second, boolean isDataPointerLike) {
        Boolean res;
        if (isDataPointerLike) {
            assert (!(primary instanceof void$ptr) || !(second instanceof void$ptr)) : "Real pointers should not be considered as 'pointer like'! use $eq_ptr instead";
            assert (!(primary instanceof abstract_iterator) || !(second instanceof abstract_iterator)) : "Real iterators should not be considered as 'pointer like'! use $noteq_iter instead";
            return primary == second;
        }
        if (primary == second) {
            return true;
        }
        if (primary instanceof OpCapable && (res = ((OpCapable)primary).$op(OpCapable.Op.EQ, second)) != null) {
            return res;
        }
        if (second instanceof OpCapable && (res = ((OpCapable)second).$op(OpCapable.Op.EQ, primary)) != null) {
            return res;
        }
        if (primary instanceof NativeComparable) {
            return ((NativeComparable)primary).$eq(second);
        }
        if (second instanceof NativeComparable) {
            return ((NativeComparable)second).$eq(primary);
        }
        if (primary == null || second == null) {
            return false;
        }
        return primary.equals(second);
    }

    public static boolean $eq(byte primary, byte second) {
        return primary == second;
    }

    public static boolean $eq(byte primary, byte second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(char primary, char second) {
        return primary == second;
    }

    public static boolean $eq(char primary, byte second) {
        return primary == (0xFF & second);
    }

    public static boolean $eq(char primary, char second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(short primary, short second) {
        return primary == second;
    }

    public static boolean $eq(short primary, short second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(int primary, int second) {
        return primary == second;
    }

    public static boolean $eq(int primary, int second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(long primary, long second) {
        return primary == second;
    }

    public static boolean $eq(long primary, long second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $eq(boolean primary, boolean second) {
        return primary == second;
    }

    public static boolean $eq(boolean primary, boolean second, boolean isDataPointerLike) {
        return primary == second;
    }

    public static boolean $less(Object primary, Object second) {
        Boolean res;
        if (primary == second) {
            return false;
        }
        if (primary instanceof OpCapable && (res = ((OpCapable)primary).$op(OpCapable.Op.LESS, second)) != null) {
            return res;
        }
        if (second instanceof OpCapable && (res = ((OpCapable)second).$op(OpCapable.Op.GREATER, primary)) != null) {
            return res;
        }
        if (primary instanceof Comparable && primary.getClass().isInstance(second)) {
            return ((Comparable)primary).compareTo(second) < 0;
        }
        if (second instanceof Comparable && second.getClass().isInstance(primary)) {
            return ((Comparable)second).compareTo(primary) > 0;
        }
        if (primary instanceof ComparableLower && primary.getClass().isInstance(second)) {
            return ((ComparableLower)primary).$less(second);
        }
        if (primary instanceof Number && second instanceof Number) {
            return ((Number)primary).longValue() < ((Number)second).longValue();
        }
        if (primary == null || second == null) {
            return false;
        }
        throw new AssertionError((Object)("no OpCapable for LESS/GREATER for " + primary + " vs. " + second));
    }

    public static boolean $lesseq(Object first, Object second) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public static boolean $greater(Object first, Object second) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public static boolean $greatereq(Object first, Object second) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public static boolean $noteq_ptr(Object primary, Object second) {
        return !Native.$eq_ptr(primary, second);
    }

    public static boolean $noteq_ptr(void$ptr primary, void$ptr second) {
        return !Native.$eq_ptr(primary, second);
    }

    public static boolean $noteq_iter(abstract_iterator primary, abstract_iterator second) {
        return !Native.$eq_iter(primary, second);
    }

    public static boolean $noteq(abstract_iterator primary, abstract_iterator second) {
        throw new AssertionError((Object)"must use $noteq_iter for iterators");
    }

    public static boolean $noteq(void$ptr primary, void$ptr second) {
        throw new AssertionError((Object)"must use $noteq_ptr for pointers");
    }

    public static boolean $noteq(Object primary, Object second) {
        assert (!(primary instanceof void$ptr) || !(second instanceof void$ptr)) : "must use $noteq_ptr for pointers";
        assert (!(primary instanceof abstract_iterator) || !(second instanceof abstract_iterator)) : "must use $noteq_iter for iterators";
        return Native.$noteq(primary, second, false);
    }

    public static boolean $noteq(Object primary, Object second, boolean isPointerLike) {
        if (isPointerLike) {
            assert (!(primary instanceof void$ptr) || !(second instanceof void$ptr)) : "Real pointers should not be considered as 'pointer like'! use $noteq_ptr instead";
            assert (!(primary instanceof abstract_iterator) || !(second instanceof abstract_iterator)) : "Real iterators should not be considered as 'pointer like'! use $noteq_iter instead";
            return primary != second;
        }
        if (primary == second) {
            return false;
        }
        if (primary instanceof NativeComparable) {
            return ((NativeComparable)primary).$noteq(second);
        }
        if (second instanceof NativeComparable) {
            return ((NativeComparable)second).$noteq(primary);
        }
        if (primary == null || second == null) {
            return true;
        }
        return !primary.equals(second);
    }

    public static boolean $noteq(byte primary, byte second) {
        return primary != second;
    }

    public static boolean $noteq(byte primary, byte second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $noteq(char primary, char second) {
        return primary != second;
    }

    public static boolean $noteq(char primary, char second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $noteq(int primary, int second) {
        return primary != second;
    }

    public static boolean $noteq(int primary, int second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $noteq(long primary, long second) {
        return primary != second;
    }

    public static boolean $noteq(long primary, long second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $noteq(boolean primary, boolean second) {
        return primary != second;
    }

    public static boolean $noteq(boolean primary, boolean second, boolean isPointerLike) {
        return primary != second;
    }

    public static boolean $less(int first, int second) {
        return first < second;
    }

    public static boolean $lesseq(int first, int second) {
        return first <= second;
    }

    public static boolean $greater(int first, int second) {
        return first > second;
    }

    public static boolean $greatereq(int first, int second) {
        return first >= second;
    }

    public static boolean $less(long first, long second) {
        return first < second;
    }

    public static boolean $lesseq(long first, long second) {
        return first <= second;
    }

    public static boolean $greater(long first, long second) {
        return first > second;
    }

    public static boolean $greatereq(long first, long second) {
        return first >= second;
    }

    public static <T> T $tryAssign(T dst, T src, boolean isPointerLike) {
        if (isPointerLike) {
            assert (!(src instanceof void$ptr) || src instanceof char$ptr) : "Real pointers " + src.getClass() + " should not be considered as 'pointer like'! (Probably default value should be passed into some collection)";
            return src;
        }
        if (dst instanceof assignable) {
            ((assignable)dst).$assign(src);
            return dst;
        }
        return Native.$tryMove(src);
    }

    public static uchar$ptr $tryClone(uchar$ptr t) {
        if (t == null) {
            return null;
        }
        uchar$ptr out = (uchar$ptr)t.clone();
        assert (out.getClass() == t.getClass()) : "INVALID clone! Was " + t.getClass() + " became " + out.getClass();
        return out;
    }

    public static char$ptr $tryClone(char$ptr t) {
        if (t == null) {
            return null;
        }
        char$ptr out = (char$ptr)t.clone();
        assert (out.getClass() == t.getClass()) : "INVALID clone! Was " + t.getClass() + " became " + out.getClass();
        return out;
    }

    public static int $ptr_index(char$ptr ptr2) {
        return ptr2 != null ? ptr2.$index() : 0;
    }

    public static int $ptr_index(int$ptr ptr2) {
        return ptr2 != null ? ptr2.$index() : 0;
    }

    public static int $ptr_index(type$ptr ptr2) {
        return ptr2 != null ? ptr2.$index() : 0;
    }

    public static int $sub_ptr(char$ptr first, char$ptr second) {
        return first == second ? 0 : first.$sub(second);
    }

    public static int $sub_ptr(int$ptr first, int$ptr second) {
        return first == second ? 0 : first.$sub(second);
    }

    public static int $sub_ptr(type$ptr first, type$ptr second) {
        return first == second ? 0 : first.$sub(second);
    }

    public static <T> type$ptr<T> $add(type$ptr<T> ptr2, int val) {
        return val != 0 ? (type$ptr)ptr2.$add(val) : Native.$tryClone(ptr2);
    }

    public static void $setIndex(char$ptr ptr2, char$ptr orig) {
        assert (ptr2.isComparableTo(orig)) : "ptr has different buffer? " + ptr2 + " vs. " + orig;
        Native.$setIndex(ptr2, orig.$index());
    }

    public static char$ptr $incConstIndex(char$ptr ptr2, int amount) {
        ptr2 = Native.$cleanConst(ptr2);
        if (amount != 0) {
            ptr2.$inc(amount);
        }
        return Native.$toConst(ptr2);
    }

    public static void $setIndex(char$ptr ptr2, int index) {
        int cur$index = ptr2.$index();
        if (cur$index != index) {
            ptr2.$inc(index - cur$index);
        }
        assert (ptr2.$index() == index);
    }

    public static void $setIndex(int$ptr ptr2, int index) {
        int cur$index = ptr2.$index();
        if (cur$index != index) {
            ptr2.$inc(index - cur$index);
        }
        assert (ptr2.$index() == index);
    }

    public static void $setIndex(uint$ptr ptr2, int index) {
        int cur$index = ptr2.$index();
        if (cur$index != index) {
            ptr2.$inc(index - cur$index);
        }
        assert (ptr2.$index() == index);
    }

    public static void $setArrayAndIndex(char$ptr ptr2, byte[] array2, int index) {
        assert (Native.$is_array_based(ptr2));
        ((char$ptr$array)ptr2).index = index;
        AliasesAccessor.$setArray((char$ptr$array)ptr2, array2, index);
    }

    public static void $setArrayAndIndex(char$ptr$array ptr2, byte[] array2, int index) {
        assert (Native.$is_array_based(ptr2));
        ptr2.index = index;
        AliasesAccessor.$setArray(ptr2, array2, index);
    }

    public static <T extends NativeMoveable<T>> T $tryMove(T t) {
        return (T)((NativeMoveable)t.move());
    }

    public static <T> T $tryMove(T t) {
        if (t instanceof NativeMoveable) {
            return ((NativeMoveable)t).move();
        }
        return Native.$tryClone(t);
    }

    public static <T extends NativeCloneable> T $tryClone(T t) {
        if (t == null) {
            return null;
        }
        NativeCloneable out = (NativeCloneable)t.clone();
        assert (out.getClass() == t.getClass()) : "INVALID clone! Was " + t.getClass() + " became " + out.getClass();
        return (T)out;
    }

    public static <T> T $tryClone(T t) {
        if (t instanceof NativeCloneable) {
            return (T)Native.$tryClone((NativeCloneable)t);
        }
        return t;
    }

    public static <T> T[] $tryClone(T[] val) {
        return (Object[])val.clone();
    }

    public static boolean $tryClone(boolean val) {
        return val;
    }

    public static byte $tryClone(byte val) {
        return val;
    }

    public static short $tryClone(short val) {
        return val;
    }

    public static int $tryClone(int val) {
        return val;
    }

    public static long $tryClone(long val) {
        return val;
    }

    public static char $tryClone(char val) {
        return val;
    }

    public static char$ptr $noClone(char$ptr t) {
        return t;
    }

    public static <T> T $noClone(T t) {
        return t;
    }

    public static boolean $is_array_based(char$ptr t) {
        return t instanceof char$ptr$array;
    }

    public static char$ptr $cleanConst(char$ptr t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof AbstractArrayPointerType) : "unexpected class " + t.getClass();
            return t == null ? null : (char$ptr)((AbstractArrayPointerType)((Object)t)).$cleanConstPtr();
        }
        return t;
    }

    public static char$ptr $prepareCloneFor(char$ptr toPrepare, char$ptr orig) {
        if (toPrepare == orig) {
            return toPrepare;
        }
        if (toPrepare == null || toPrepare.getClass() != orig.getClass()) {
            toPrepare = Native.$tryClone(orig);
        } else {
            if (((AbstractArrayPointerType)((Object)toPrepare))._isConstPtr()) {
                toPrepare = Native.$cleanConst(toPrepare);
            }
            toPrepare.$assign(orig);
        }
        return toPrepare;
    }

    public static char$ptr $toConst(char$ptr t) {
        if (NativeTrace.isDebugMode()) {
            assert (t == null || t instanceof AbstractArrayPointerType) : "unexpected class " + t.getClass();
            return t == null ? null : (char$ptr)((AbstractArrayPointerType)((Object)t)).$toConstPtr();
        }
        return t;
    }

    public static char$ptr $tryConstClone(char$ptr t) {
        assert (t == null || t instanceof AbstractArrayPointerType) : "unexpected class " + t.getClass();
        return t == null ? null : (char$ptr)t.const_clone();
    }

    public static char$ptr $tryDebugConstClone(char$ptr t) {
        if (NativeTrace.isDebugMode()) {
            return t == null ? null : (char$ptr)t.const_clone();
        }
        return t;
    }

    public static <T> T $tryConstClone(T t) {
        if (t == null) {
            return null;
        }
        if (t instanceof abstract_iterator) {
            return ((abstract_iterator)t).const_clone();
        }
        if (t instanceof AbstractArrayPointerType && ((AbstractArrayPointerType)t)._isConstPtr()) {
            return t;
        }
        if (t instanceof NativeCloneable) {
            return ((NativeCloneable)t).clone();
        }
        throw new AssertionError((Object)("Why not cloneable?" + t));
    }

    public static String $toString(char$ptr chars) {
        if (chars == null) {
            return null;
        }
        return Casts.toJavaString(chars);
    }

    public static String $toString(char$ptr chars, int length) {
        return Casts.toJavaString(chars, length);
    }

    public static String $toString(char$iterator<?> chars) {
        if (chars instanceof char$ptr) {
            return Native.$toString((char$ptr)chars);
        }
        return Native.$toString(chars, std.strlen(chars));
    }

    public static String $toString(char$iterator<?> chars, int length) {
        if (chars instanceof char$ptr) {
            return Native.$toString((char$ptr)chars, length);
        }
        chars = Native.$tryClone(chars);
        StringBuilder out = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            out.append((char)chars.$star());
            chars.$preInc();
        }
        return out.toString();
    }

    public static <T> T $star(T o) {
        return o;
    }

    public static int availableProcessors() {
        return NUM_PARALLEL_THREADS;
    }

    private Native() {
    }

    static void clearStatistics() {
        JavaCleaner.clearStatistics();
    }

    static long printStatistics(PrintWriter out) {
        long Value = JavaCleaner.printStatistics(out);
        return Value;
    }

    public static final class CharPtrToCharSequenceConverter
    implements CollectionUtils.Converter<char$ptr, CharSequence> {
        @Override
        public Class<CharSequence> getToClass() {
            return CharSequence.class;
        }

        @Override
        public CharSequence convert(char$ptr from) {
            return Native.$toString(from);
        }
    }

    public static final class CharPtrToStringConverter
    implements CollectionUtils.Converter<char$ptr, String> {
        @Override
        public Class<String> getToClass() {
            return String.class;
        }

        @Override
        public String convert(char$ptr from) {
            return Native.$toString(from);
        }
    }

    public static final class CharSequenceToCharPtrConverter
    implements CollectionUtils.Converter<CharSequence, char$ptr> {
        @Override
        public Class<char$ptr> getToClass() {
            return char$ptr.class;
        }

        @Override
        public char$ptr convert(CharSequence from) {
            return NativePointer.create_char$ptr(from);
        }
    }

    public static interface NativeHashable {
        public int $hashcode();
    }

    public static interface NativePOD<T>
    extends assignable<T>,
    NativeCloneable<T>,
    NativeComparable<T> {
    }

    public static interface assignable<T> {
        public T $assign(T var1);
    }

    public static interface NativeIterable<Iter> {
        public Iter begin();

        public Iter end();
    }

    public static interface ComparableLowerGreater
    extends ComparableLower,
    ComparableGreater {
    }

    public static interface ComparableGreater {
        public boolean $greater(Object var1);

        default public boolean $greatereq(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ComparableLower {
        public boolean $less(Object var1);

        default public boolean $lesseq(Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface OpCapable {
        public Boolean $op(Op var1, Object var2);

        public static enum Op {
            EQ,
            LESS,
            LESSEQ,
            GREATER,
            GREATEREQ;

        }
    }

    public static interface NativeComparable<T> {
        default public boolean $noteq(T other) {
            return !this.$eq(other);
        }

        public boolean $eq(T var1);
    }

    public static interface ComparatorLower<LHS, RHS> {
        public boolean $less(LHS var1, RHS var2);
    }
}

