/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.RuntimeHelper;
import org.netbeans.modules.groovy.grails.WrapperProcess;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grails.server.GrailsInstanceProvider;
import org.netbeans.modules.groovy.grails.settings.GrailsSettings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class GrailsPlatform {
    public static final String IDE_RUN_COMMAND = "run-app";
    private static final Logger LOGGER = Logger.getLogger(GrailsPlatform.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private static final Set<String> GUARDED_COMMANDS = new HashSet<String>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static GrailsPlatform instance;
    private Version version;
    private ClassPath classpath;

    private GrailsPlatform() {
    }

    public static synchronized GrailsPlatform getDefault() {
        if (instance == null) {
            instance = new GrailsPlatform();
            GrailsSettings.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("grailsBase".equals(evt.getPropertyName())) {
                        instance.reload();
                        GrailsInstanceProvider.getInstance().runtimeChanged();
                    }
                }
            });
            instance.reload();
        }
        return instance;
    }

    public Callable<Process> createCommand(CommandDescriptor descriptor) {
        Parameters.notNull((CharSequence)"descriptor", (Object)descriptor);
        if (!this.isConfigured()) {
            NotifyDescriptor.Message dialogMessage = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GrailsPlatform.class, (String)"MSG_GrailsNotConfigured"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogMessage) == NotifyDescriptor.OK_OPTION) {
                return new GrailsCallable(descriptor);
            }
        }
        return new GrailsCallable(descriptor);
    }

    public boolean isConfigured() {
        String grailsBase = GrailsSettings.getInstance().getGrailsBase();
        if (grailsBase == null) {
            return false;
        }
        return RuntimeHelper.isValidRuntime(new File(grailsBase));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getClassPath() {
        GrailsPlatform grailsPlatform = this;
        synchronized (grailsPlatform) {
            File libDir;
            List<File> libJars;
            if (this.classpath != null) {
                return this.classpath;
            }
            if (!this.isConfigured()) {
                this.classpath = EMPTY_CLASSPATH;
                return this.classpath;
            }
            File grailsHome = this.getGrailsHome();
            if (!grailsHome.exists()) {
                this.classpath = EMPTY_CLASSPATH;
                return this.classpath;
            }
            ArrayList<File> jars = new ArrayList<File>();
            File distDir = new File(grailsHome, "dist");
            File[] files = distDir.listFiles();
            if (files != null) {
                jars.addAll(Arrays.asList(files));
            }
            if ((libJars = this.getJarsRecursively(libDir = new File(grailsHome, "lib"))) != null) {
                jars.addAll(libJars);
            }
            ArrayList<URL> urls = new ArrayList<URL>(jars.size());
            for (File f : jars) {
                try {
                    URL entry;
                    if (!f.isFile() || !FileUtil.isArchiveFile((URL)(entry = f.toURI().toURL()))) continue;
                    entry = FileUtil.getArchiveRoot((URL)entry);
                    urls.add(entry);
                }
                catch (MalformedURLException mue) {
                    assert (false) : mue;
                }
            }
            this.classpath = ClassPathSupport.createClassPath((URL[])urls.toArray(new URL[urls.size()]));
            return this.classpath;
        }
    }

    private List<File> getJarsRecursively(File parentDir) {
        ArrayList<File> jars = new ArrayList<File>();
        if (parentDir != null) {
            for (File file : parentDir.listFiles()) {
                if (file.isDirectory()) {
                    jars.addAll(this.getJarsRecursively(file));
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                jars.add(file);
            }
        }
        return jars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getVersion() {
        GrailsPlatform grailsPlatform = this;
        synchronized (grailsPlatform) {
            if (this.version != null) {
                return this.version;
            }
            String grailsBase = GrailsSettings.getInstance().getGrailsBase();
            try {
                String stringVersion;
                this.version = grailsBase != null ? ((stringVersion = RuntimeHelper.getRuntimeVersion(new File(grailsBase))) != null ? Version.valueOf(stringVersion) : Version.VERSION_DEFAULT) : Version.VERSION_DEFAULT;
            }
            catch (IllegalArgumentException ex) {
                this.version = Version.VERSION_DEFAULT;
            }
            return this.version;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        GrailsPlatform grailsPlatform = this;
        synchronized (grailsPlatform) {
            this.version = null;
            this.classpath = null;
        }
        this.changeSupport.fireChange();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GrailsPlatform grailsPlatform = GrailsPlatform.this;
                synchronized (grailsPlatform) {
                    if (GrailsPlatform.this.version != null) {
                        return;
                    }
                    String grailsBase = GrailsSettings.getInstance().getGrailsBase();
                    try {
                        if (grailsBase != null) {
                            String stringVersion = RuntimeHelper.getRuntimeVersion(new File(grailsBase));
                            if (stringVersion != null) {
                                GrailsPlatform.this.version = Version.valueOf(stringVersion);
                            } else {
                                GrailsPlatform.this.version = Version.VERSION_DEFAULT;
                            }
                        } else {
                            GrailsPlatform.this.version = Version.VERSION_DEFAULT;
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        GrailsPlatform.this.version = Version.VERSION_DEFAULT;
                    }
                }
            }
        });
    }

    public File getGrailsHome() {
        String grailsBase = GrailsSettings.getInstance().getGrailsBase();
        if (grailsBase == null || !RuntimeHelper.isValidRuntime(new File(grailsBase))) {
            throw new IllegalStateException("Grails not configured");
        }
        return new File(grailsBase);
    }

    private static String createJvmArguments(String vmOptions, Properties properties) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        if (vmOptions != null) {
            builder.append(vmOptions);
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String value = properties.getProperty(key);
            if (value == null) continue;
            if (i > 0 || vmOptions != null) {
                builder.append(" ");
            }
            builder.append("-D").append(key);
            builder.append("=");
            builder.append(value);
            ++i;
        }
        return builder.toString();
    }

    private static String createCommandArguments(String[] arguments) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(arguments[i]);
        }
        return builder.toString();
    }

    private static void checkForServer(CommandDescriptor descriptor, Process process) {
        Project project;
        if (IDE_RUN_COMMAND.equals(descriptor.getName()) && (project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)descriptor.getDirectory()))) != null) {
            GrailsInstanceProvider.getInstance().serverStarted(project, process);
        }
    }

    static {
        Collections.addAll(GUARDED_COMMANDS, IDE_RUN_COMMAND, "run-app-https", "run-war", "shell");
    }

    private static class GrailsCallable
    implements Callable<Process> {
        private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
        private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
        private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
        private final CommandDescriptor descriptor;

        public GrailsCallable(CommandDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public Process call() throws Exception {
            File file;
            String port;
            GrailsEnvironment env;
            Version platformVersion = GrailsPlatform.getDefault().getVersion();
            File grailsExecutable = null;
            grailsExecutable = platformVersion.compareTo(Version.VERSION_2) < 0 ? RuntimeHelper.getGrailsExecutable(new File(GrailsSettings.getInstance().getGrailsBase()), true) : RuntimeHelper.getGrailsExecutable(new File(GrailsSettings.getInstance().getGrailsBase()), false);
            if (grailsExecutable == null || !grailsExecutable.exists()) {
                LOGGER.log(Level.WARNING, "Executable doesn''t exist: {0}", grailsExecutable.getAbsolutePath());
                return null;
            }
            LOGGER.log(Level.FINEST, "About to run: {0}", this.descriptor.getName());
            Properties props = new Properties(this.descriptor.getProps());
            GrailsEnvironment grailsEnvironment = env = this.descriptor.getProjectConfig() != null ? this.descriptor.getProjectConfig().getEnvironment() : null;
            if (env != null && env.isCustom()) {
                props.setProperty("grails.env", env.toString());
            }
            if (this.descriptor.getProjectConfig() != null && GrailsPlatform.IDE_RUN_COMMAND.equals(this.descriptor.getName()) && (port = this.descriptor.getProjectConfig().getPort()) != null) {
                props.setProperty("server.port", port);
            }
            props.setProperty("jline.WindowsTerminal.directConsole", "false");
            String proxyString = GrailsCallable.getNetBeansHttpProxy(props);
            StringBuilder command = new StringBuilder();
            if (env != null && !env.isCustom()) {
                command.append(" ").append(env.toString());
            }
            command.append(" ").append(this.descriptor.getName());
            if (this.descriptor.isDebug()) {
                if (platformVersion.compareTo(Version.VERSION_3) >= 0) {
                    command.append(" ").append("--debug-jvm");
                } else if (platformVersion.compareTo(Version.VERSION_2) >= 0) {
                    command.append(" ").append("--debug-fork");
                }
            }
            command.append(" ").append(GrailsPlatform.createCommandArguments(this.descriptor.getArguments()));
            String preProcessUUID = UUID.randomUUID().toString();
            LOGGER.log(Level.FINEST, "Command is: {0}", command.toString());
            NbProcessDescriptor grailsProcessDesc = new NbProcessDescriptor(grailsExecutable.getAbsolutePath(), command.toString());
            String javaHome = null;
            JavaPlatform javaPlatform = this.descriptor.getProjectConfig() != null ? this.descriptor.getProjectConfig().getJavaPlatform() : JavaPlatformManager.getDefault().getDefaultPlatform();
            Collection dirs = javaPlatform.getInstallFolders();
            if (dirs.size() == 1 && (file = FileUtil.toFile((FileObject)((FileObject)dirs.iterator().next()))) != null) {
                javaHome = file.getAbsolutePath();
            }
            String vmOptions = null;
            if (this.descriptor.getProjectConfig() != null && (vmOptions = this.descriptor.getProjectConfig().getVmOptions()) != null && "".equals(vmOptions.trim())) {
                vmOptions = null;
            }
            String[] envp = new String[]{"GRAILS_HOME=" + GrailsSettings.getInstance().getGrailsBase(), "JAVA_HOME=" + javaHome, "http_proxy=" + proxyString, "HTTP_PROXY=" + proxyString, "JAVA_OPTS=" + GrailsPlatform.createJvmArguments(vmOptions, props)};
            WrapperProcess process = null;
            try {
                process = new WrapperProcess(grailsProcessDesc.exec(null, envp, true, this.descriptor.getDirectory()), preProcessUUID);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GrailsPlatform.class, (String)"MSG_StartFailedIOE", (Object)grailsExecutable.getAbsolutePath()), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)desc);
                throw ex;
            }
            GrailsPlatform.checkForServer(this.descriptor, process);
            return process;
        }

        private static String getNetBeansHttpProxy(Properties props) {
            int port;
            String host = System.getProperty("http.proxyHost");
            if (host == null) {
                return null;
            }
            String portHttp = System.getProperty("http.proxyPort");
            try {
                port = Integer.parseInt(portHttp);
            }
            catch (NumberFormatException e) {
                port = 8080;
            }
            Preferences prefs = NbPreferences.root().node("org/netbeans/core");
            boolean useAuth = prefs.getBoolean(USE_PROXY_AUTHENTICATION, false);
            String auth = "";
            if (useAuth) {
                String username = prefs.get(PROXY_AUTHENTICATION_USERNAME, "");
                String password = prefs.get(PROXY_AUTHENTICATION_PASSWORD, "");
                auth = username + ":" + password + '@';
                if (!props.contains("http.proxyUser")) {
                    props.setProperty("http.proxyUser", prefs.get(PROXY_AUTHENTICATION_USERNAME, ""));
                }
                if (!props.contains("http.proxyPassword")) {
                    props.setProperty("http.proxyPassword", prefs.get(PROXY_AUTHENTICATION_PASSWORD, ""));
                }
            }
            if (!props.contains("http.proxyHost")) {
                props.setProperty("http.proxyHost", host);
            }
            if (!props.contains("http.proxyPort")) {
                props.setProperty("http.proxyPort", Integer.toString(port));
            }
            if (host.indexOf(58) == -1) {
                host = "http://" + auth + host;
            }
            return host + ":" + port;
        }
    }

    public static final class Version
    implements Comparable<Version> {
        public static final Version VERSION_DEFAULT = new Version(1, null, null, null, null);
        public static final Version VERSION_1_1 = new Version(1, 1, null, null, null);
        public static final Version VERSION_2 = new Version(2, null, null, null, null);
        public static final Version VERSION_3 = new Version(3, null, null, null, null);
        private final int major;
        private final Integer minor;
        private final Integer micro;
        private final Integer update;
        private final String qualifier;
        private String asString;

        protected Version(int major, Integer minor, Integer micro, Integer update, String qualifier) {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.update = update;
            this.qualifier = qualifier;
        }

        public static Version valueOf(String version) {
            String[] numberParts;
            String[] stringParts = version.split("-");
            String qualifier = null;
            if (stringParts.length > 2) {
                throw new IllegalArgumentException(version);
            }
            if (stringParts.length == 2) {
                qualifier = stringParts[1];
            }
            if ((numberParts = stringParts[0].split("\\.")).length < 1 || numberParts.length > 4) {
                throw new IllegalArgumentException(version);
            }
            Integer[] parsed = new Integer[4];
            for (int i = 0; i < Math.min(numberParts.length, 3); ++i) {
                try {
                    parsed[i] = Integer.valueOf(numberParts[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(version, ex);
                }
            }
            if (numberParts.length == 4) {
                qualifier = numberParts[3];
            }
            return new Version(parsed[0], parsed[1], parsed[2], parsed[3], qualifier);
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor == null ? 0 : this.minor;
        }

        public int getMicro() {
            return this.micro == null ? 0 : this.micro;
        }

        public int getUpdate() {
            return this.update == null ? 0 : this.update;
        }

        public String getQualifier() {
            return this.qualifier == null ? "" : this.qualifier;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (this.getMajor() != other.getMajor()) {
                return false;
            }
            if (this.getMinor() != other.getMinor()) {
                return false;
            }
            if (this.getMicro() != other.getMicro()) {
                return false;
            }
            if (this.getUpdate() != other.getUpdate()) {
                return false;
            }
            return this.getQualifier().equals(other.getQualifier());
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + this.getMajor();
            hash = 71 * hash + this.getMinor();
            hash = 71 * hash + this.getMicro();
            hash = 71 * hash + this.getUpdate();
            hash = 71 * hash + this.getQualifier().hashCode();
            return hash;
        }

        @Override
        public int compareTo(Version o) {
            if (this == o) {
                return 0;
            }
            int result = this.getMajor() - o.getMajor();
            if (result != 0) {
                return result;
            }
            result = this.getMinor() - o.getMinor();
            if (result != 0) {
                return result;
            }
            result = this.getMicro() - o.getMicro();
            if (result != 0) {
                return result;
            }
            result = this.getUpdate() - o.getUpdate();
            if (result != 0) {
                return result;
            }
            return this.getQualifier().compareTo(o.getQualifier());
        }

        public String toString() {
            if (this.asString == null) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.major);
                if (this.minor != null || this.micro != null || this.update != null) {
                    this.appendSeparator(builder);
                    builder.append(this.minor == null ? 0 : this.minor);
                }
                if (this.micro != null || this.update != null) {
                    this.appendSeparator(builder);
                    builder.append(this.micro == null ? 0 : this.micro);
                }
                if (this.update != null) {
                    this.appendSeparator(builder);
                    builder.append(this.update == null ? 0 : this.update);
                }
                if (this.qualifier != null) {
                    if (this.minor != null && this.micro != null && this.update == null) {
                        builder.append('.');
                    } else {
                        builder.append('-');
                    }
                    builder.append(this.qualifier);
                }
                this.asString = builder.toString();
            }
            return this.asString;
        }

        private void appendSeparator(StringBuilder builder) {
            if (builder.length() > 0 && builder.charAt(builder.length() - 1) != '.') {
                builder.append('.');
            }
        }
    }

    public static final class CommandDescriptor {
        private final String name;
        private final File directory;
        private final GrailsProjectConfig config;
        private final String[] arguments;
        private final Properties props;
        private final boolean debug;

        public static CommandDescriptor forProject(String name, File directory, GrailsProjectConfig config, String[] arguments, Properties props) {
            return new CommandDescriptor(name, directory, config, arguments, props, false);
        }

        public static CommandDescriptor forProject(String name, File directory, GrailsProjectConfig config, String[] arguments, Properties props, boolean debug) {
            return new CommandDescriptor(name, directory, config, arguments, props, debug);
        }

        private CommandDescriptor(String name, File directory, GrailsProjectConfig config, String[] arguments, Properties props, boolean debug) {
            this.name = name;
            this.directory = directory;
            this.config = config;
            this.arguments = (String[])arguments.clone();
            this.props = props != null ? new Properties(props) : new Properties();
            this.debug = debug;
        }

        public String getName() {
            return this.name;
        }

        public File getDirectory() {
            return this.directory;
        }

        public GrailsProjectConfig getProjectConfig() {
            return this.config;
        }

        public String[] getArguments() {
            return (String[])this.arguments.clone();
        }

        public Properties getProps() {
            return new Properties(this.props);
        }

        public boolean isDebug() {
            return this.debug;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CommandDescriptor other = (CommandDescriptor)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }
}

