/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.profiler.global.CommonConstants;

public class Platform
implements CommonConstants {
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    public static final int OS_OS2 = 1024;
    public static final int OS_MAC = 2048;
    public static final int OS_WIN2000 = 4096;
    public static final int OS_VMS = 8192;
    public static final int OS_WIN_OTHER = 16384;
    public static final int OS_OTHER = 65536;
    public static final int OS_WINDOWS_MASK = 20487;
    public static final int OS_UNIX_MASK = 3064;
    private static int operatingSystem = -1;
    private static String jdkDenoteString;
    private static int jdkVersion;
    private static int sysArch;

    public static String getAgentNativeLibFullName(String fullAgentPath, boolean fullPathToLibSpecified, String jdkString, int architecture) {
        boolean is64bitArch;
        if (jdkString == null) {
            jdkString = Platform.getJDKVersionString();
        }
        if (architecture == -1) {
            architecture = Platform.getSystemArchitecture();
        }
        boolean bl = is64bitArch = architecture == 64;
        if (jdkString.equals("jdk17") || jdkString.equals("jdk18") || jdkString.equals("jdk19")) {
            jdkString = "jdk16";
        }
        String libPrefix = "";
        if (!Platform.isWindows()) {
            libPrefix = "lib";
        }
        String libSuffix = "";
        libSuffix = Platform.isWindows() ? ".dll" : (Platform.isMac() ? ".jnilib" : (Platform.isHpux() ? ".sl" : ".so"));
        String libSubPath = "/";
        if (!fullPathToLibSpecified) {
            String libSubDir = Platform.isWindows() ? "windows" : (Platform.isMac() ? "mac" : (Platform.isLinux() ? "linux" : (Platform.isHpux() ? "hpux" : "solaris")));
            String procArch = null;
            if (is64bitArch) {
                if (Platform.isLinux() || Platform.isWindows() || Platform.isSolarisIntel()) {
                    procArch = "amd64";
                } else if (Platform.isSolarisSparc()) {
                    procArch = "sparcv9";
                } else if (Platform.isHpux()) {
                    procArch = "pa_risc2.0w";
                }
            } else if (Platform.isSolarisIntel()) {
                procArch = "i386";
            } else if (Platform.isSolarisSparc()) {
                procArch = "sparc";
            } else if (Platform.isHpux()) {
                procArch = "pa_risc2.0";
            } else if (Platform.isLinuxArm()) {
                procArch = Platform.isLinuxArmVfpHflt() ? "arm-vfp-hflt" : "arm";
            }
            if (procArch != null) {
                libSubDir = libSubDir + "-" + procArch;
            }
            libSubPath = "/deployed/" + jdkString + "/" + libSubDir + "/";
        }
        String fullPath = fullAgentPath;
        if (fullAgentPath.startsWith("\"")) {
            fullPath = fullAgentPath.substring(1, fullAgentPath.length() - 1);
        }
        fullPath = fullPath.replace('\\', '/');
        return fullPath + libSubPath + libPrefix + "profilerinterface" + libSuffix;
    }

    public static int getJDKMinorNumber(String jdkVersionString) {
        if (jdkVersionString == null) {
            return 0;
        }
        int minorIndex = jdkVersionString.lastIndexOf(95);
        if (minorIndex > 0 && minorIndex < jdkVersionString.length() - 1) {
            String minorString = jdkVersionString.substring(minorIndex + 1);
            int subverIndex = minorString.indexOf(45);
            if (subverIndex != -1) {
                minorString = minorString.substring(0, subverIndex);
            }
            return Integer.parseInt(minorString);
        }
        return 0;
    }

    private static int getJDKVersionNumber(String javaVersion) {
        int jdkVersion = javaVersion.startsWith("1.5") ? 2 : (javaVersion.startsWith("1.6") ? 3 : (javaVersion.startsWith("1.7") ? 4 : (javaVersion.startsWith("1.8") ? 6 : (javaVersion.startsWith("1.9") ? 7 : (javaVersion.startsWith("9") ? 7 : (javaVersion.equals("CVM") ? 5 : -1))))));
        return jdkVersion;
    }

    public static int getJDKVersionNumber() {
        if (jdkVersion == 0) {
            jdkVersion = Platform.getJDKVersionNumber(Platform.getJavaVersionString());
        }
        return jdkVersion;
    }

    public static String getJDKVersionString(String javaVersionString) {
        int jdkVersionNumber = Platform.getJDKVersionNumber(javaVersionString);
        switch (jdkVersionNumber) {
            case 2: {
                return "jdk15";
            }
            case 3: {
                return "jdk16";
            }
            case 4: {
                return "jdk17";
            }
            case 6: {
                return "jdk18";
            }
            case 7: {
                return "jdk19";
            }
            case 5: {
                return "cvm";
            }
            case -1: {
                return "UNSUPPORTED_JDK";
            }
        }
        System.err.println("Unsupported java " + javaVersionString);
        return "UNSUPPORTED_JDK";
    }

    public static String getJDKVersionString() {
        if (jdkDenoteString == null) {
            jdkDenoteString = Platform.getJDKVersionString(Platform.getJavaVersionString());
        }
        return jdkDenoteString;
    }

    public static String getJavaVersionString() {
        String vmVersion = System.getProperty("java.vm.name");
        if ("CVM".equals(vmVersion)) {
            return vmVersion;
        }
        return System.getProperty("java.version");
    }

    public static String getJFluidNativeLibDirName(String fullJFluidPath, String jdkString, int architecture) {
        String jFluidNativeLibFullName = Platform.getAgentNativeLibFullName(fullJFluidPath, false, jdkString, architecture);
        return jFluidNativeLibFullName.substring(0, jFluidNativeLibFullName.lastIndexOf(47));
    }

    public static boolean isLinux() {
        return Platform.getOperatingSystem() == 16;
    }

    public static boolean isLinux(String osName) {
        return Platform.getOperatingSystem(osName) == 16;
    }

    public static boolean isMac() {
        return Platform.getOperatingSystem() == 2048;
    }

    public static boolean isHpux() {
        return Platform.getOperatingSystem() == 32;
    }

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = Platform.getOperatingSystem(osName);
        }
        return operatingSystem;
    }

    public static int getOperatingSystem(String osName) {
        if ("Windows NT".equals(osName)) {
            return 1;
        }
        if ("Windows 95".equals(osName)) {
            return 2;
        }
        if ("Windows 98".equals(osName)) {
            return 4;
        }
        if ("Windows 2000".equals(osName)) {
            return 4096;
        }
        if (osName.startsWith("Windows ")) {
            return 16384;
        }
        if ("Solaris".equals(osName)) {
            return 8;
        }
        if (osName.startsWith("SunOS")) {
            return 8;
        }
        if (osName.endsWith("Linux")) {
            return 16;
        }
        if ("HP-UX".equals(osName)) {
            return 32;
        }
        if ("AIX".equals(osName)) {
            return 64;
        }
        if ("Irix".equals(osName)) {
            return 128;
        }
        if ("SunOS".equals(osName)) {
            return 8;
        }
        if ("Digital UNIX".equals(osName)) {
            return 512;
        }
        if ("OS/2".equals(osName)) {
            return 1024;
        }
        if ("OpenVMS".equals(osName)) {
            return 8192;
        }
        if (osName.equalsIgnoreCase("mac os x")) {
            return 2048;
        }
        if (osName.startsWith("Darwin")) {
            return 2048;
        }
        return 65536;
    }

    public static String getProfilerUserDir() throws IOException {
        String customDir = System.getProperty("nbprofiler.home");
        if (customDir != null) {
            File d = new File(customDir);
            if (!d.exists() && !d.mkdir()) {
                throw new IOException("Could not create directory " + customDir);
            }
            return customDir;
        }
        String dir = System.getProperty("user.home") + File.separator + ".nbprofiler";
        File d = new File(dir);
        if (!d.exists() && !d.mkdir()) {
            throw new IOException("Could not create directory " + dir);
        }
        return dir;
    }

    public static boolean isSolaris() {
        return Platform.getOperatingSystem() == 8;
    }

    public static boolean isSolarisIntel() {
        String procArch = System.getProperty("os.arch");
        return Platform.isSolaris() && (procArch.endsWith("86") || procArch.equals("amd64"));
    }

    public static boolean isSolarisSparc() {
        String procArch = System.getProperty("os.arch");
        return Platform.isSolaris() && procArch.startsWith("sparc");
    }

    public static boolean isLinuxArm() {
        String procArch = System.getProperty("os.arch");
        return Platform.isLinux() && procArch.startsWith("arm");
    }

    public static boolean isLinuxArmVfpHflt() {
        String procArch = System.getProperty("sun.arch.abi");
        return Platform.isLinux() && Platform.isLinuxArm() && "gnueabihf".equals(procArch);
    }

    public static int getSystemArchitecture() {
        if (sysArch == 0) {
            String architecture = System.getProperty("sun.arch.data.model");
            sysArch = Platform.getSystemArchitecture(architecture);
        }
        return sysArch;
    }

    public static int getSystemArchitecture(String arch) {
        return "64".equals(arch) ? 64 : 32;
    }

    public static boolean isUnix() {
        return (Platform.getOperatingSystem() & 0xBF8) != 0;
    }

    public static boolean isWindows() {
        return (Platform.getOperatingSystem() & 0x5007) != 0;
    }

    public static boolean isWindows(String osName) {
        return (Platform.getOperatingSystem(osName) & 0x5007) != 0;
    }

    public static boolean is32bitArchitecture() {
        return Platform.getSystemArchitecture() == 32;
    }

    public static boolean is64bitArchitecture() {
        return Platform.getSystemArchitecture() == 64;
    }

    public static boolean supportsDynamicAttach(String jdkVersionString) {
        return "jdk16".equals(jdkVersionString) || "jdk17".equals(jdkVersionString) || "jdk18".equals(jdkVersionString) || "jdk19".equals(jdkVersionString);
    }

    public static boolean supportsThreadSleepingStateMonitoring(String jdkVersionString) {
        return jdkVersionString != null && (jdkVersionString.equals("jdk15") || jdkVersionString.equals("jdk16") || jdkVersionString.equals("jdk17") || jdkVersionString.equals("jdk18") || jdkVersionString.equals("jdk19") || jdkVersionString.equals("cvm"));
    }

    public static boolean thisVMSupportsThreadSleepingStateMonitoring() {
        return Platform.supportsThreadSleepingStateMonitoring(Platform.getJDKVersionNumber());
    }

    private static boolean supportsThreadSleepingStateMonitoring(int jdkVersionNumber) {
        return jdkVersionNumber == 2 || jdkVersionNumber == 3 || jdkVersionNumber == 4 || jdkVersionNumber == 6 || jdkVersionNumber == 7 || jdkVersionNumber == 5;
    }
}

