/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.IntroduceLocalExtensionRefactoring;
import org.netbeans.modules.refactoring.java.plugins.IntroduceLocalExtensionTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class IntroduceLocalExtensionPlugin
extends JavaRefactoringPlugin {
    private IntroduceLocalExtensionRefactoring refactoring;
    private TreePathHandle treePathHandle;

    public IntroduceLocalExtensionPlugin(IntroduceLocalExtensionRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            case CHECKPARAMETERS: 
            case FASTCHECKPARAMETERS: 
            case PRECHECK: {
                ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
            }
        }
        return null;
    }

    @Override
    protected Problem preCheck(CompilationController info) throws IOException {
        this.fireProgressListenerStart(1, 4);
        Problem preCheckProblem = null;
        info.toPhase(JavaSource.Phase.RESOLVED);
        preCheckProblem = IntroduceLocalExtensionPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        Element el = this.treePathHandle.resolveElement((CompilationInfo)info);
        if (el.getKind() != ElementKind.CLASS && el.getKind() != ElementKind.INTERFACE) {
            preCheckProblem = IntroduceLocalExtensionPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(IntroduceLocalExtensionPlugin.class, (String)"ERR_IntroduceLEWrongType"));
            return preCheckProblem;
        }
        for (Element element : el.getEnclosedElements()) {
            if (!element.getKind().isClass() && !element.getKind().isInterface() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            preCheckProblem = IntroduceLocalExtensionPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(IntroduceLocalExtensionPlugin.class, (String)"ERR_IntroduceLEInnerType"));
            return preCheckProblem;
        }
        return preCheckProblem;
    }

    @Override
    public Problem fastCheckParameters() {
        Problem fastCheckProblem = null;
        String newName = this.refactoring.getNewName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            String msg = NbBundle.getMessage(IntroduceLocalExtensionPlugin.class, (String)"ERR_InvalidIdentifier", (Object)newName);
            fastCheckProblem = IntroduceLocalExtensionPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        String targetPackageName = this.refactoring.getPackageName();
        if (!RefactoringUtils.isValidPackageName(targetPackageName)) {
            String msg = NbBundle.getMessage(IntroduceLocalExtensionPlugin.class, (String)"ERR_InvalidPackage", (Object)targetPackageName);
            fastCheckProblem = IntroduceLocalExtensionPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        FileObject targetRoot = this.refactoring.getSourceRoot();
        if (targetRoot == null) {
            String msg = NbBundle.getMessage(IntroduceLocalExtensionPlugin.class, (String)"ERR_TargetFolderNotSet", (Object)targetPackageName);
            fastCheckProblem = IntroduceLocalExtensionPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
        if (targetF != null && !targetF.canWrite()) {
            String msg = NbBundle.getMessage(IntroduceLocalExtensionPlugin.class, (String)"ERR_PackageIsReadOnly", (Object)targetPackageName);
            fastCheckProblem = IntroduceLocalExtensionPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        return super.fastCheckParameters();
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = RefactoringUtils.getClasspathInfoFor(true, this.treePathHandle.getFileObject());
        LinkedHashSet<FileObject> set = new LinkedHashSet<FileObject>();
        ClassIndex idx = cpInfo.getClassIndex();
        Set resources = idx.getResources(this.treePathHandle.getElementHandle(), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        set.addAll(resources);
        return set;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(3, a.size());
        IntroduceLocalExtensionTransformer transformer = new IntroduceLocalExtensionTransformer(this.refactoring);
        JavaRefactoringPlugin.TransformTask transform = new JavaRefactoringPlugin.TransformTask(this, transformer, this.treePathHandle);
        Problem problem = this.createAndAddElements(a, transform, refactoringElements, this.refactoring);
        this.fireProgressListenerStop();
        return problem != null ? problem : transformer.getProblem();
    }
}

