/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.api;

import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class SVNBaseDir {
    private SVNBaseDir() {
    }

    public static VCSFileProxy getBaseDir(VCSFileProxy[] files) {
        VCSFileProxy rootDir = SVNBaseDir.getRootDir(files);
        return rootDir;
    }

    public static VCSFileProxy getRootDir(VCSFileProxy[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        VCSFileProxy commonPart = files[0];
        for (int i = 0; i < files.length; ++i) {
            if ((commonPart = SVNBaseDir.getCommonPart(commonPart, files[i])) != null) continue;
            return null;
        }
        if (commonPart.isFile()) {
            return commonPart.getParentFile();
        }
        return commonPart;
    }

    private static VCSFileProxy getCommonPart(VCSFileProxy file1, VCSFileProxy file2) {
        String part2;
        String part1;
        int parts2Length;
        int parts1Length;
        String file2AbsPath;
        if (file1 == null) {
            return null;
        }
        if (file2 == null) {
            return null;
        }
        String file1AbsPath = file1.getPath();
        if (file1AbsPath.equals(file2AbsPath = file2.getPath())) {
            return file1;
        }
        String[] file1Parts = file1AbsPath.split("/");
        String[] file2Parts = file2AbsPath.split("/");
        if (file1Parts[0].equals("")) {
            file1Parts[0] = "/";
        }
        if (file2Parts[0].equals("")) {
            file2Parts[0] = "/";
        }
        int minLength = (parts1Length = file1Parts.length) >= (parts2Length = file2Parts.length) ? parts2Length : parts1Length;
        StringBuilder commonsPart = new StringBuilder();
        for (int i = 0; i < minLength && (part1 = file1Parts[i]).equals(part2 = file2Parts[i]); ++i) {
            if (i > 0) {
                commonsPart.append("/");
            }
            commonsPart.append(part1);
        }
        if (commonsPart.length() == 0) {
            return null;
        }
        return VCSFileProxySupport.getResource((VCSFileProxy)file1, (String)commonsPart.toString());
    }
}

