/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNNodeKind;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNScheduleKind;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class InfoCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z");
    private final List<String> output = new ArrayList<String>();
    private final SVNUrl url;
    private final VCSFileProxy[] files;
    private final SVNRevision revision;
    private final SVNRevision pegging;
    private final Context context;
    private final InfoType type;
    private static final String INFO_PATH = "Path";
    private static final String INFO_URL = "URL";
    private static final String INFO_REVISION = "Revision";
    private static final String INFO_REPOSITORY = "Repository Root";
    private static final String INFO_NODEKIND = "Node Kind";
    private static final String INFO_LAST_CHANGED_AUTHOR = "Last Changed Author";
    private static final String INFO_LAST_CHANGED_REVISION = "Last Changed Rev";
    private static final String INFO_LAST_CHANGED_DATE = "Last Changed Date";
    private static final String INFO_TEXT_LAST_UPDATED = "Text Last Updated";
    private static final String INFO_SCHEDULE = "Schedule";
    private static final String INFO_COPIED_FROM_URL = "Copied From URL";
    private static final String INFO_COPIED_FROM_REV = "Copied From Rev";
    private static final String INFO_PROPS_LAST_UPDATED = "Properties Last Updated";
    private static final String INFO_REPOSITORY_UUID = "Repository UUID";
    private static final String INFO_LOCK_OWNER = "Lock Owner";
    private static final String INFO_LOCK_CREATION_DATE = "Lock Created";
    private static final String INFO_LOCK_COMMENT = "Lock Comment";
    private static final String INFO_CONFLICT_PREVIOUS_BASE = "Conflict Previous Base File";
    private static final String INFO_CONFLICT_PREVIOUS_WORKING = "Conflict Previous Working File";
    private static final String INFO_CONFLICT_CURRENT_BASE = "Conflict Current Base File";

    public InfoCommand(FileSystem fileSystem, Context context, SVNUrl url, SVNRevision revision, SVNRevision pegging) {
        super(fileSystem);
        this.context = context;
        this.url = url;
        this.revision = revision;
        this.pegging = pegging;
        this.files = null;
        this.type = InfoType.url;
    }

    public InfoCommand(FileSystem fileSystem, VCSFileProxy[] files, SVNRevision revision, SVNRevision pegging) {
        super(fileSystem);
        this.files = files;
        this.context = null;
        this.revision = revision;
        this.pegging = pegging;
        this.url = null;
        this.type = InfoType.files;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.INFO;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("info");
        if (this.revision != null) {
            arguments.add(this.revision);
        }
        switch (this.type) {
            case url: {
                arguments.add(this.url, this.pegging);
                break;
            }
            case files: {
                arguments.addFileArguments(this.files);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported infotype: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public void outputText(String lineString) {
        if (lineString == null || lineString.trim().equals("")) {
            return;
        }
        this.output.add(lineString);
        super.outputText(lineString);
    }

    public ISVNInfo[] getInfo() throws SVNClientException {
        ArrayList<Info> infos = new ArrayList<Info>();
        HashMap<String, String> map = null;
        StringBuilder comment = new StringBuilder();
        for (int i = 0; i < this.output.size(); ++i) {
            int idx;
            String info;
            String outputLine = this.output.get(i);
            if (outputLine == null || outputLine.trim().equals("")) continue;
            if (outputLine.startsWith("Path:")) {
                if (map != null) {
                    infos.add(new Info(map));
                }
                map = new HashMap<String, String>();
            }
            if ((info = outputLine.substring(0, idx = outputLine.indexOf(58))).startsWith(INFO_LOCK_COMMENT)) {
                while (++i < this.output.size()) {
                    comment.append(this.output.get(i));
                    comment.append('\n');
                }
                map.put(INFO_LOCK_COMMENT, comment.toString());
            }
            String infoValue = outputLine.substring(idx + 1);
            if (map == null) continue;
            map.put(info, infoValue.trim());
        }
        if (map != null) {
            infos.add(new Info(map));
        }
        if (infos.size() == 0 && this.url != null) {
            Subversion.LOG.warning("InfoCommand: Map is null for: " + this.output);
        }
        return infos.toArray(new Info[infos.size()]);
    }

    private SVNUrl getSVNUrl(String url) {
        try {
            return new SVNUrl(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private SVNRevision.Number getNumber(String revision) {
        if (revision == null) {
            return null;
        }
        try {
            return new SVNRevision.Number(Long.parseLong(revision));
        }
        catch (NumberFormatException e) {
            return new SVNRevision.Number(-1L);
        }
    }

    private Date getDate(String date) {
        if (date == null) {
            return null;
        }
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e1) {
            return null;
        }
    }

    private class Info
    implements ISVNInfo {
        private final Map<String, String> infoMap;

        public Info(Map<String, String> infoMap) {
            this.infoMap = infoMap;
        }

        @Override
        public SVNRevision.Number getRevision() {
            return InfoCommand.this.getNumber(this.infoMap.get(InfoCommand.INFO_REVISION));
        }

        @Override
        public Date getLastDateTextUpdate() {
            return InfoCommand.this.getDate(this.infoMap.get(InfoCommand.INFO_TEXT_LAST_UPDATED));
        }

        @Override
        public String getUuid() {
            return this.infoMap.get(InfoCommand.INFO_REPOSITORY_UUID);
        }

        @Override
        public SVNUrl getRepository() {
            return InfoCommand.this.getSVNUrl(this.infoMap.get(InfoCommand.INFO_REPOSITORY));
        }

        @Override
        public SVNScheduleKind getSchedule() {
            return SVNScheduleKind.fromString(this.infoMap.get(InfoCommand.INFO_SCHEDULE));
        }

        @Override
        public Date getLastDatePropsUpdate() {
            return InfoCommand.this.getDate(this.infoMap.get(InfoCommand.INFO_PROPS_LAST_UPDATED));
        }

        @Override
        public boolean isCopied() {
            return this.getCopyRev() != null || this.getCopyUrl() != null;
        }

        @Override
        public SVNRevision.Number getCopyRev() {
            return InfoCommand.this.getNumber(this.infoMap.get(InfoCommand.INFO_COPIED_FROM_REV));
        }

        @Override
        public SVNUrl getCopyUrl() {
            return InfoCommand.this.getSVNUrl(this.infoMap.get(InfoCommand.INFO_COPIED_FROM_URL));
        }

        @Override
        public Date getLockCreationDate() {
            return InfoCommand.this.getDate(this.infoMap.get(InfoCommand.INFO_LOCK_CREATION_DATE));
        }

        @Override
        public String getLockOwner() {
            return this.infoMap.get(InfoCommand.INFO_LOCK_OWNER);
        }

        @Override
        public String getLockComment() {
            return this.infoMap.get(InfoCommand.INFO_LOCK_COMMENT);
        }

        @Override
        public VCSFileProxy getConflictNew() {
            String path = this.infoMap.get(InfoCommand.INFO_CONFLICT_CURRENT_BASE);
            return path != null ? VCSFileProxy.createFileProxy((VCSFileProxy)this.getFile().getParentFile(), (String)path) : null;
        }

        @Override
        public VCSFileProxy getConflictOld() {
            String path = this.infoMap.get(InfoCommand.INFO_CONFLICT_PREVIOUS_BASE);
            return path != null ? VCSFileProxy.createFileProxy((VCSFileProxy)this.getFile().getParentFile(), (String)path) : null;
        }

        @Override
        public VCSFileProxy getConflictWorking() {
            String path = this.infoMap.get(InfoCommand.INFO_CONFLICT_PREVIOUS_WORKING);
            return path != null ? VCSFileProxy.createFileProxy((VCSFileProxy)this.getFile().getParentFile(), (String)path) : null;
        }

        @Override
        public String getPath() {
            String path = this.infoMap.get(InfoCommand.INFO_PATH);
            if (path.startsWith("/")) {
                return path;
            }
            return "/" + path;
        }

        @Override
        public VCSFileProxy getFile() {
            if (InfoCommand.this.context != null) {
                return VCSFileProxySupport.getResource((FileSystem)InfoCommand.this.context.getFileSystem(), (String)this.getPath());
            }
            return VCSFileProxySupport.getResource((VCSFileProxy)InfoCommand.this.files[0], (String)this.getPath());
        }

        @Override
        public SVNUrl getUrl() {
            return InfoCommand.this.getSVNUrl(this.infoMap.get(InfoCommand.INFO_URL));
        }

        @Override
        public String getUrlString() {
            return this.infoMap.get(InfoCommand.INFO_URL);
        }

        @Override
        public Date getLastChangedDate() {
            return InfoCommand.this.getDate(this.infoMap.get(InfoCommand.INFO_LAST_CHANGED_DATE));
        }

        @Override
        public SVNRevision.Number getLastChangedRevision() {
            return InfoCommand.this.getNumber(this.infoMap.get(InfoCommand.INFO_LAST_CHANGED_REVISION));
        }

        @Override
        public String getLastCommitAuthor() {
            return this.infoMap.get(InfoCommand.INFO_LAST_CHANGED_AUTHOR);
        }

        @Override
        public SVNNodeKind getNodeKind() {
            return SVNNodeKind.fromString(this.infoMap.get(InfoCommand.INFO_NODEKIND));
        }

        @Override
        public int getDepth() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getPath();
        }
    }

    private static enum InfoType {
        files,
        url;

    }
}

