/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class MergeCommand
extends SvnCommand {
    private final boolean rec;
    private final boolean force;
    private final boolean ignoreAncestry;
    private final boolean dry;
    private final SVNUrl startUrl;
    private final SVNUrl endUrl;
    private final SVNRevision startRev;
    private final SVNRevision endRev;
    private final VCSFileProxy file;

    public MergeCommand(FileSystem fileSystem, SVNUrl startUrl, SVNUrl endUrl, SVNRevision startRev, SVNRevision endRev, VCSFileProxy file, boolean rec, boolean force, boolean ignoreAncestry, boolean dry) {
        super(fileSystem);
        this.rec = rec;
        this.force = force;
        this.ignoreAncestry = ignoreAncestry;
        this.dry = dry;
        this.startUrl = startUrl;
        this.endUrl = endUrl;
        this.startRev = startRev;
        this.endRev = endRev;
        this.file = file;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.MERGE;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("merge");
        if (!this.rec) {
            arguments.add("-N");
        }
        if (this.force) {
            arguments.add("--force");
        }
        if (this.dry) {
            arguments.add("--dry-run");
        }
        if (this.ignoreAncestry) {
            arguments.add("--ignore-ancestry");
        }
        if (this.startUrl.equals(this.endUrl)) {
            arguments.add(this.startUrl);
            arguments.add(this.startRev, this.endRev);
        } else {
            arguments.add(this.startUrl, this.startRev);
            arguments.add(this.endUrl, this.endRev);
        }
        arguments.add(this.file);
        this.setCommandWorkingDirectory(this.file);
    }

    @Override
    public void errorText(String line) {
        if (line.startsWith("svn: warning:")) {
            return;
        }
        super.errorText(line);
    }
}

