/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.config;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.config.KVFile;
import org.netbeans.modules.subversion.remote.config.SVNCredentialFile;
import org.netbeans.modules.subversion.remote.config.SvnConfigFiles;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class CertificateFile
extends SVNCredentialFile {
    private static final KVFile.Key CERT = new KVFile.Key(0, "ascii_cert");
    private static final KVFile.Key FAILURES = new KVFile.Key(1, "failures");
    private static final KVFile.Key REALMSTRING = new KVFile.Key(2, "svn:realmstring");
    private static final String NEWLINE = System.getProperty("line.separator");

    public CertificateFile(FileSystem fileSystem, X509Certificate cert, String realmString, int failures, boolean temporarily) throws CertificateEncodingException, IOException {
        super(CertificateFile.getNBCertFile(fileSystem, realmString));
        this.setCert(cert);
        this.setFailures(failures);
        this.setRealmString(realmString);
        if (temporarily) {
            VCSFileProxySupport.deleteOnExit((VCSFileProxy)this.getFile());
        }
    }

    @SuppressWarnings(value={"Dm"})
    private void setCert(X509Certificate cert) throws CertificateEncodingException {
        String encodedCert = Base64Encoder.encode((byte[])cert.getEncoded());
        try {
            this.setValue(this.getCertKey(), encodedCert.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            this.setValue(this.getCertKey(), encodedCert.getBytes());
        }
    }

    @Override
    protected void setRealmString(String realm) {
        this.setValue(this.getRealmstringKey(), realm);
    }

    @Override
    protected String getRealmString() {
        return this.getStringValue(this.getRealmstringKey());
    }

    private void setFailures(int failures) {
        this.setValue(this.getFailuresKey(), String.valueOf(failures));
    }

    public static VCSFileProxy getSystemCertFile(FileSystem fileSystem, String realmString) {
        VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)SvnConfigFiles.getUserConfigPath(fileSystem), (String)("auth/svn.ssl.server/" + CertificateFile.getFileName(realmString)));
        return file.normalizeFile();
    }

    public static VCSFileProxy getNBCertFile(FileSystem fileSystem, String realmString) throws IOException {
        if (SvnConfigFiles.COPY_CONFIG_FILES) {
            VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)SvnConfigFiles.getNBConfigPath(fileSystem), (String)("auth/svn.ssl.server/" + CertificateFile.getFileName(realmString)));
            return file.normalizeFile();
        }
        VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)SvnConfigFiles.getUserConfigPath(fileSystem), (String)("auth/svn.ssl.server/" + CertificateFile.getFileName(realmString)));
        return file.normalizeFile();
    }

    private KVFile.Key getCertKey() {
        return this.getKey(CERT);
    }

    private KVFile.Key getFailuresKey() {
        return this.getKey(FAILURES);
    }

    private KVFile.Key getRealmstringKey() {
        return this.getKey(REALMSTRING);
    }
}

