/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.commit;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class DeleteLocalAction
extends ContextAction {
    public static final int LOCALLY_DELETABLE_MASK = 4100;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "Delete";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 4100;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Prompt"));
        descriptor.setTitle(NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Title"));
        descriptor.setMessageType(2);
        descriptor.setOptionType(0);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (res != NotifyDescriptor.YES_OPTION) {
            return;
        }
        final Context ctx = this.getContext(nodes);
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, ctx){

            @Override
            public void perform() {
                DeleteLocalAction.performDelete(ctx, this);
            }
        };
        support.start(this.createRequestProcessor(ctx));
    }

    public static void performDelete(final Context ctx, final SvnProgressSupport support) {
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(ctx, support);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return;
        }
        if (support.isCanceled()) {
            return;
        }
        final VCSFileProxy[] files = ctx.getFiles();
        try {
            SvnUtils.runWithoutIndexing(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    for (int i = 0; i < files.length; ++i) {
                        if (support.isCanceled()) {
                            return null;
                        }
                        VCSFileProxy file = files[i];
                        FileObject fo = file.toFileObject();
                        if (fo == null) continue;
                        FileLock lock = null;
                        try {
                            try {
                                client.revert(file, false);
                            }
                            catch (SVNClientException ex) {
                                SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
                            }
                            lock = fo.lock();
                            fo.delete(lock);
                            continue;
                        }
                        catch (IOException e) {
                            Subversion.LOG.log(Level.SEVERE, NbBundle.getMessage(DeleteLocalAction.class, (String)"MSG_Cannot_lock", (Object)file.getPath()), e);
                            continue;
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                    }
                    return null;
                }
            }, files);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(null, ex, false, false);
        }
    }
}

