/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.diff;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JTextField;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.remote.ui.copy.CopyDialog;
import org.netbeans.modules.subversion.remote.ui.diff.Bundle;
import org.netbeans.modules.subversion.remote.ui.diff.SelectDiffTreePanel;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class SelectDiffTree
extends CopyDialog
implements PropertyChangeListener {
    private final RepositoryPaths repositoryPaths;
    private final VCSFileProxy root;
    private final RepositoryFile repositoryFile;

    public SelectDiffTree(RepositoryFile repositoryFile, VCSFileProxy root) {
        super(root, new SelectDiffTreePanel(), Bundle.CTL_SelectDiffTree_Title(root.getName()), Bundle.CTL_SelectDiffTree_okButton());
        int browserMode;
        String browserPurposeMessage;
        this.root = root;
        this.repositoryFile = repositoryFile;
        SelectDiffTreePanel panel = this.getSelectDiffTreePanel();
        this.setupUrlComboBox(repositoryFile, panel.urlComboBox);
        this.repositoryPaths = new RepositoryPaths(VCSFileProxySupport.getFileSystem((VCSFileProxy)root), repositoryFile, (JTextField)panel.urlComboBox.getEditor().getEditorComponent(), panel.browseRepositoryButton, panel.revisionTextField, panel.searchRevisionButton);
        this.repositoryPaths.addPropertyChangeListener(this);
        this.getSelectDiffTreePanel().getAccessibleContext().setAccessibleDescription(Bundle.CTL_SelectDiffTree_RepositoryFile());
        if (root.isFile()) {
            this.getSelectDiffTreePanel().urlLabel.setText(Bundle.CTL_SelectDiffTree_RepositoryFile());
            browserPurposeMessage = Bundle.LBL_BrowserMessageSelectDiffTreeFile();
            browserMode = 7;
        } else {
            browserPurposeMessage = Bundle.LBL_BrowserMessageSelectDiffTreeFolder();
            browserMode = 2;
        }
        this.repositoryPaths.setupBehavior(browserPurposeMessage, browserMode, "org.netbeans.modules.subversion.ui.browser.selectdifftree", "org.netbeans.modules.subversion.ui.search.selectdifftree");
    }

    RepositoryFile getRepositoryFile() {
        try {
            RepositoryFile[] repositoryFiles = this.repositoryPaths.getRepositoryFiles();
            if (repositoryFiles.length > 0) {
                return repositoryFiles[0];
            }
            SVNRevision revision = this.repositoryPaths.getRevision();
            if (revision == null) {
                return null;
            }
            SVNUrl url = SvnUtils.getRepositoryUrl(this.root);
            RepositoryFile rf = new RepositoryFile(VCSFileProxySupport.getFileSystem((VCSFileProxy)this.root), this.repositoryFile.getRepositoryUrl(), url, revision);
            return rf;
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(new Context(this.root), ex, true, true);
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.INFO, null, ex);
        }
        return null;
    }

    private SelectDiffTreePanel getSelectDiffTreePanel() {
        return (SelectDiffTreePanel)this.getPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("valid")) {
            boolean valid = (Boolean)evt.getNewValue();
            this.getOKButton().setEnabled(valid);
        }
    }
}

