/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.details;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.snaptracer.impl.details.DetailsPanel;
import org.netbeans.modules.profiler.snaptracer.impl.details.DetailsTableModel;
import org.netbeans.modules.profiler.snaptracer.impl.details.ItemValueRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.details.MarkRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.details.TimestampRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderLabel;

final class DetailsTable
extends JTable {
    private static final int DEFAULT_ROW_HEIGHT = DetailsTable.defaultRowHeight();
    static final Color DEFAULT_GRID_COLOR = new Color(240, 240, 240);
    private TableCellRenderer markRenderer;
    private TimestampRenderer timestampRenderer;

    DetailsTable() {
        this.setOpaque(true);
        this.setBackground(UIUtils.getProfilerResultsBackground());
        this.setRowHeight(DEFAULT_ROW_HEIGHT);
        this.setRowMargin(0);
        this.setAutoCreateRowSorter(true);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(true);
        this.setGridColor(DEFAULT_GRID_COLOR);
        this.getTableHeader().setPreferredSize(new Dimension(1, HeaderLabel.DEFAULT_HEIGHT));
        this.getColumnModel().setColumnMargin(1);
        this.initRenderers();
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        super.addColumn(aColumn);
        if (aColumn.getModelIndex() == 0 || aColumn.getModelIndex() == 1) {
            this.updateColumns(true);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getType() == 1) {
            this.updateColumns(false);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                int index = this.columnModel.getColumnIndexAtX(e.getPoint().x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return ((DetailsTableModel)DetailsTable.this.dataModel).getColumnTooltip(realIndex);
            }
        };
    }

    private void initRenderers() {
        this.markRenderer = this.getDefaultRenderer(Boolean.class);
        TableCellRenderer dateRenderer = this.getDefaultRenderer(String.class);
        this.timestampRenderer = new TimestampRenderer(dateRenderer);
        TableCellRenderer numberRenderer = this.getDefaultRenderer(Long.class);
        this.setDefaultRenderer(Boolean.class, new MarkRenderer(this.markRenderer));
        this.setDefaultRenderer(DetailsPanel.class, this.timestampRenderer);
        this.setDefaultRenderer(Long.class, new ItemValueRenderer(numberRenderer));
    }

    private void updateColumns(boolean initialUpdate) {
        if (this.timestampRenderer == null) {
            return;
        }
        if (initialUpdate) {
            Component boolRenderer = this.markRenderer.getTableCellRendererComponent(this, Boolean.FALSE, false, false, 0, 0);
            int width = boolRenderer.getPreferredSize().width;
            TableColumn column = this.columnModel.getColumn(0);
            TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
            Component renderer = headerRenderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, 0);
            width = Math.max(width, renderer.getPreferredSize().width);
            column.setPreferredWidth(width += 16);
            column.setMaxWidth(width);
        }
        if (this.columnModel.getColumnCount() > 1) {
            if (!this.timestampRenderer.updateFormat(this.dataModel) && !initialUpdate) {
                return;
            }
            Component renderer = this.timestampRenderer.getTableCellRendererComponent(this, 1268996399999L, false, false, 0, 1);
            TableColumn column = this.columnModel.getColumn(1);
            int width = renderer.getPreferredSize().width + 5;
            if (initialUpdate || column.getMaxWidth() < width) {
                column.setPreferredWidth(width);
                column.setMaxWidth(width);
                if (!initialUpdate) {
                    this.repaint();
                }
            }
        }
    }

    private static int defaultRowHeight() {
        return new JLabel((String)"X").getPreferredSize().height + 4;
    }
}

