/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.jboss4.config.JB7DatasourceHandler;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasource;
import org.netbeans.modules.j2ee.jboss4.config.gen.Datasources;
import org.netbeans.modules.j2ee.jboss4.config.gen.LocalTxDatasource;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class JBossDatasourceManager
implements DatasourceManager {
    private static final Logger LOGGER = Logger.getLogger(JBossDatasourceManager.class.getName());
    private static final String DSdotXML = "-ds.xml";
    private static final String JBossDSdotXML = "jboss-ds.xml";
    private final FileObject serverDir;
    private final FileObject deployDir;
    private final boolean isAs7;

    public JBossDatasourceManager(String serverUrl, boolean isAs7) {
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)serverUrl);
        String deployDirPath = ip.getProperty("deploy-dir");
        this.deployDir = FileUtil.toFileObject((File)new File(deployDirPath));
        String serverDirPath = ip.getProperty("server-dir");
        this.serverDir = FileUtil.toFileObject((File)new File(serverDirPath));
        this.isAs7 = isAs7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Datasource> getDatasources() throws ConfigurationException {
        HashSet<Datasource> datasources = new HashSet<Datasource>();
        if (this.isAs7) {
            FileObject config = this.serverDir.getFileObject("configuration/standalone.xml");
            if (config == null) {
                config = this.serverDir.getFileObject("configuration/domain.xml");
            }
            if (config == null || !config.isData()) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_CONFIG_FILE"));
                return datasources;
            }
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                JB7DatasourceHandler handler = new JB7DatasourceHandler();
                BufferedInputStream is = new BufferedInputStream(config.getInputStream());
                try {
                    parser.parse((InputStream)is, (DefaultHandler)handler);
                }
                finally {
                    ((InputStream)is).close();
                }
                datasources.addAll(handler.getDatasources());
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_CONFIG_FILE"), ex);
            }
            catch (SAXException ex) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_CONFIG_FILE"), ex);
            }
            catch (ParserConfigurationException ex) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_CONFIG_FILE"), ex);
            }
            return datasources;
        }
        if (!(this.deployDir != null && this.deployDir.isValid() && this.deployDir.isFolder() && this.deployDir.canRead())) {
            LOGGER.log(Level.WARNING, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_DEPLOY_DIR"));
            return datasources;
        }
        Enumeration files = this.deployDir.getChildren(true);
        LinkedList<FileObject> confs = new LinkedList<FileObject>();
        while (files.hasMoreElements()) {
            FileObject file = (FileObject)files.nextElement();
            if (file.isFolder() || !file.getNameExt().endsWith(DSdotXML) || !file.canRead()) continue;
            confs.add(file);
        }
        if (confs.size() == 0) {
            return datasources;
        }
        for (FileObject dsFO : confs) {
            String msg;
            File dsFile = FileUtil.toFile((FileObject)dsFO);
            try {
                Datasources ds = null;
                try {
                    ds = Datasources.createGraph(dsFile);
                }
                catch (RuntimeException re) {
                    String msg2 = NbBundle.getMessage(JBossDatasourceManager.class, (String)"MSG_NotParseableDatasources", (Object)dsFile.getAbsolutePath());
                    Logger.getLogger("global").log(Level.INFO, msg2);
                    continue;
                }
                LocalTxDatasource[] ltxds = ds.getLocalTxDatasource();
                for (int i = 0; i < ltxds.length; ++i) {
                    if (ltxds[i].getJndiName().length() <= 0) continue;
                    datasources.add(new JBossDatasource(ltxds[i].getJndiName(), ltxds[i].getConnectionUrl(), ltxds[i].getUserName(), ltxds[i].getPassword(), ltxds[i].getDriverClass()));
                }
            }
            catch (IOException ioe) {
                msg = NbBundle.getMessage(JBossDatasourceManager.class, (String)"MSG_CannotReadDatasources", (Object)dsFile.getAbsolutePath());
                throw new ConfigurationException(msg, (Throwable)ioe);
            }
            catch (RuntimeException re) {
                msg = NbBundle.getMessage(JBossDatasourceManager.class, (String)"MSG_NotParseableDatasources", (Object)dsFile.getAbsolutePath());
                throw new ConfigurationException(msg, (Throwable)re);
            }
        }
        return datasources;
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
        Set<Datasource> deployedDS = this.getDatasources();
        Map<String, Datasource> ddsMap = this.transform(deployedDS);
        HashMap<String, JBossDatasource> newDS = new HashMap<String, JBossDatasource>();
        LinkedList<Datasource> conflictDS = new LinkedList<Datasource>();
        for (Datasource o : datasources) {
            if (!(o instanceof JBossDatasource)) continue;
            JBossDatasource ds = (JBossDatasource)o;
            String jndiName = JBossDatasource.getRawName(ds.getJndiName());
            if (ddsMap.keySet().contains(jndiName)) {
                if (ddsMap.get(jndiName).equals(ds)) continue;
                conflictDS.add(ddsMap.get(jndiName));
                continue;
            }
            if (jndiName == null) continue;
            newDS.put(jndiName, ds);
        }
        if (conflictDS.size() > 0) {
            throw new DatasourceAlreadyExistsException(conflictDS);
        }
        FileObject dsXmlFo = this.deployDir.getFileObject(JBossDSdotXML);
        File dsXMLFile = dsXmlFo != null ? FileUtil.toFile((FileObject)dsXmlFo) : null;
        Datasources deployedDSGraph = null;
        try {
            deployedDSGraph = dsXMLFile != null ? Datasources.createGraph(dsXMLFile) : new Datasources();
        }
        catch (IOException ioe) {
            Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotReadDSdotXml"));
            Logger.getLogger("global").log(Level.INFO, null, ioe);
            return;
        }
        LocalTxDatasource[] ltxds = deployedDSGraph.getLocalTxDatasource();
        for (int i = 0; i < ltxds.length; ++i) {
            String jndiName = ltxds[i].getJndiName();
            if (!newDS.keySet().contains(jndiName)) continue;
            deployedDSGraph.removeLocalTxDatasource(ltxds[i]);
        }
        for (JBossDatasource ds : newDS.values()) {
            LocalTxDatasource lds = new LocalTxDatasource();
            lds.setJndiName(JBossDatasource.getRawName(ds.getJndiName()));
            lds.setConnectionUrl(ds.getUrl());
            lds.setDriverClass(ds.getDriverClassName());
            lds.setUserName(ds.getUsername());
            lds.setPassword(ds.getPassword());
            lds.setMinPoolSize(ds.getMinPoolSize());
            lds.setMaxPoolSize(ds.getMaxPoolSize());
            lds.setIdleTimeoutMinutes(ds.getIdleTimeoutMinutes());
            deployedDSGraph.addLocalTxDatasource(lds);
        }
        if (newDS.size() > 0) {
            if (dsXMLFile == null) {
                try {
                    dsXmlFo = this.deployDir.createData(JBossDSdotXML);
                }
                catch (IOException ioe) {
                    Exceptions.attachLocalizedMessage((Throwable)ioe, (String)NbBundle.getMessage(this.getClass(), (String)"ERR_CannotCreateDSdotXml"));
                    Logger.getLogger("global").log(Level.INFO, null, ioe);
                    return;
                }
                dsXMLFile = FileUtil.toFile((FileObject)dsXmlFo);
            }
            this.writeFile(dsXMLFile, deployedDSGraph);
        }
    }

    private Map<String, Datasource> transform(Set<Datasource> datasources) {
        HashMap<String, Datasource> map = new HashMap<String, Datasource>();
        for (JBossDatasource jBossDatasource : datasources) {
            if (jBossDatasource.getJndiName() == null) continue;
            map.put(jBossDatasource.getJndiName(), jBossDatasource);
        }
        return map;
    }

    private void writeFile(final File file, final BaseBean bean) throws ConfigurationException {
        try {
            FileSystem fs = this.deployDir.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = JBossDatasourceManager.this.deployDir.getFileObject(name);
                        if (configFO == null) {
                            configFO = JBossDatasourceManager.this.deployDir.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4096);
                        if (bean != null) {
                            bean.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }
}

