/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.ExpressExecutable;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.ui.wizard.BaseWizardIterator;
import org.netbeans.modules.javascript.nodejs.ui.wizard.Bundle;
import org.netbeans.modules.javascript.nodejs.ui.wizard.ExpressPanel;
import org.netbeans.modules.javascript.nodejs.ui.wizard.ProjectSetup;
import org.netbeans.modules.web.clientproject.createprojectapi.ClientSideProjectGenerator;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectProperties;
import org.netbeans.modules.web.clientproject.createprojectapi.CreateProjectUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Pair;

public final class NewProjectWizardIterator
extends BaseWizardIterator {
    private final Wizard wizard;

    private NewProjectWizardIterator(Wizard wizard) {
        assert (wizard != null);
        this.wizard = wizard;
    }

    public static NewProjectWizardIterator newNodeJsProject() {
        return new NewProjectWizardIterator(new NewNodeJsProject());
    }

    public static NewProjectWizardIterator newHtml5ProjectWithNodeJs() {
        return new NewProjectWizardIterator(new NewHtml5ProjectWithNodeJs());
    }

    @Override
    String getWizardTitle() {
        return this.wizard.getTitle();
    }

    @Override
    WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
        return this.wizard.createPanels();
    }

    @Override
    String[] createSteps() {
        return this.wizard.createSteps();
    }

    @Override
    void uninitializeInternal() {
        this.wizardDescriptor.putProperty("PROJECT_DIRECTORY", null);
        this.wizardDescriptor.putProperty("NAME", null);
        this.wizard.uninitialize(this.wizardDescriptor);
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(Bundle.NewProjectWizardIterator_progress_creating());
        HashSet<FileObject> files = new HashSet<FileObject>();
        File projectDir = FileUtil.normalizeFile((File)((File)this.wizardDescriptor.getProperty("PROJECT_DIRECTORY")));
        if (!projectDir.isDirectory() && !projectDir.mkdirs()) {
            throw new IOException("Cannot create project directory: " + projectDir);
        }
        FileObject projectDirectory = FileUtil.toFileObject((File)projectDir);
        assert (projectDirectory != null) : "FileObject must be found for " + projectDir;
        files.add(projectDirectory);
        this.wizard.readSettings(this.wizardDescriptor);
        CreateProjectProperties createProperties = new CreateProjectProperties(projectDirectory, (String)this.wizardDescriptor.getProperty("NAME")).setSourceFolder(this.wizard.getSources()).setSiteRootFolder(this.wizard.getSiteRoot()).setPlatformProvider("node.js").setStartFile(this.wizard.getStartFile()).setProjectUrl(this.wizard.getProjectUrl());
        Project project = ClientSideProjectGenerator.createProject((CreateProjectProperties)createProperties);
        this.wizard.instantiate(files, handle, this.wizardDescriptor, project);
        handle.finish();
        return files;
    }

    static FileObject createMainJsFile(FileObject sources) throws IOException {
        assert (sources != null);
        FileObject template = FileUtil.getConfigFile((String)"Templates/Other/javascript.js");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)sources);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        return dataTemplate.createFromTemplate(dataFolder, "main").getPrimaryFile();
    }

    static FileObject createIndexHtmlFile(FileObject siteRoot) throws IOException {
        assert (siteRoot != null);
        FileObject template = FileUtil.getConfigFile((String)"Templates/Other/html.html");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)siteRoot);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        return dataTemplate.createFromTemplate(dataFolder, "index").getPrimaryFile();
    }

    static final class NewHtml5ProjectWithNodeJs
    implements Wizard {
        public static final String EXPRESS_ENABLED = "EXPRESS_ENABLED";
        public static final String EXPRESS_LESS = "EXPRESS_LESS";
        private static final String EXPRESS_MAIN_JS_FILE = "app.js";
        private static final String EXPRESS_MAIN_VIEW_FILE = "views/index.jade";
        private static final String EXPRESS_RUN_FILE = "bin/www";
        private static final String EXPRESS_START_FILE = "";
        private static final String EXPRESS_PROJECT_URL = "http://localhost:3000/";
        private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> baseWizard = CreateProjectUtils.createBaseWizardPanel((String)"NodeJsWebApplication");
        private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> toolsWizard = CreateProjectUtils.createToolsWizardPanel((CreateProjectUtils.Tools)new CreateProjectUtils.Tools().setNpm(true));
        private final WizardDescriptor.FinishablePanel<WizardDescriptor> expressWizard = new ExpressPanel();
        private WizardDescriptor descriptor;

        @Override
        public String getTitle() {
            return Bundle.NewProjectWizardIterator_newHtml5ProjectWithNodeJs_displayName();
        }

        @Override
        public void readSettings(WizardDescriptor wizardDescriptor) {
            this.descriptor = wizardDescriptor;
        }

        @Override
        public String getSources() {
            return EXPRESS_START_FILE;
        }

        @Override
        public String getSiteRoot() {
            return "public";
        }

        @Override
        public String getStartFile() {
            if (this.isExpress()) {
                return EXPRESS_START_FILE;
            }
            return null;
        }

        @Override
        public String getProjectUrl() {
            if (this.isExpress()) {
                return EXPRESS_PROJECT_URL;
            }
            return null;
        }

        @Override
        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
            return new WizardDescriptor.Panel[]{(WizardDescriptor.Panel)this.baseWizard.first(), this.expressWizard, (WizardDescriptor.Panel)this.toolsWizard.first()};
        }

        @Override
        public String[] createSteps() {
            return new String[]{(String)this.baseWizard.second(), Bundle.NewHtml5ProjectWithNodeJs_express_title(), (String)this.toolsWizard.second()};
        }

        @Override
        public void instantiate(Set<FileObject> files, ProgressHandle handle, WizardDescriptor wizardDescriptor, Project project) throws IOException {
            FileObject projectDirectory = project.getProjectDirectory();
            FileObject sources = projectDirectory.getFileObject(this.getSources());
            assert (sources != null);
            if (this.isExpress()) {
                ExpressExecutable express = ExpressExecutable.getDefault(project, false);
                assert (express != null);
                Future<Integer> task = express.generate(projectDirectory, this.getBoolean(wizardDescriptor, EXPRESS_LESS, true));
                try {
                    task.get(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException | TimeoutException ex) {
                    throw new IOException(ex);
                }
                for (String mainFile : new String[]{EXPRESS_MAIN_JS_FILE, EXPRESS_MAIN_VIEW_FILE}) {
                    FileObject file = projectDirectory.getFileObject(mainFile);
                    if (file == null) continue;
                    files.add(file);
                }
                FileObject runFile = projectDirectory.getFileObject(EXPRESS_RUN_FILE);
                if (runFile != null) {
                    NodeJsSupport.forProject(project).getPreferences().setStartFile(FileUtil.toFile((FileObject)runFile).getAbsolutePath());
                }
                ProjectSetup.setupRun(project);
            } else {
                FileObject mainJsFile = NewProjectWizardIterator.createMainJsFile(sources);
                files.add(mainJsFile);
                FileObject siteRoot = projectDirectory.getFileObject(this.getSiteRoot());
                assert (siteRoot != null);
                FileObject indexHtmlFile = NewProjectWizardIterator.createIndexHtmlFile(siteRoot);
                files.add(indexHtmlFile);
                NodeJsSupport.forProject(project).getPreferences().setStartFile(FileUtil.toFile((FileObject)mainJsFile).getAbsolutePath());
            }
            CreateProjectUtils.instantiateTools((Project)project, (WizardDescriptor.FinishablePanel)((WizardDescriptor.FinishablePanel)this.toolsWizard.first()));
        }

        @Override
        public void uninitialize(WizardDescriptor wizardDescriptor) {
            wizardDescriptor.putProperty(EXPRESS_ENABLED, null);
            wizardDescriptor.putProperty(EXPRESS_LESS, null);
        }

        private boolean getBoolean(WizardDescriptor wizardDescriptor, String propertyName, boolean defaultValue) {
            Boolean value = (Boolean)wizardDescriptor.getProperty(propertyName);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        private boolean isExpress() {
            assert (this.descriptor != null);
            return this.getBoolean(this.descriptor, EXPRESS_ENABLED, false);
        }
    }

    private static final class NewNodeJsProject
    implements Wizard {
        private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> baseWizard = CreateProjectUtils.createBaseWizardPanel((String)"NodeJsApplication");
        private final Pair<WizardDescriptor.FinishablePanel<WizardDescriptor>, String> toolsWizard = CreateProjectUtils.createToolsWizardPanel((CreateProjectUtils.Tools)new CreateProjectUtils.Tools().setNpm(true));

        @Override
        public String getTitle() {
            return Bundle.NewProjectWizardIterator_newNodeJsProject_displayName();
        }

        @Override
        public void readSettings(WizardDescriptor wizardDescriptor) {
        }

        @Override
        public String getSources() {
            return "";
        }

        @Override
        public String getSiteRoot() {
            return null;
        }

        @Override
        public String getStartFile() {
            return null;
        }

        @Override
        public String getProjectUrl() {
            return null;
        }

        @Override
        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
            return new WizardDescriptor.Panel[]{(WizardDescriptor.Panel)this.baseWizard.first(), (WizardDescriptor.Panel)this.toolsWizard.first()};
        }

        @Override
        public String[] createSteps() {
            return new String[]{(String)this.baseWizard.second(), (String)this.toolsWizard.second()};
        }

        @Override
        public void instantiate(Set<FileObject> files, ProgressHandle handle, WizardDescriptor wizardDescriptor, Project project) throws IOException {
            FileObject projectDirectory = project.getProjectDirectory();
            FileObject sources = projectDirectory.getFileObject(this.getSources());
            assert (sources != null);
            FileObject mainJsFile = NewProjectWizardIterator.createMainJsFile(sources);
            files.add(mainJsFile);
            CreateProjectUtils.instantiateTools((Project)project, (WizardDescriptor.FinishablePanel)((WizardDescriptor.FinishablePanel)this.toolsWizard.first()));
            NodeJsSupport.forProject(project).getPreferences().setStartFile(FileUtil.toFile((FileObject)mainJsFile).getAbsolutePath());
            ProjectSetup.setupRun(project);
        }

        @Override
        public void uninitialize(WizardDescriptor wizardDescriptor) {
        }
    }

    private static interface Wizard {
        public static final String DEFAULT_SOURCE_FOLDER = "";
        public static final String DEFAULT_SITE_ROOT_FOLDER = "public";

        public String getTitle();

        public void readSettings(WizardDescriptor var1);

        @CheckForNull
        public String getSources();

        @CheckForNull
        public String getSiteRoot();

        @CheckForNull
        public String getStartFile();

        @CheckForNull
        public String getProjectUrl();

        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels();

        public String[] createSteps();

        public void instantiate(Set<FileObject> var1, ProgressHandle var2, WizardDescriptor var3, Project var4) throws IOException;

        public void uninitialize(WizardDescriptor var1);
    }
}

