/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.api;

import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptionListener;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class RepositoryExceptions {
    private static final CopyOnWriteArrayList<RepositoryExceptionListener> exceptionListeners = new CopyOnWriteArrayList();

    private RepositoryExceptions() {
    }

    static void addRepositoryExceptionListener(RepositoryExceptionListener listener) {
        exceptionListeners.add(listener);
    }

    static void removeRepositoryExceptionListener(RepositoryExceptionListener listener) {
        exceptionListeners.remove(listener);
    }

    public static void throwException(Object source, int unitID, CharSequence name, Throwable ex) {
        for (RepositoryExceptionListener listener : exceptionListeners) {
            listener.anExceptionHappened(unitID, name, new RepositoryException(ex));
        }
    }

    public static void throwException(Object source, Key key, Throwable ex) {
        for (RepositoryExceptionListener listener : exceptionListeners) {
            listener.anExceptionHappened(key.getUnitId(), key.getUnit(), new RepositoryException(ex));
        }
    }

    public static void throwException(Object source, Throwable ex) {
        CndUtils.printStackTraceOnce((Throwable)new RepositoryException(ex));
    }
}

