/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.api;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cnd.repository.api.RepositoryListener;
import org.openide.util.lookup.Lookups;

class RepositoryListenersManager {
    private static final RepositoryListenersManager instance = new RepositoryListenersManager();
    private CopyOnWriteArrayList<RepositoryListener> listeners = new CopyOnWriteArrayList();

    private RepositoryListenersManager() {
        Collection lst = Lookups.forPath((String)"CND/RepositoryListener").lookupAll(RepositoryListener.class);
        this.listeners = new CopyOnWriteArrayList(lst);
    }

    public static RepositoryListenersManager getInstance() {
        return instance;
    }

    public void registerListener(RepositoryListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(RepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public boolean fireUnitOpenedEvent(int unitId) {
        boolean toOpen = true;
        for (RepositoryListener theListener : this.listeners) {
            toOpen &= theListener.unitOpened(unitId);
        }
        return toOpen;
    }

    public void fireUnitClosedEvent(int unitId) {
        for (RepositoryListener theListener : this.listeners) {
            theListener.unitClosed(unitId);
        }
    }
}

