/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl;

import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;

public class RemoteLogger {
    private static final String DIAGNOSTICS_PSEUDO_MESSAGE = "__DIAGNOSTICS__";
    private static final Logger instance = Logger.getLogger("remote.support.logger");
    private static boolean assertionsEnabled;
    private static final boolean THROW_ASSERTIONS;
    private static volatile AssertionError lastAssertion;

    public static AssertionError getLastAssertion() {
        return lastAssertion;
    }

    public static boolean isDebugMode() {
        return assertionsEnabled;
    }

    private RemoteLogger() {
    }

    public static Logger getInstance() {
        return instance;
    }

    public static boolean isLoggable(Level level) {
        return instance.isLoggable(level);
    }

    public static void assertTrueInConsole(boolean value, String message, Object ... params) {
        if (assertionsEnabled && !value) {
            instance.log(Level.INFO, RemoteLogger.format(message, params));
        }
    }

    public static void assertTrue(boolean value) {
        RemoteLogger.assertTrue(value, "AssertionError", new Object[0]);
    }

    public static void assertTrue(boolean value, String message, Object ... params) {
        if (assertionsEnabled && !value) {
            message = RemoteLogger.format(message, params);
            lastAssertion = new AssertionError((Object)message);
            if (THROW_ASSERTIONS) {
                throw lastAssertion;
            }
            instance.log(Level.SEVERE, message, (Throwable)((Object)lastAssertion));
        }
    }

    public static void assertNotNull(Object value, String message, Object ... params) {
        RemoteLogger.assertTrue(value != null, message, params);
    }

    public static void assertNull(Object value, String message, Object ... params) {
        RemoteLogger.assertTrue(value == null, message, params);
    }

    public static void assertFalse(boolean value) {
        RemoteLogger.assertTrue(!value, "Assertion error", new Object[0]);
    }

    public static void assertFalse(boolean value, String message, Object ... params) {
        RemoteLogger.assertTrue(!value, message, params);
    }

    public static void assertNonUiThread(String message) {
        RemoteLogger.assertFalse(SwingUtilities.isEventDispatchThread());
    }

    public static void assertNonUiThread() {
        RemoteLogger.assertNonUiThread("Should not be called from UI thread");
    }

    public static void log(Level level, String message, Object ... args) {
        if (instance.isLoggable(level)) {
            instance.log(level, message, args);
        }
    }

    public static void finest(Exception exception) {
        instance.log(Level.FINEST, "FYI:", exception);
    }

    public static void finest(Exception exception, Object source) {
        if (instance.isLoggable(Level.FINEST)) {
            instance.log(Level.FINEST, "FYI " + source, exception);
        }
    }

    public static void fine(Exception exception) {
        instance.log(Level.FINE, "FYI:", exception);
    }

    public static void info(Exception exception) {
        if (instance.isLoggable(Level.INFO)) {
            instance.log(Level.INFO, "Exception occurred:", exception);
        }
    }

    public static void info(Exception exception, Object source) {
        if (instance.isLoggable(Level.INFO)) {
            instance.log(Level.INFO, "Exception from " + source, exception);
        }
    }

    public static void warning(Exception exception) {
        if (instance.isLoggable(Level.WARNING)) {
            instance.log(Level.WARNING, "Exception occurred:", exception);
        }
    }

    private static String format(String message, Object ... params) {
        try {
            return MessageFormat.format(message, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return message;
        }
    }

    public static void logException(Level level, String msg, Object ... params) {
        if (instance.isLoggable(level)) {
            String formattedMessage = RemoteLogger.format(msg, params);
            Exception ex = new Exception(formattedMessage);
            instance.log(level, formattedMessage, ex);
        }
    }

    public static void severeException(String msg, Object ... params) {
        RemoteLogger.logException(Level.SEVERE, msg, params);
    }

    public static void warningException(String msg, Object ... params) {
        RemoteLogger.logException(Level.WARNING, msg, params);
    }

    public static void infoException(String msg, Object ... params) {
        RemoteLogger.logException(Level.INFO, msg, params);
    }

    public static void severe(String msg, Object ... params) {
        RemoteLogger.log(Level.SEVERE, msg, params);
    }

    public static void warning(String msg, Object ... params) {
        RemoteLogger.log(Level.WARNING, msg, params);
    }

    public static void info(String msg, Object ... params) {
        RemoteLogger.log(Level.INFO, msg, params);
    }

    public static void fine(String msg, Object ... params) {
        RemoteLogger.log(Level.FINE, msg, params);
    }

    public static void finer(String msg, Object ... params) {
        RemoteLogger.log(Level.FINER, msg, params);
    }

    public static void finest(String msg, Object ... params) {
        RemoteLogger.log(Level.FINEST, msg, params);
    }

    static {
        instance.addHandler(new DiagnosticsHandler());
        assertionsEnabled = false;
        THROW_ASSERTIONS = Boolean.getBoolean("remote.throw.assertions");
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    private static class DiagnosticsHandler
    extends Handler {
        private DiagnosticsHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (record.getMessage().equals(RemoteLogger.DIAGNOSTICS_PSEUDO_MESSAGE)) {
                boolean recursive = false;
                for (Object obj : record.getParameters()) {
                    if (!(obj instanceof Boolean)) continue;
                    recursive = (Boolean)obj;
                }
                for (Object obj : record.getParameters()) {
                    if (!(obj instanceof RemoteFileObject)) continue;
                    ((RemoteFileObject)obj).getImplementor().diagnostics(recursive);
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

