/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObject;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteLink;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.netbeans.modules.remote.impl.fs.RemoteLinkChild;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.impl.fs.SpecialRemoteFileObject;
import org.netbeans.modules.remote.impl.fs.WeakCache;
import org.openide.filesystems.FileChangeListener;

public class RemoteFileObjectFactory {
    private final ExecutionEnvironment env;
    private final RemoteFileSystem fileSystem;
    private final WeakCache<String, RemoteFileObjectBase> fileObjectsCache = new WeakCache();
    private final ConcurrentHashMap<String, Boolean> unconfirmedDeletions = new ConcurrentHashMap();
    private final Object lock = new Object();
    private final Map<String, List<FileChangeListener>> pendingListeners = new HashMap<String, List<FileChangeListener>>();
    private int cacheRequests = 0;
    private int cacheHits = 0;
    private static volatile boolean reportUnexpected = true;

    public RemoteFileObjectFactory(RemoteFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.env = fileSystem.getExecutionEnvironment();
    }

    Collection<RemoteFileObjectBase> getCachedFileObjects() {
        return this.fileObjectsCache.values();
    }

    int getCachedFileObjectsCount() {
        return this.fileObjectsCache.size();
    }

    public RemoteFileObjectBase getCachedFileObject(String path) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        return this.fileObjectsCache.get(normalizedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeImplementor(RemoteDirectory parent, DirEntry oldEntry, DirEntry newEntry) {
        String path = parent.getPath() + '/' + oldEntry.getName();
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObject owner = this.invalidate(path);
            RemoteFileObjectBase remoteFileObjectBase = this.createFileObject(parent, newEntry, owner);
        }
    }

    public RemoteFileObjectBase createFileObject(RemoteDirectory parent, DirEntry entry) {
        return this.createFileObject(parent, entry, null);
    }

    public RemoteFileObjectBase createFileObject(RemoteDirectory parent, DirEntry entry, RemoteFileObject owner) {
        File childCache = new File(parent.getCache(), entry.getCache());
        String childPath = parent.getPath() + '/' + entry.getName();
        RemoteFileObjectBase fo = entry.isDirectory() ? this.createRemoteDirectory(parent, childPath, childCache, owner) : (entry.isLink() ? this.createRemoteLink(parent, childPath, entry.getLinkTarget(), owner) : (entry.isPlainFile() ? this.createRemotePlainFile(parent, childPath, childCache, owner) : this.createSpecialFile(parent, childPath, childCache, entry.getFileType(), owner)));
        assert (fo != null) : "Returning null file object for " + entry + " in " + parent;
        return fo;
    }

    public RemoteFileObjectBase register(RemoteFileObjectBase fo) {
        return this.putIfAbsent(fo.getPath(), fo);
    }

    private RemoteFileObjectBase createRemoteDirectory(final RemoteDirectory parent, String remotePath, final File cacheFile, final RemoteFileObject owner) {
        ++this.cacheRequests;
        final String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedRemotePath);
        if (fo instanceof RemoteDirectory && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        Creator creator = new Creator(){

            @Override
            public RemoteFileObjectBase create() {
                RemoteDirectory fo = new RemoteDirectory(owner == null ? new RemoteFileObject(RemoteFileObjectFactory.this.fileSystem) : owner, RemoteFileObjectFactory.this.fileSystem, RemoteFileObjectFactory.this.env, parent, normalizedRemotePath, cacheFile);
                return fo;
            }
        };
        if (parent.isValid()) {
            RemoteFileObjectBase result = this.putIfAbsent(normalizedRemotePath, creator);
            if (result instanceof RemoteDirectory && result.getParent() == parent) {
                return result;
            }
            this.reportUnexpectedPrevFileObject(result, "either not a RemoteDirectory or has different parent");
            return result;
        }
        return creator.create();
    }

    private RemoteFileObjectBase createRemotePlainFile(final RemoteDirectory parent, String remotePath, final File cacheFile, final RemoteFileObject owner) {
        ++this.cacheRequests;
        final String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedRemotePath);
        if (fo instanceof RemotePlainFile && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        Creator creator = new Creator(){

            @Override
            public RemoteFileObjectBase create() {
                RemotePlainFile fo = new RemotePlainFile(owner == null ? new RemoteFileObject(RemoteFileObjectFactory.this.fileSystem) : owner, RemoteFileObjectFactory.this.fileSystem, RemoteFileObjectFactory.this.env, parent, normalizedRemotePath, cacheFile);
                return fo;
            }
        };
        if (parent.isValid()) {
            RemoteFileObjectBase result = this.putIfAbsent(normalizedRemotePath, creator);
            if (result instanceof RemotePlainFile && result.getParent() == parent) {
                return result;
            }
            this.reportUnexpectedPrevFileObject(result, "either not a RemotePlainFile or has different parent");
            return result;
        }
        return creator.create();
    }

    private RemoteFileObjectBase createSpecialFile(final RemoteDirectory parent, String remotePath, File cacheFile, final FileInfoProvider.StatInfo.FileType fileType, final RemoteFileObject owner) {
        ++this.cacheRequests;
        final String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedRemotePath);
        if (fo instanceof SpecialRemoteFileObject && fo.isValid()) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, fo);
        }
        Creator creator = new Creator(){

            @Override
            public RemoteFileObjectBase create() {
                SpecialRemoteFileObject fo = new SpecialRemoteFileObject(owner == null ? new RemoteFileObject(RemoteFileObjectFactory.this.fileSystem) : owner, RemoteFileObjectFactory.this.fileSystem, RemoteFileObjectFactory.this.env, parent, normalizedRemotePath, fileType);
                return fo;
            }
        };
        if (parent.isValid()) {
            RemoteFileObjectBase result = this.putIfAbsent(normalizedRemotePath, creator);
            if (result instanceof SpecialRemoteFileObject && result.getParent() == parent) {
                return result;
            }
            this.reportUnexpectedPrevFileObject(result, "either not a SpecialRemoteFileObject or has different parent");
            return result;
        }
        return creator.create();
    }

    private RemoteFileObjectBase createRemoteLink(final RemoteFileObjectBase parent, String remotePath, final String link, final RemoteFileObject owner) {
        final String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        Creator creator = new Creator(){

            @Override
            public RemoteFileObjectBase create() {
                RemoteLink fo = new RemoteLink(owner == null ? new RemoteFileObject(RemoteFileObjectFactory.this.fileSystem) : owner, RemoteFileObjectFactory.this.fileSystem, RemoteFileObjectFactory.this.env, parent, normalizedRemotePath, link);
                fo.initListeners(true);
                return fo;
            }
        };
        RemoteFileObjectBase result = this.putIfAbsent(normalizedRemotePath, creator);
        return result;
    }

    public RemoteFileObjectBase createRemoteLinkChild(final RemoteLinkBase parent, String remotePath, final RemoteFileObjectBase delegate) {
        RemoteFileObjectBase oldDelegate;
        AtomicBoolean created;
        Creator creator;
        final String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase result = this.putIfAbsent(normalizedRemotePath, creator = new Creator(created = new AtomicBoolean(false)){
            final /* synthetic */ AtomicBoolean val$created;
            {
                this.val$created = atomicBoolean;
            }

            @Override
            public RemoteFileObjectBase create() {
                RemoteLinkChild fo = new RemoteLinkChild(new RemoteFileObject(RemoteFileObjectFactory.this.fileSystem), RemoteFileObjectFactory.this.fileSystem, RemoteFileObjectFactory.this.env, parent, normalizedRemotePath, delegate);
                fo.initListeners(true);
                this.val$created.set(true);
                return fo;
            }
        });
        if (result instanceof RemoteLinkChild && !created.get() && (oldDelegate = ((RemoteLinkChild)result).getCanonicalDelegate()) != delegate) {
            final RemoteFileObject ownerFileObject = result.getOwnerFileObject();
            result.invalidate();
            this.fileObjectsCache.remove(normalizedRemotePath, result);
            creator = new Creator(){

                @Override
                public RemoteFileObjectBase create() {
                    RemoteLinkChild fo = new RemoteLinkChild(ownerFileObject, RemoteFileObjectFactory.this.fileSystem, RemoteFileObjectFactory.this.env, parent, normalizedRemotePath, delegate);
                    fo.initListeners(true);
                    return fo;
                }
            };
            result = this.putIfAbsent(normalizedRemotePath, creator);
        }
        if (!(result instanceof RemoteLinkChild)) {
            this.reportUnexpectedPrevFileObject(result, "not a RemoteLinkChild");
        }
        return result;
    }

    static void testSetReportUnexpected(boolean report) {
        reportUnexpected = report;
    }

    private void reportUnexpectedPrevFileObject(RemoteFileObjectBase prevFieObject, String message) {
        if (reportUnexpected && RemoteLogger.isLoggable(Level.INFO)) {
            RemoteLogger.info(new Exception(String.format("Unexpected file object in cache, found %s %s - %s", prevFieObject.getClass().getSimpleName(), prevFieObject, message)));
        }
    }

    private RemoteFileObjectBase putIfAbsent(String remotePath, final RemoteFileObjectBase fo) {
        return this.putIfAbsent(remotePath, new Creator(){

            @Override
            public RemoteFileObjectBase create() {
                return fo;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFileObjectBase putIfAbsent(String remotePath, Creator creator) {
        this.fileObjectsCache.tryCleaningDeadEntries();
        Object object = this.lock;
        synchronized (object) {
            RemoteFileObjectBase prev = this.fileObjectsCache.get(remotePath);
            if (prev == null || !prev.isValid()) {
                RemoteFileObjectBase fo = creator.create();
                List<FileChangeListener> listeners = this.pendingListeners.remove(remotePath);
                if (listeners != null) {
                    for (FileChangeListener l : listeners) {
                        fo.addFileChangeListener(l);
                    }
                }
                this.fileObjectsCache.put(remotePath, fo);
                this.unconfirmedDeletions.remove(remotePath);
                return fo;
            }
            return prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileChangeListener(String path, FileChangeListener listener) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase fo = this.getCachedFileObject(normalizedPath);
        if (fo == null) {
            Object object = this.lock;
            synchronized (object) {
                fo = this.getCachedFileObject(normalizedPath);
                if (fo == null) {
                    List<FileChangeListener> listeners = this.pendingListeners.get(normalizedPath);
                    if (listeners == null) {
                        listeners = new ArrayList<FileChangeListener>();
                        this.pendingListeners.put(normalizedPath, listeners);
                    }
                    listeners.add(listener);
                } else {
                    fo.addFileChangeListener(listener);
                }
            }
        } else {
            fo.addFileChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileChangeListener(String path, FileChangeListener listener) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)path);
        RemoteFileObjectBase fo = this.getCachedFileObject(normalizedPath);
        if (fo == null) {
            Object object = this.lock;
            synchronized (object) {
                fo = this.getCachedFileObject(normalizedPath);
                if (fo == null) {
                    List<FileChangeListener> listeners = this.pendingListeners.get(normalizedPath);
                    if (listeners != null) {
                        listeners.remove(listener);
                    }
                } else {
                    fo.removeFileChangeListener(listener);
                }
            }
        } else {
            fo.removeFileChangeListener(listener);
        }
    }

    public void invalidate(RemoteFileObjectBase fo) {
        fo.invalidate();
        String path = PathUtilities.normalizeUnixPath((String)fo.getPath());
        this.fileObjectsCache.remove(path);
    }

    public RemoteFileObject invalidate(String remotePath) {
        String normalizedRemotePath = PathUtilities.normalizeUnixPath((String)remotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.remove(normalizedRemotePath);
        if (fo != null) {
            fo.invalidate();
            return fo.getOwnerFileObject();
        }
        return null;
    }

    public void rename(String path2Rename, String newPath, RemoteFileObjectBase fo2Rename) {
        RemoteFileObjectBase[] existentChildren = fo2Rename.isFolder() ? fo2Rename.getExistentChildren() : null;
        String normalizedPath2Rename = PathUtilities.normalizeUnixPath((String)path2Rename);
        String normalizedNewPath = PathUtilities.normalizeUnixPath((String)newPath);
        this.fileObjectsCache.remove(normalizedPath2Rename, fo2Rename);
        fo2Rename.renamePath(normalizedNewPath);
        this.putIfAbsent(normalizedNewPath, fo2Rename);
        if (existentChildren != null && existentChildren.length > 0) {
            for (RemoteFileObjectBase fo : existentChildren) {
                String curPath = fo.getPath();
                String changedPath = normalizedNewPath + '/' + fo.getNameExt();
                this.rename(curPath, changedPath, fo);
            }
        }
    }

    public void setLink(RemoteDirectory parent, String linkRemotePath, String linkTarget) {
        String normalizedPath = PathUtilities.normalizeUnixPath((String)linkRemotePath);
        RemoteFileObjectBase fo = this.fileObjectsCache.get(normalizedPath);
        if (fo != null) {
            if (fo instanceof RemoteLink) {
                ((RemoteLink)fo).setLink(linkTarget, parent);
            } else {
                RemoteLogger.getInstance().log(Level.FINE, "Called setLink on {0} - invalidating", fo.getClass().getSimpleName());
                fo.invalidate();
            }
        }
    }

    public void vcsRegisterUnconfirmedDeletion(String path) {
        this.unconfirmedDeletions.put(path, Boolean.TRUE);
    }

    public void vcsUnregisterUnconfirmedDeletion(String path) {
        this.unconfirmedDeletions.remove(path);
    }

    public boolean vcsIsUnconfirmedDeletion(String path) {
        return this.unconfirmedDeletions.get(path) != null;
    }

    private static interface Creator {
        public RemoteFileObjectBase create();
    }
}

