/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.openide.util.RequestProcessor;

public class RemoteFileZipper {
    private final ExecutionEnvironment execEnv;
    private final RequestProcessor rp;
    private final Map<String, Worker> workers = new HashMap<String, Worker>();
    private final Object workersLock = new Object();

    public RemoteFileZipper(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
        this.rp = new RequestProcessor(this.getClass().getSimpleName() + ' ' + execEnv, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(File zipFile, File zipPartFile, String path, Collection<String> extensions) {
        Object object = this.workersLock;
        synchronized (object) {
            Worker worker = this.workers.get(path);
            if (worker == null) {
                worker = new Worker(zipFile, zipPartFile, path, extensions);
                this.workers.put(path, worker);
                this.rp.post((Runnable)worker);
            }
        }
    }

    private class Worker
    implements Runnable {
        private final File zipFile;
        private final File zipPartFile;
        private final String path;
        private final Collection<String> extensions;

        public Worker(File zipFile, File zipPartFile, String path, Collection<String> extensions) {
            this.zipFile = zipFile;
            this.zipPartFile = zipPartFile;
            this.path = path;
            this.extensions = extensions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ConnectionManager.getInstance().isConnectedTo(RemoteFileZipper.this.execEnv)) {
                return;
            }
            String oldName = Thread.currentThread().getName();
            Thread.currentThread().setName(RemoteFileZipper.class.getSimpleName() + ' ' + RemoteFileZipper.this.execEnv + ": zipping " + this.path);
            try {
                this.zip();
            }
            finally {
                Thread.currentThread().setName(oldName);
                Object object = RemoteFileZipper.this.workersLock;
                synchronized (object) {
                    RemoteFileZipper.this.workers.remove(this.path);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zip() {
            Future task;
            String remoteZipPath;
            int rc;
            long time;
            block28: {
                block27: {
                    boolean all;
                    time = System.currentTimeMillis();
                    StringBuilder script = new StringBuilder("TZ=UTC; export TZ; F=`mktemp`; if [ $? -eq 0 ]; then echo ZIP=$F; rm -rf $F; ");
                    if (this.extensions == null || this.extensions.isEmpty()) {
                        all = true;
                    } else {
                        String next = this.extensions.iterator().next();
                        boolean bl = all = next == null || next.equals("*");
                    }
                    if (all) {
                        script.append("zip -rq $F ").append(this.path);
                    } else {
                        script.append("find ").append(this.path);
                        boolean first = true;
                        for (String ext : this.extensions) {
                            if (first) {
                                first = false;
                            } else {
                                script.append(" -o ");
                            }
                            script.append(" -name \"*.").append(ext).append("\"");
                        }
                        script.append(" | xargs zip -rq $F ");
                    }
                    script.append("; echo RC=$?; fi");
                    ProcessUtils.ExitStatus res = ProcessUtils.executeInDir((String)"/", (ExecutionEnvironment)RemoteFileZipper.this.execEnv, (String)"sh", (String[])new String[]{"-c", script.toString()});
                    if (!res.isOK()) {
                        RemoteLogger.info("Warmup: error zipping {0} at {1}: {2}", this.path, RemoteFileZipper.this.execEnv, res.getErrorString());
                        return;
                    }
                    RemoteLogger.fine("zipping {0} at {1} took {2}", this.path, RemoteFileZipper.this.execEnv, System.currentTimeMillis() - time);
                    String[] lines = res.getOutputString().split("\n");
                    if (lines.length < 2 || !lines[0].startsWith("ZIP=") || !lines[1].startsWith("RC=")) {
                        RemoteLogger.info("Warmup: error zipping {0} at {1}: unexpected output: {2}", this.path, RemoteFileZipper.this.execEnv, res.getOutputString());
                        return;
                    }
                    try {
                        rc = Integer.parseInt(lines[1].substring(3));
                    }
                    catch (NumberFormatException ex) {
                        RemoteLogger.info("Warmup: error zipping {0} at {1}: unexpected output: {2}", this.path, RemoteFileZipper.this.execEnv, res.getOutputString());
                        return;
                    }
                    if (rc != 0) {
                        RemoteLogger.info("Warmup: error zipping {0} at {1}: {2}", this.path, RemoteFileZipper.this.execEnv, res.getErrorString());
                        return;
                    }
                    remoteZipPath = lines[0].substring(4);
                    try {
                        time = System.currentTimeMillis();
                        this.zipPartFile.getParentFile().mkdirs();
                        task = CommonTasksSupport.downloadFile((String)remoteZipPath, (ExecutionEnvironment)RemoteFileZipper.this.execEnv, (String)this.zipPartFile.getAbsolutePath(), (Writer)new PrintWriter(System.err));
                        rc = -1;
                        try {
                            rc = (Integer)task.get();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            ex.printStackTrace(System.err);
                        }
                        if (rc == 0 || rc == 0) break block27;
                        RemoteLogger.info("Warmup: error downloading {0} at {1} to {2}, rc={3}", remoteZipPath, RemoteFileZipper.this.execEnv, this.zipPartFile.getAbsolutePath(), rc);
                    }
                    catch (Throwable throwable) {
                        time = System.currentTimeMillis();
                        Future task2 = CommonTasksSupport.rmFile((ExecutionEnvironment)RemoteFileZipper.this.execEnv, (String)remoteZipPath, (Writer)new PrintWriter(System.err));
                        rc = -1;
                        try {
                            rc = (Integer)task2.get();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ExecutionException ex) {
                            ex.printStackTrace(System.err);
                        }
                        RemoteLogger.fine("removing {0} at {1} finished with rc={2} and took {3} ms", this.path, RemoteFileZipper.this.execEnv, this.zipPartFile.getAbsolutePath(), rc, System.currentTimeMillis() - time);
                        throw throwable;
                    }
                    time = System.currentTimeMillis();
                    Future task3 = CommonTasksSupport.rmFile((ExecutionEnvironment)RemoteFileZipper.this.execEnv, (String)remoteZipPath, (Writer)new PrintWriter(System.err));
                    rc = -1;
                    try {
                        rc = (Integer)task3.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException ex) {
                        ex.printStackTrace(System.err);
                    }
                    RemoteLogger.fine("removing {0} at {1} finished with rc={2} and took {3} ms", this.path, RemoteFileZipper.this.execEnv, this.zipPartFile.getAbsolutePath(), rc, System.currentTimeMillis() - time);
                    return;
                }
                RemoteLogger.fine("uploading {0} at {1} to {2} took {3}", this.path, RemoteFileZipper.this.execEnv, this.zipPartFile.getAbsolutePath(), System.currentTimeMillis() - time);
                if (this.zipPartFile.renameTo(this.zipFile)) break block28;
                RemoteLogger.info("Warmup: error renaming {0} at {1}", this.zipPartFile.getAbsolutePath(), this.zipFile.getAbsolutePath());
            }
            time = System.currentTimeMillis();
            task = CommonTasksSupport.rmFile((ExecutionEnvironment)RemoteFileZipper.this.execEnv, (String)remoteZipPath, (Writer)new PrintWriter(System.err));
            rc = -1;
            try {
                rc = (Integer)task.get();
            }
            catch (InterruptedException task3) {
            }
            catch (ExecutionException ex) {
                ex.printStackTrace(System.err);
            }
            RemoteLogger.fine("removing {0} at {1} finished with rc={2} and took {3} ms", this.path, RemoteFileZipper.this.execEnv, this.zipPartFile.getAbsolutePath(), rc, System.currentTimeMillis() - time);
        }
    }
}

