/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.BaseNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class IndexNode
extends BaseNode {
    private final Expression index;

    public IndexNode(long token, int finish, Expression base, Expression index) {
        super(token, finish, base, false, false);
        this.index = index;
    }

    private IndexNode(IndexNode indexNode, Expression base, Expression index, boolean isFunction, boolean isSuper) {
        super(indexNode, base, isFunction, isSuper);
        this.index = index;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterIndexNode(this)) {
            return visitor.leaveIndexNode(this.setBase((Expression)this.base.accept(visitor)).setIndex((Expression)this.index.accept(visitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterIndexNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        boolean needsParen = this.tokenType().needsParens(this.base.tokenType(), true);
        if (needsParen) {
            sb.append('(');
        }
        this.base.toString(sb, printType);
        if (needsParen) {
            sb.append(')');
        }
        sb.append('[');
        this.index.toString(sb, printType);
        sb.append(']');
    }

    public Expression getIndex() {
        return this.index;
    }

    private IndexNode setBase(Expression base) {
        if (this.base == base) {
            return this;
        }
        return new IndexNode(this, base, this.index, this.isFunction(), this.isSuper());
    }

    public IndexNode setIndex(Expression index) {
        if (this.index == index) {
            return this;
        }
        return new IndexNode(this, this.base, index, this.isFunction(), this.isSuper());
    }

    @Override
    public IndexNode setIsFunction() {
        if (this.isFunction()) {
            return this;
        }
        return new IndexNode(this, this.base, this.index, true, this.isSuper());
    }

    @Override
    public IndexNode setIsSuper() {
        if (this.isSuper()) {
            return this;
        }
        return new IndexNode(this, this.base, this.index, this.isFunction(), true);
    }
}

