/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelimpl.trace.TraceModel;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class TestReparseAction
extends TestProjectActionBase {
    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TestProjectReparse");
    }

    @Override
    protected void performAction(Collection<CsmProject> csmProjects) {
        if (csmProjects != null && !csmProjects.isEmpty()) {
            for (CsmProject p : csmProjects) {
                this.testReparse(p);
            }
        }
    }

    private void testReparse(CsmProject project) {
        String task = "Parser Errors " + project.getName();
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)task);
        handle.start();
        handle.switchToDeterminate(project.getAllFiles().size());
        int handled = 0;
        InputOutput io = IOProvider.getDefault().getIO(task, false);
        io.select();
        OutputWriter out = io.getOut();
        for (CsmFile file : project.getSourceFiles()) {
            handle.progress("Parsing " + file.getName(), handled++);
            this.testReparse(file, out);
        }
        for (CsmFile file : project.getHeaderFiles()) {
            if (!TestReparseAction.isPartial(file, new HashSet<CsmFile>())) {
                handle.progress("Parsing " + file.getName(), handled++);
                this.testReparse(file, out);
                continue;
            }
            handle.progress("SKIP INCLUDED AS BODY " + file.getName(), handled++);
        }
        handle.finish();
        out.flush();
        out.close();
    }

    private static boolean isPartial(CsmFile isIncluded, Set<CsmFile> antiLoop) {
        if (antiLoop.contains(isIncluded)) {
            return false;
        }
        antiLoop.add(isIncluded);
        Collection directives = CsmIncludeHierarchyResolver.getDefault().getIncludes(isIncluded);
        for (CsmReference directive : directives) {
            CsmSelect.CsmFilter filter;
            Iterator declarations;
            if (directive == null) continue;
            int offset = directive.getStartOffset();
            CsmFile containingFile = directive.getContainingFile();
            if (containingFile == null || !(CsmSelect.hasDeclarations((CsmFile)containingFile) ? (declarations = CsmSelect.getDeclarations((CsmFile)containingFile, (CsmSelect.CsmFilter)(filter = CsmSelect.getFilterBuilder().createOffsetFilter(offset)))).hasNext() : TestReparseAction.isPartial(containingFile, antiLoop))) continue;
            return true;
        }
        return false;
    }

    private void testReparse(final CsmFile fileImpl, final OutputWriter out) {
        for (CsmInclude include : fileImpl.getIncludes()) {
            if (include.getIncludeFile() != null) continue;
            int line = include.getStartPosition().getLine();
            int column = include.getStartPosition().getColumn();
            char lBracket = include.isSystem() ? (char)'<' : '\"';
            char rBracket = include.isSystem() ? (char)'>' : '\"';
            this.printError(out, fileImpl, line, column, "Unresolved include: " + lBracket + include.getIncludeName() + rBracket);
        }
        TraceModel.getFileErrors((CsmFile)fileImpl, (TraceModel.ErrorListener)new TraceModel.ErrorListener(){

            public void error(String text, int line, int column) {
                TestReparseAction.this.printError(out, fileImpl, line, column, text);
            }
        });
    }

    private void printError(OutputWriter out, CsmFile fileImpl, int line, int column, String text) {
        ErrorInfo info = new ErrorInfo(line, column, text);
        text = fileImpl.getAbsolutePath().toString() + ':' + info.line + ':' + info.column + ": " + info.text;
        try {
            out.println(text, (OutputListener)new MyOutputListener(fileImpl, info));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class MyOutputListener
    implements OutputListener {
        private final CsmFile file;
        private final ErrorInfo info;

        public MyOutputListener(CsmFile file, ErrorInfo info) {
            this.file = file;
            this.info = info;
        }

        public void outputLineAction(OutputEvent ev) {
            CsmUtilities.openSource((CsmFile)this.file, (int)this.info.line, (int)this.info.column);
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static class ErrorInfo {
        public final int line;
        public final int column;
        public final String text;

        public ErrorInfo(int line, int column, String text) {
            this.line = line;
            this.column = column;
            this.text = text;
        }
    }
}

