/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.j2ee.deployment.config.AbstractFilesListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.openide.filesystems.FileObject;

public class ConfigFilesListener
extends AbstractFilesListener {
    private final CopyOnWriteArrayList<? extends ConfigurationFilesListener> consumers;

    public ConfigFilesListener(J2eeModuleProvider provider, CopyOnWriteArrayList<? extends ConfigurationFilesListener> consumers) {
        super(provider);
        this.consumers = consumers;
    }

    @Override
    protected File[] getTargetFiles() {
        Collection<Server> servers = ServerRegistry.getInstance().getServers();
        ArrayList<File> result = new ArrayList<File>();
        for (Server s : servers) {
            String[] paths = s.getDeploymentPlanFiles(this.provider.getJ2eeModule().getType());
            if (paths == null) continue;
            for (int j = 0; j < paths.length; ++j) {
                File f = this.provider.getJ2eeModule().getDeploymentConfigurationFile(paths[j]);
                if (f == null) continue;
                result.add(f);
            }
        }
        return result.toArray(new File[result.size()]);
    }

    @Override
    protected void targetDeleted(FileObject deleted) {
        this.fireConfigurationFilesChanged(false, deleted);
    }

    @Override
    protected void targetCreated(FileObject added) {
        this.fireConfigurationFilesChanged(true, added);
    }

    @Override
    protected void targetChanged(FileObject deleted) {
    }

    private void fireConfigurationFilesChanged(boolean added, FileObject fo) {
        for (ConfigurationFilesListener configurationFilesListener : this.consumers) {
            if (added) {
                configurationFilesListener.fileCreated(fo);
                continue;
            }
            configurationFilesListener.fileDeleted(fo);
        }
    }

    @Override
    protected boolean isTarget(FileObject fo) {
        return this.isTarget(fo.getNameExt());
    }

    @Override
    protected boolean isTarget(String fileName) {
        return ServerRegistry.getInstance().isConfigFileName(fileName, this.provider.getJ2eeModule().getType());
    }
}

