/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.ui.TemplatesImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class TreeRootNode
extends FilterNode
implements PropertyChangeListener {
    private static Image LIBRARIES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/groovy/grailsproject/resources/librariesBadge.png");
    private final SourceGroup group;
    private final Type visualType;

    TreeRootNode(DataFolder folder, SourceGroup g, GrailsProject project, Type type) {
        this((Node)new FilterNode(folder.getNodeDelegate(), folder.createNodeChildren((DataFilter)new VisibilityQueryDataFilter(g))), g, project, type);
    }

    private TreeRootNode(Node originalNode, SourceGroup group, GrailsProject project, Type type) {
        super(originalNode, (Children)new PackageFilterChildren(originalNode), (Lookup)new ProxyLookup(new Lookup[]{originalNode.getLookup(), Lookups.fixed((Object[])new Object[]{new PathFinder(group), new TemplatesImpl(project, group)})}));
        String pathName = group.getName();
        this.setShortDescription(pathName.substring(project.getProjectDirectory().getPath().length() + 1));
        this.group = group;
        this.visualType = type;
        group.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group));
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return null;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = this.group.getIcon(opened);
        if (icon == null) {
            Image image;
            Image image2 = image = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            if (Type.LIBRARY.equals((Object)this.visualType)) {
                return ImageUtilities.mergeImages((Image)image, (Image)LIBRARIES_BADGE, (int)7, (int)7);
            }
            return image;
        }
        return ImageUtilities.icon2Image((Icon)icon);
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    public String getName() {
        return this.group.getName();
    }

    public String getDisplayName() {
        return this.group.getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public static Node findPath(Node rootNode, Object object) {
        PathFinder finder = (PathFinder)rootNode.getLookup().lookup(PathFinder.class);
        if (finder != null) {
            return finder.findPath(rootNode, object);
        }
        return null;
    }

    private static final class PackageFilterNode
    extends FilterNode {
        public PackageFilterNode(Node origNode) {
            super(origNode, (Children)new PackageFilterChildren(origNode));
        }

        public void setName(String name) {
            if (Utilities.isJavaIdentifier((String)name)) {
                super.setName(name);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(TreeRootNode.class, (String)"MSG_InvalidPackageName"), 1));
            }
        }
    }

    private static final class PackageFilterChildren
    extends FilterNode.Children {
        public PackageFilterChildren(Node originalNode) {
            super(originalNode);
        }

        protected Node copyNode(Node originalNode) {
            FileObject fo = (FileObject)originalNode.getLookup().lookup(FileObject.class);
            if (fo.isFolder()) {
                return new PackageFilterNode(originalNode);
            }
            return super.copyNode(originalNode);
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    PropertyChangeListener,
    ChangeableDataFilter {
        private static final long serialVersionUID = 1L;
        private final EventListenerList ell = new EventListenerList();
        private final SourceGroup g;

        public VisibilityQueryDataFilter(SourceGroup g) {
            this.g = g;
            VisibilityQuery.getDefault().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault()));
            g.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)g));
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return this.g.contains(fo) && VisibilityQuery.getDefault().isVisible(fo);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("containership".equals(e.getPropertyName())) {
                this.fireChange();
            }
        }

        private void fireChange() {
            Object[] listeners = this.ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.ell.add(ChangeListener.class, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.ell.remove(ChangeListener.class, listener);
        }
    }

    public static final class PathFinder {
        private final SourceGroup g;

        PathFinder(SourceGroup g) {
            this.g = g;
        }

        public Node findPath(Node rootNode, Object o) {
            FileObject fo;
            if (o instanceof FileObject) {
                fo = (FileObject)o;
            } else if (o instanceof DataObject) {
                fo = ((DataObject)o).getPrimaryFile();
            } else {
                return null;
            }
            FileObject groupRoot = this.g.getRootFolder();
            if (FileUtil.isParentOf((FileObject)groupRoot, (FileObject)fo)) {
                FileObject folder = fo.isFolder() ? fo : fo.getParent();
                String relPath = FileUtil.getRelativePath((FileObject)groupRoot, (FileObject)folder);
                ArrayList<String> path = new ArrayList<String>();
                StringTokenizer strtok = new StringTokenizer(relPath, "/");
                while (strtok.hasMoreTokens()) {
                    String token = strtok.nextToken();
                    path.add(token);
                }
                try {
                    Node folderNode;
                    Node node = folderNode = folder.equals(groupRoot) ? rootNode : NodeOp.findPath((Node)rootNode, Collections.enumeration(path));
                    if (fo.isFolder()) {
                        return folderNode;
                    }
                    Node[] childs = folderNode.getChildren().getNodes(true);
                    for (int i = 0; i < childs.length; ++i) {
                        DataObject dobj = (DataObject)childs[i].getLookup().lookup(DataObject.class);
                        if (dobj == null || !dobj.getPrimaryFile().getNameExt().equals(fo.getNameExt())) continue;
                        return childs[i];
                    }
                }
                catch (NodeNotFoundException e) {
                    Logger.getLogger(TreeRootNode.class.getName()).log(Level.INFO, null, e);
                }
            } else if (groupRoot.equals(fo)) {
                return rootNode;
            }
            return null;
        }
    }

    static enum Type {
        LIBRARY,
        FOLDER;

    }
}

